/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.refund;

import cc.lechun.cms.dto.MallOrderPayDto;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderProductInvoke;
import cc.lechun.csmsapi.dao.refund.RefundMapper;
import cc.lechun.csmsapi.dao.refund.RefundPayDetailMapper;
import cc.lechun.csmsapi.dao.refund.RefundProductMapper;
import cc.lechun.csmsapi.dto.refund.RefundParamDto;
import cc.lechun.csmsapi.dto.refund.RefundPayDetailParamDto;
import cc.lechun.csmsapi.dto.refund.RefundProductParamDto;
import cc.lechun.csmsapi.entity.refund.RefundEntity;
import cc.lechun.csmsapi.entity.refund.RefundPayDetailEntity;
import cc.lechun.csmsapi.entity.refund.RefundProductEntity;
import cc.lechun.csmsapi.enums.order.OrderSourceEnum;
import cc.lechun.csmsapi.enums.refund.RefundStatusEnum;
import cc.lechun.csmsapi.iservice.oms.OmsInterceptOrderInterface;
import cc.lechun.csmsapi.iservice.order.OrderInterface;
import cc.lechun.csmsapi.iservice.refund.RefundProductInterface;
import cc.lechun.csmsapi.vo.refund.RefundProductResVo;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.omsv2.entity.order.origin.OriginOrderProductEntity;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefundProductService
extends BaseService<RefundProductEntity, String>
implements RefundProductInterface {
    @Resource
    private RefundProductMapper refundProductMapper;
    @Resource
    private RefundMapper refundMapper;
    @Resource
    private RefundPayDetailMapper refundPayDetailMapper;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Autowired
    private OrderProductInvoke orderProductInvoke;
    @Autowired
    private OmsInterceptOrderInterface omsInterceptOrderInterface;
    @Autowired
    private OrderInterface orderInterface;

    public BaseJsonVo createRefundProductInfo(RefundParamDto refundParamDto, RefundEntity refundEntity) {
        this.logger.info("=========createRefundProductInfo===refundParamDto={}", (Object)JSON.toJSONString((Object)refundParamDto));
        List refundProductParamDtoList = refundParamDto.getRefundProductList();
        for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
            if (refundProductParamDto.getRefundBalanceAmountApply().compareTo(new BigDecimal("0")) != 0 || refundProductParamDto.getRefundCashAmountApply().compareTo(new BigDecimal("0")) != 0 || !"0".equals(refundProductParamDto.getProductNum())) continue;
            return BaseJsonVo.error((String)"\u9000\u6b3e\u4ea7\u54c1\u6570\u91cf/\u4f59\u989d/\u73b0\u91d1\u6570\u636e\u90fd\u4e3a\u96f6\uff0c\u8bf7\u786e\u8ba4\u4ea7\u54c1\u662f\u5426\u9000\u6b3e");
        }
        BigDecimal refundCashAmountCount = BigDecimal.ZERO;
        BigDecimal refundBalanceAmountCount = BigDecimal.ZERO;
        if (refundProductParamDtoList != null && refundProductParamDtoList.size() > 0) {
            WxOrderRequest wxOrderRequest = new WxOrderRequest();
            wxOrderRequest.setExternalOrderNo(refundParamDto.getOrderNo());
            BaseJsonVo baseJsonVo = this.orderEcInvoke.getOrderProductList(wxOrderRequest);
            this.logger.info("+++++++++++++++++baseJsonVo={}", (Object)JSON.toJSONString((Object)baseJsonVo));
            if (baseJsonVo.isSuccess()) {
                List omsEcOrderProductEntityList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)baseJsonVo.getValue())).toJavaList(OriginOrderProductEntity.class);
                this.logger.info("+++++++++++++++++omsEcOrderProductEntityList={}", (Object)JSON.toJSONString((Object)omsEcOrderProductEntityList));
                if (omsEcOrderProductEntityList != null && omsEcOrderProductEntityList.size() > 0) {
                    ArrayList<RefundPayDetailEntity> refundPayDetailEntityList = new ArrayList<RefundPayDetailEntity>();
                    ArrayList<RefundProductEntity> refundProductEntityList = new ArrayList<RefundProductEntity>();
                    for (OriginOrderProductEntity originOrderProductEntity : omsEcOrderProductEntityList) {
                        RefundProductEntity refundProductEntity = new RefundProductEntity();
                        for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
                            if (refundProductParamDto.getRefundCashAmountApply().compareTo(new BigDecimal("0")) == 0 && refundProductParamDto.getRefundBalanceAmountApply().compareTo(new BigDecimal("0")) == 0 && refundProductParamDto.getRefundBalanceAmountCheck().compareTo(new BigDecimal("0")) == 0 && refundProductParamDto.getRefundCashAmountCheck().compareTo(new BigDecimal("0")) == 0 && !"0".equals(refundProductParamDto.getProductNum())) {
                                RefundPayDetailEntity refundPayDetailEntityNoPay = new RefundPayDetailEntity();
                                refundPayDetailEntityNoPay.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
                                refundPayDetailEntityNoPay.setRefundPayAmountCheck(refundProductEntity.getRefundBalanceAmountCheck());
                                refundPayDetailEntityNoPay.setRefundPayAmountApply(refundProductEntity.getRefundBalanceAmountApply());
                                refundPayDetailEntityNoPay.setRefundNo(refundParamDto.getRefundNo());
                                refundPayDetailEntityNoPay.setOrderNo(refundParamDto.getOrderNo());
                                refundPayDetailEntityNoPay.setRefundProductNo(refundProductEntity.getRefundProductNo());
                                refundPayDetailEntityNoPay.setPaytypeId(Integer.valueOf(-1));
                                refundPayDetailEntityNoPay.setPaytypeName("\u65e0\u9700\u652f\u4ed8");
                                refundPayDetailEntityNoPay.setIsSuccess(Integer.valueOf(0));
                                refundPayDetailEntityNoPay.setCreateId(refundParamDto.getUserName());
                                refundPayDetailEntityNoPay.setCreateTime(new Date());
                                refundPayDetailEntityList.add(refundPayDetailEntityNoPay);
                            }
                            if (!originOrderProductEntity.getProductId().equals(refundProductParamDto.getProductId())) continue;
                            refundProductEntity.setProductNum(Integer.valueOf(refundProductParamDto.getProductNum()));
                            refundProductEntity.setRefundBalanceAmountApply(refundProductParamDto.getRefundBalanceAmountApply());
                            refundProductEntity.setRefundBalanceAmountCheck(refundProductParamDto.getRefundBalanceAmountApply());
                            refundProductEntity.setRefundCashAmountApply(refundProductParamDto.getRefundCashAmountApply());
                            refundProductEntity.setRefundCashAmountCheck(refundProductParamDto.getRefundCashAmountApply());
                            refundProductEntity.setProductId(originOrderProductEntity.getProductId());
                            refundProductEntity.setProductName(originOrderProductEntity.getProductName());
                            refundProductEntity.setProductRefundAmount(refundProductEntity.getRefundBalanceAmountApply().add(refundProductEntity.getRefundCashAmountApply()));
                            if (OrderSourceEnum.CARDPLAN.getValue() == refundParamDto.getOrderSource().intValue()) {
                                List orderProductEntityListMike;
                                refundProductEntity.setRefundBalanceAmountApply(new BigDecimal(0));
                                refundProductEntity.setRefundBalanceAmountCheck(new BigDecimal(0));
                                refundProductEntity.setRefundCashAmountApply(refundProductParamDto.getRefundBalanceAmountApply());
                                refundProductEntity.setRefundCashAmountCheck(refundProductParamDto.getRefundBalanceAmountApply());
                                WxOrderRequest wxOrderRequestProduct = new WxOrderRequest();
                                wxOrderRequestProduct.setExternalOrderNo(refundEntity.getOrderNo());
                                BaseJsonVo orderProductListMikeJson = this.orderEcInvoke.getOrderProductList(wxOrderRequestProduct);
                                if (orderProductListMikeJson.isSuccess() && (orderProductEntityListMike = JSONObject.parseArray((String)JSONObject.toJSONString((Object)orderProductListMikeJson.getValue())).toJavaList(OriginOrderProductEntity.class)) != null && orderProductEntityListMike.size() > 0) {
                                    refundProductEntity.setProductId(((OriginOrderProductEntity)orderProductEntityListMike.get(0)).getProductId());
                                    refundProductEntity.setProductName(((OriginOrderProductEntity)orderProductEntityListMike.get(0)).getProductName());
                                }
                                refundProductEntity.setProductRefundAmount(refundProductEntity.getRefundBalanceAmountApply().add(refundProductEntity.getRefundCashAmountApply()));
                                refundParamDto.setOrderNo(refundEntity.getOrderNo());
                                refundParamDto.setOrderMainNo(refundEntity.getOrderMainNo());
                                WxOrderRequest wxOrderRequestOrder = new WxOrderRequest();
                                wxOrderRequestOrder.setExternalOrderNo(refundEntity.getOrderNo());
                                wxOrderRequestOrder.setRows(Integer.valueOf(15));
                                wxOrderRequestOrder.setPage(Integer.valueOf(1));
                                BaseJsonVo orderInfoJsonMike = this.orderEcInvoke.getOrderList(wxOrderRequestOrder);
                                if (orderInfoJsonMike.isSuccess()) {
                                    this.logger.info("============createRefundProductInfo=========orderInfoJsonMike={}", (Object)JSON.toJSONString((Object)orderInfoJsonMike));
                                    JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJsonMike.getValue()), JqGridData.class);
                                    List originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
                                    if (originOrderVOList != null && originOrderVOList.size() > 0) {
                                        OriginOrderVO originOrderVO = (OriginOrderVO)originOrderVOList.get(0);
                                        originOrderProductEntity.setPayType(originOrderVO.getPayType());
                                    }
                                }
                            }
                            refundProductEntity.setPayAmount(originOrderProductEntity.getPayAmount());
                            refundProductEntity.setRefundProductNo(IDGenerate.getUniqueIdStr());
                            refundProductEntity.setRefundNo(refundParamDto.getRefundNo());
                            refundProductEntity.setCreateId(refundParamDto.getUserName());
                            refundProductEntity.setCreateTime(new Date());
                            refundCashAmountCount = refundCashAmountCount.add(refundProductEntity.getRefundCashAmountApply());
                            refundBalanceAmountCount = refundBalanceAmountCount.add(refundProductEntity.getRefundBalanceAmountApply());
                            refundProductEntityList.add(refundProductEntity);
                            if (refundParamDto.getIsRefundCoupon() == 1) {
                                RefundPayDetailEntity refundPayDetailEntity = new RefundPayDetailEntity();
                                refundPayDetailEntity.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
                                refundPayDetailEntity.setRefundNo(refundParamDto.getRefundNo());
                                refundPayDetailEntity.setOrderNo(refundParamDto.getOrderNo());
                                refundPayDetailEntity.setRefundProductNo(refundProductEntity.getRefundProductNo());
                                refundPayDetailEntity.setPaytypeId(Integer.valueOf(3));
                                refundPayDetailEntity.setPaytypeName("\u4f18\u60e0\u5238");
                                refundPayDetailEntity.setIsSuccess(Integer.valueOf(0));
                                refundPayDetailEntity.setCreateId(refundParamDto.getUserName());
                                refundPayDetailEntity.setCreateTime(new Date());
                                refundPayDetailEntity.setUpdateId("");
                                refundPayDetailEntity.setUpdateTime(new Date());
                                refundPayDetailEntity.setRemark("");
                                BaseJsonVo mallOrderPayJson = this.orderProductInvoke.getOrderPayListByCsms(refundParamDto.getOrderMainNo());
                                List<Object> mallOrderPayEntitis = new ArrayList();
                                if (mallOrderPayJson.isSuccess()) {
                                    mallOrderPayEntitis = JSONObject.parseArray((String)JSONObject.toJSONString((Object)mallOrderPayJson.getValue()), MallOrderPayDto.class);
                                }
                                if ((mallOrderPayEntitis = mallOrderPayEntitis.stream().filter(c -> c.getPaytypeId() == 3).collect(Collectors.toList())) == null || mallOrderPayEntitis.size() <= 0) {
                                    return BaseJsonVo.error((String)"\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
                                }
                                refundPayDetailEntity.setTradeNo(((MallOrderPayDto)mallOrderPayEntitis.get(0)).getTradeNo());
                                refundPayDetailEntityList.add(refundPayDetailEntity);
                            }
                            if (refundProductEntity.getRefundBalanceAmountApply().compareTo(new BigDecimal(0)) > 0 || refundProductEntity.getRefundBalanceAmountCheck().compareTo(new BigDecimal(0)) > 0) {
                                RefundPayDetailEntity refundPayDetailEntityBalance = new RefundPayDetailEntity();
                                refundPayDetailEntityBalance.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
                                refundPayDetailEntityBalance.setRefundPayAmountCheck(refundProductEntity.getRefundBalanceAmountCheck());
                                refundPayDetailEntityBalance.setRefundPayAmountApply(refundProductEntity.getRefundBalanceAmountApply());
                                refundPayDetailEntityBalance.setRefundNo(refundParamDto.getRefundNo());
                                refundPayDetailEntityBalance.setOrderNo(refundParamDto.getOrderNo());
                                refundPayDetailEntityBalance.setRefundProductNo(refundProductEntity.getRefundProductNo());
                                refundPayDetailEntityBalance.setPaytypeId(Integer.valueOf(8));
                                refundPayDetailEntityBalance.setPaytypeName("\u4f59\u989d");
                                refundPayDetailEntityBalance.setIsSuccess(Integer.valueOf(0));
                                refundPayDetailEntityBalance.setCreateId(refundParamDto.getUserName());
                                refundPayDetailEntityBalance.setCreateTime(new Date());
                                BaseJsonVo mallOrderPayBalanceJson = this.orderProductInvoke.getOrderPayListByCsms(refundParamDto.getOrderMainNo());
                                List<Object> mallOrderPayBalanceJsonEntitis = new ArrayList();
                                if (mallOrderPayBalanceJson.isSuccess()) {
                                    mallOrderPayBalanceJsonEntitis = JSONObject.parseArray((String)JSONObject.toJSONString((Object)mallOrderPayBalanceJson.getValue()), MallOrderPayDto.class);
                                }
                                if ((mallOrderPayBalanceJsonEntitis = mallOrderPayBalanceJsonEntitis.stream().filter(c -> c.getPaytypeId() == 8).collect(Collectors.toList())) == null || mallOrderPayBalanceJsonEntitis.size() <= 0) {
                                    return BaseJsonVo.error((String)"\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
                                }
                                refundPayDetailEntityBalance.setTradeNo(((MallOrderPayDto)mallOrderPayBalanceJsonEntitis.get(0)).getTradeNo());
                                refundPayDetailEntityList.add(refundPayDetailEntityBalance);
                            }
                            BaseJsonVo mallOrderPayCashJson = this.orderProductInvoke.getOrderPayListByCsms(refundParamDto.getOrderMainNo());
                            List<Object> mallOrderPayCashEntitis = new ArrayList();
                            if (mallOrderPayCashJson.isSuccess()) {
                                mallOrderPayCashEntitis = JSONObject.parseArray((String)JSONObject.toJSONString((Object)mallOrderPayCashJson.getValue()), MallOrderPayDto.class);
                            }
                            if (refundProductEntity.getRefundCashAmountCheck().compareTo(new BigDecimal(0)) <= 0) continue;
                            if (originOrderProductEntity.getPayType() == 7) {
                                RefundPayDetailEntity refundPayDetailEntity1 = new RefundPayDetailEntity();
                                refundPayDetailEntity1.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
                                refundPayDetailEntity1.setRefundPayAmountCheck(refundProductEntity.getRefundCashAmountCheck());
                                refundPayDetailEntity1.setRefundPayAmountApply(refundProductEntity.getRefundCashAmountApply());
                                refundPayDetailEntity1.setRefundNo(refundParamDto.getRefundNo());
                                refundPayDetailEntity1.setOrderNo(refundParamDto.getOrderNo());
                                refundPayDetailEntity1.setRefundProductNo(refundProductEntity.getRefundProductNo());
                                refundPayDetailEntity1.setPaytypeId(originOrderProductEntity.getPayType());
                                refundPayDetailEntity1.setPaytypeName("\u94f6\u884c");
                                refundPayDetailEntity1.setIsSuccess(Integer.valueOf(0));
                                refundPayDetailEntity1.setCreateId(refundParamDto.getUserName());
                                refundPayDetailEntity1.setCreateTime(new Date());
                                mallOrderPayCashEntitis = mallOrderPayCashEntitis.stream().filter(c -> c.getPaytypeId() == 7).collect(Collectors.toList());
                                if (mallOrderPayCashEntitis == null || mallOrderPayCashEntitis.size() <= 0) {
                                    return BaseJsonVo.error((String)"\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
                                }
                                refundPayDetailEntity1.setTradeNo(((MallOrderPayDto)mallOrderPayCashEntitis.get(0)).getTradeNo());
                                refundPayDetailEntityList.add(refundPayDetailEntity1);
                            }
                            if (originOrderProductEntity.getPayType() != 2) continue;
                            RefundPayDetailEntity refundPayDetailEntity2 = new RefundPayDetailEntity();
                            refundPayDetailEntity2.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
                            refundPayDetailEntity2.setRefundPayAmountCheck(refundProductEntity.getRefundCashAmountCheck());
                            refundPayDetailEntity2.setRefundPayAmountApply(refundProductEntity.getRefundCashAmountApply());
                            refundPayDetailEntity2.setRefundNo(refundParamDto.getRefundNo());
                            refundPayDetailEntity2.setOrderNo(refundParamDto.getOrderNo());
                            refundPayDetailEntity2.setRefundProductNo(refundProductEntity.getRefundProductNo());
                            refundPayDetailEntity2.setPaytypeId(originOrderProductEntity.getPayType());
                            refundPayDetailEntity2.setPaytypeName("\u5fae\u4fe1");
                            refundPayDetailEntity2.setIsSuccess(Integer.valueOf(0));
                            refundPayDetailEntity2.setCreateId(refundParamDto.getUserName());
                            refundPayDetailEntity2.setCreateTime(new Date());
                            mallOrderPayCashEntitis = mallOrderPayCashEntitis.stream().filter(c -> "2".equals(c.getPaytypeId())).collect(Collectors.toList());
                            if (mallOrderPayCashEntitis == null || mallOrderPayCashEntitis.size() <= 0) {
                                return BaseJsonVo.error((String)"\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
                            }
                            refundPayDetailEntity2.setTradeNo(((MallOrderPayDto)mallOrderPayCashEntitis.get(0)).getTradeNo());
                            refundPayDetailEntityList.add(refundPayDetailEntity2);
                        }
                    }
                    this.logger.info("=======refundProductEntityList==========refundProductEntityList={}", (Object)JSON.toJSONString(refundProductEntityList));
                    this.refundProductMapper.batchInsert(refundProductEntityList);
                    this.logger.info("=======refundPayDetailEntityList==========refundPayDetailEntityList={}", (Object)JSON.toJSONString(refundPayDetailEntityList));
                    this.refundPayDetailMapper.batchInsert(refundPayDetailEntityList);
                }
            }
        }
        RefundEntity refundEntityUpdate = new RefundEntity();
        refundEntityUpdate.setRefundNo(refundParamDto.getRefundNo());
        this.logger.info("=======refundCashAmountCount====refundCashAmountCount={}", (Object)refundCashAmountCount);
        refundEntityUpdate.setRefundAmountApply(refundCashAmountCount.add(refundBalanceAmountCount));
        refundEntityUpdate.setRefundAmountCheck(refundCashAmountCount.add(refundBalanceAmountCount));
        this.refundMapper.updateRefundByParam(refundEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u9000\u6b3e\u4ea7\u54c1\u4fe1\u606f\u6210\u529f");
    }

    public BaseJsonVo updateRefundProductInfo(RefundParamDto refundParamDto, String agreeStatus) {
        BaseJsonVo omsBaseJson;
        List refundProductParamDtoList = refundParamDto.getRefundProductList();
        BigDecimal refundCashAmountCount = BigDecimal.ZERO;
        BigDecimal refundBalanceAmountCount = BigDecimal.ZERO;
        RefundEntity refundEntity = new RefundEntity();
        refundEntity.setRefundNo(refundParamDto.getRefundNo());
        refundEntity = (RefundEntity)this.refundMapper.getSingle((Object)refundEntity);
        if (refundProductParamDtoList != null && refundProductParamDtoList.size() > 0) {
            for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
                RefundProductEntity refundProductEntity = new RefundProductEntity();
                refundProductEntity.setRefundProductNo(refundProductParamDto.getRefundProductNo());
                refundProductEntity.setProductNum(Integer.valueOf(refundProductParamDto.getProductNum()));
                refundProductEntity.setRefundCashAmountCheck(refundProductParamDto.getRefundCashAmountApply());
                refundProductEntity.setRefundBalanceAmountCheck(refundProductParamDto.getRefundBalanceAmountApply());
                refundProductEntity.setProductRefundAmount(refundProductEntity.getRefundBalanceAmountCheck().add(refundProductEntity.getRefundCashAmountCheck()));
                refundProductEntity.setUpdateId(refundParamDto.getUserName());
                refundProductEntity.setUpdateTime(new Date());
                refundCashAmountCount = refundCashAmountCount.add(refundProductEntity.getRefundCashAmountCheck());
                refundBalanceAmountCount = refundBalanceAmountCount.add(refundProductEntity.getRefundBalanceAmountCheck());
                if (this.refundProductMapper.updateRefundProductByParam(refundProductEntity) <= 0) {
                    return BaseJsonVo.error((String)"\u66f4\u65b0\u9000\u6b3e\u4ea7\u54c1\u4fe1\u606f\u5931\u8d25");
                }
                for (RefundPayDetailParamDto refundPayDetailParamDto : refundProductParamDto.getRefundPayDetailEntityList()) {
                    RefundPayDetailEntity refundPayDetailEntity = new RefundPayDetailEntity();
                    refundPayDetailEntity.setRefundPayDetailNo(refundPayDetailParamDto.getRefundPayDetailNo());
                    refundPayDetailEntity.setRefundPayAmountCheck(refundPayDetailParamDto.getRefundPayAmountCheck());
                    if (refundPayDetailParamDto.getPaytypeId() == 7 || refundPayDetailParamDto.getPaytypeId() == 2) {
                        refundPayDetailEntity.setRefundPayAmountCheck(refundProductParamDto.getRefundCashAmountApply());
                    }
                    if (refundPayDetailParamDto.getPaytypeId() == 10) {
                        refundPayDetailEntity.setRefundPayAmountCheck(refundProductParamDto.getRefundBalanceAmountApply());
                    }
                    refundPayDetailEntity.setUpdateId(refundParamDto.getUserName());
                    refundPayDetailEntity.setUpdateTime(new Date());
                    this.refundPayDetailMapper.updateRefundPayDetailByParam(refundPayDetailEntity);
                }
            }
        }
        refundEntity.setRefundAmountCheck(refundCashAmountCount.add(refundBalanceAmountCount));
        refundEntity.setUpdateId(refundParamDto.getUserName());
        refundEntity.setUpdateTime(new Date());
        if ("agree".equals(agreeStatus)) {
            refundEntity.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_AGREEE.getValue()));
            refundParamDto.setAfterSaleStatus(String.valueOf(RefundStatusEnum.REFUND_AGREEE.getValue()));
        } else {
            refundEntity.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_DISAGREEE.getValue()));
            refundParamDto.setAfterSaleStatus(String.valueOf(RefundStatusEnum.REFUND_DISAGREEE.getValue()));
        }
        refundEntity.setIsRefundCoupon(Integer.valueOf(refundParamDto.getIsRefundCoupon()));
        this.refundMapper.updateRefundCheckByParam(refundEntity);
        refundParamDto.setAfterSaleType(refundEntity.getAfterSaleType());
        List wxOrderEntityVOList = this.orderInterface.listWxOrderList(refundParamDto);
        if ("agree".equals(agreeStatus)) {
            this.logger.info("************updateRefundProductInfo*****afterSaleAgree******wxOrderEntityVOList={}", (Object)JsonUtils.toJson((Object)wxOrderEntityVOList, (boolean)false));
            omsBaseJson = this.orderEcInvoke.afterSaleAgree(wxOrderEntityVOList);
            this.logger.info("************OMS\u62e6\u5355 return param******omsBaseJson={}", (Object)JsonUtils.toJson((Object)omsBaseJson, (boolean)false));
            if (omsBaseJson.getStatus() != 200) {
                return BaseJsonVo.error((String)"OMS\u62e6\u5355\uff0c\u540c\u610f\u9000\u6b3e\u5931\u8d25");
            }
        } else {
            this.logger.info("************updateRefundProductInfo*****afterSaleAdd******wxOrderEntityVOList={}", (Object)JsonUtils.toJson((Object)wxOrderEntityVOList, (boolean)false));
            omsBaseJson = this.omsInterceptOrderInterface.afterSaleAdd(wxOrderEntityVOList);
            this.logger.info("*********createRefundInfo********response param omsBaseJson={}", (Object)JsonUtils.toJson((Object)omsBaseJson, (boolean)false));
            if (omsBaseJson.getStatus() != 200) {
                return BaseJsonVo.error((String)"oms\u62e6\u5355\uff0c\u62d2\u7edd\u9000\u6b3e\u5931\u8d25");
            }
        }
        return BaseJsonVo.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public List<RefundProductResVo> selectRefundProductList(RefundProductEntity refundProductEntity) {
        return this.refundProductMapper.selectRefundProductList(refundProductEntity);
    }

    public RefundProductEntity queryRefundProductByParam(RefundProductEntity refundProductEntity) {
        return this.refundProductMapper.queryRefundProductByParam(refundProductEntity);
    }
}

