/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.refund;

import cc.lechun.csmsapi.apiinvoke.order.MallOrderInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.dao.refund.RefundMapper;
import cc.lechun.csmsapi.dto.refund.RefundParamDto;
import cc.lechun.csmsapi.dto.refund.RefundProductParamDto;
import cc.lechun.csmsapi.dto.refund.RefundQueryDTO;
import cc.lechun.csmsapi.entity.refund.RefundEntity;
import cc.lechun.csmsapi.entity.refund.RefundPayDetailEntity;
import cc.lechun.csmsapi.entity.refund.RefundProductEntity;
import cc.lechun.csmsapi.entity.refund.RefundRecordEntity;
import cc.lechun.csmsapi.entity.user.UserInfo;
import cc.lechun.csmsapi.enums.order.OrderSourceEnum;
import cc.lechun.csmsapi.enums.refund.DataPlatFormEnum;
import cc.lechun.csmsapi.enums.refund.RefundReasonCodeEnum;
import cc.lechun.csmsapi.enums.refund.RefundStatusEnum;
import cc.lechun.csmsapi.enums.refund.TmallRefundStatusEnum;
import cc.lechun.csmsapi.iservice.oms.OmsInterceptOrderInterface;
import cc.lechun.csmsapi.iservice.order.OrderInterface;
import cc.lechun.csmsapi.iservice.refund.RefundInterface;
import cc.lechun.csmsapi.iservice.refund.RefundPayDetailInterface;
import cc.lechun.csmsapi.iservice.refund.RefundProductInterface;
import cc.lechun.csmsapi.iservice.refund.RefundRecordInterface;
import cc.lechun.csmsapi.iservice.user.UserInterface;
import cc.lechun.csmsapi.service.refund.RefundService;
import cc.lechun.csmsapi.vo.refund.Refund;
import cc.lechun.csmsapi.vo.refund.RefundDTO;
import cc.lechun.csmsapi.vo.refund.RefundProductResVo;
import cc.lechun.csmsapi.vo.refund.RefundResVo;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.omsv2.entity.order.origin.OriginOrderProductEntity;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class RefundService
extends BaseService<RefundEntity, String>
implements RefundInterface {
    @Resource
    private RefundMapper refundMapper;
    @Autowired
    private RefundProductInterface refundProductInterface;
    @Autowired
    private RefundPayDetailInterface refundPayDetailInterface;
    @Autowired
    private RefundRecordInterface refundRecordInterface;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Autowired
    private MallOrderInvoke mallOrderInvoke;
    @Autowired
    UserInterface userInterface;
    @Autowired
    private OrderInterface orderInterface;
    @Autowired
    private OmsInterceptOrderInterface omsInterceptOrderInterface;
    @Value(value="${erp.reduceInventory.url}")
    private String reduceInventory;

    public BaseJsonVo<UserInfo> getUserInfo(HttpServletRequest request) {
        BaseJsonVo userInfo = this.userInterface.getUserInfo(request);
        return userInfo;
    }

    public BaseJsonVo listRefundInfoPage(RefundQueryDTO refundQueryDTO) {
        this.logger.info("******RefundService*********listRefundInfoPage*******refundQueryDTO={}", (Object)JSON.toJSONString((Object)refundQueryDTO));
        if (refundQueryDTO.getCurrentPage() == null) {
            refundQueryDTO.setCurrentPage(Integer.valueOf(1));
        }
        if (refundQueryDTO.getPageSize() == null) {
            refundQueryDTO.setPageSize(Integer.valueOf(15));
        }
        List refundEntityList = new ArrayList();
        Page refundEntityPage = PageHelper.startPage((int)refundQueryDTO.getCurrentPage(), (int)refundQueryDTO.getPageSize());
        RefundEntity refundEntity = new RefundEntity();
        refundEntity.setRefundNo(refundQueryDTO.getRefundNo());
        refundEntity.setOrderNo(refundQueryDTO.getOrderNo());
        refundEntity.setRefundStatus(refundQueryDTO.getRefundStatus());
        refundEntity.setDataPlatform(refundQueryDTO.getDataPlatform());
        this.logger.info("******RefundService*********listRefundInfoPage*******refundEntity={}", (Object)JSON.toJSONString((Object)refundEntity));
        refundEntityList = this.refundMapper.listRefundInfo(refundEntity);
        this.logger.info("******RefundService*********listRefundInfoPage*******refundEntityList={}", (Object)JSON.toJSONString(refundEntityList));
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(refundEntityList);
        pageInfo.setTotal(refundEntityPage.getTotal());
        return BaseJsonVo.success((Object)pageInfo);
    }

    public BaseJsonVo updateLogisticsInfo(RefundParamDto refundParamDto) {
        this.logger.info("******RefundService*********updateLogisticsInfo*******refundParamDto={}", (Object)JSON.toJSONString((Object)refundParamDto));
        RefundEntity refundEntity = new RefundEntity();
        refundEntity.setLogisticsName(refundParamDto.getLogisticsName());
        refundEntity.setLogisticsId(refundParamDto.getLogisticsId());
        refundEntity.setLogisticsNo(refundParamDto.getLogisticsNo());
        refundEntity.setRefundNo(refundParamDto.getRefundNo());
        this.refundMapper.updateLogisticsInfo(refundEntity);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo queryRefundList(RefundParamDto refundParamDto) {
        this.logger.info("++++++++++++++++++++++refundParamDto={}", (Object)JSON.toJSONString((Object)refundParamDto));
        WxOrderRequest wxOrderRequestProduct = new WxOrderRequest();
        wxOrderRequestProduct.setExternalOrderNo(refundParamDto.getOrderNo());
        BaseJsonVo baseJsonVo = this.orderEcInvoke.getOrderProductList(wxOrderRequestProduct);
        this.logger.info("+++++++++++++++++baseJsonVo={}", (Object)JSON.toJSONString((Object)baseJsonVo));
        List<RefundResVo> refundResVoList = null;
        BigDecimal refundNumAmountMax = new BigDecimal("0");
        if (baseJsonVo.isSuccess()) {
            List omsEcOrderProductEntityList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)baseJsonVo.getValue())).toJavaList(OriginOrderProductEntity.class);
            this.logger.info("+++++++++++++++++omsEcOrderProductEntityList={}", (Object)JSON.toJSONString((Object)omsEcOrderProductEntityList));
            refundResVoList = new ArrayList();
            if (refundParamDto.getPageType() == 1) {
                RefundResVo refundResVo = new RefundResVo();
                refundResVo.setCouponPay(false);
                refundResVo.setOrderSource(refundParamDto.getOrderSource());
                refundResVo.setRefundNo(IDGenerate.getUniqueIdStr());
                WxOrderRequest wxOrderRequest = new WxOrderRequest();
                wxOrderRequest.setExternalOrderNo(refundParamDto.getOrderNo());
                wxOrderRequest.setPage(Integer.valueOf(1));
                wxOrderRequest.setRows(Integer.valueOf(15));
                BaseJsonVo orderInfoJson = this.orderEcInvoke.getOrderList(wxOrderRequest);
                this.logger.info("==================orderInfoJson={}", (Object)JSON.toJSONString((Object)orderInfoJson));
                if (orderInfoJson.isSuccess()) {
                    JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJson.getValue()), JqGridData.class);
                    List originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
                    this.logger.info("==================originOrderVOList={}", (Object)JSON.toJSONString((Object)originOrderVOList));
                    if (originOrderVOList != null && originOrderVOList.size() > 0 && omsEcOrderProductEntityList != null && omsEcOrderProductEntityList.size() > 0) {
                        OriginOrderVO omsEcOrderResInfoDto = (OriginOrderVO)originOrderVOList.get(0);
                        if (omsEcOrderResInfoDto.getPayCouponPerAmount().compareTo(new BigDecimal("0")) > 0) {
                            refundResVo.setCouponPay(true);
                        }
                        refundResVo.setOrderNo(omsEcOrderResInfoDto.getExternalOrderNo());
                        refundResVo.setOrderMainNo(omsEcOrderResInfoDto.getExternalMainOrderNo());
                        refundResVo.setPayAmount(omsEcOrderResInfoDto.getPayAmount());
                        if (omsEcOrderResInfoDto.getOrderStatus() <= 10) {
                            refundResVo.setAfterSaleType("1");
                        } else {
                            refundResVo.setAfterSaleType("2");
                        }
                        ArrayList<RefundProductResVo> refundProductResVoList = new ArrayList<RefundProductResVo>();
                        String refundProductNo = IDGenerate.getUniqueIdStr();
                        for (OriginOrderProductEntity omsEcOrderProductEntity : omsEcOrderProductEntityList) {
                            RefundProductResVo refundProductResVo = new RefundProductResVo();
                            refundProductResVo.setPayAmount(omsEcOrderProductEntity.getPayAmount());
                            refundProductResVo.setRefundProductNo(refundProductNo);
                            refundProductResVo.setRefundNo(refundResVo.getRefundNo());
                            refundProductResVo.setProductId(omsEcOrderProductEntity.getProductId());
                            refundProductResVo.setProductName(omsEcOrderProductEntity.getProductName());
                            RefundDTO refundDTO = new RefundDTO();
                            if (OrderSourceEnum.CARDPLAN.getValue() == omsEcOrderResInfoDto.getOrderSource().intValue()) {
                                refundDTO.setOtherTkOrderNo(refundParamDto.getOrderNo());
                            } else {
                                refundDTO.setOrderNo(refundParamDto.getOrderNo());
                            }
                            ArrayList<String> refundStatusList = new ArrayList<String>(3);
                            refundStatusList.add(String.valueOf(RefundStatusEnum.REFUND_APPLY.getValue()));
                            refundStatusList.add(String.valueOf(RefundStatusEnum.REFUND_AGREEE.getValue()));
                            refundStatusList.add(String.valueOf(RefundStatusEnum.REFUND_FINISH.getValue()));
                            refundDTO.setRefundStatusList(refundStatusList);
                            List refundEntityList = this.refundMapper.listRefundByParam(refundDTO);
                            this.logger.info("********queryRefundList*******refundEntityList={},refundDTO={}", (Object)JsonUtils.toJson((Object)refundEntityList, (boolean)false), (Object)JsonUtils.toJson((Object)refundDTO, (boolean)false));
                            if (refundEntityList != null && refundEntityList.size() > 0) {
                                if (OrderSourceEnum.CARDPLAN.getValue() == omsEcOrderResInfoDto.getOrderSource().intValue()) {
                                    refundProductResVo.setProductRefundMax(Integer.valueOf(0));
                                    refundProductResVo.setProductCashAmountMax(new BigDecimal(0));
                                    refundProductResVo.setProductBalanceAmountMax(new BigDecimal(0));
                                } else {
                                    int productNum = 0;
                                    BigDecimal cashAmount = new BigDecimal("0");
                                    BigDecimal balanceAmount = new BigDecimal("0");
                                    for (RefundEntity refundEntity : refundEntityList) {
                                        RefundProductEntity refundProductEntity = new RefundProductEntity();
                                        refundProductEntity.setRefundNo(refundEntity.getRefundNo());
                                        refundProductEntity.setProductId(omsEcOrderProductEntity.getProductId());
                                        refundProductEntity = this.refundProductInterface.queryRefundProductByParam(refundProductEntity);
                                        this.logger.info("============refundProductEntity={}", (Object)JSON.toJSONString((Object)refundProductEntity));
                                        if (refundProductEntity == null) {
                                            refundProductResVo.setProductRefundMax(Integer.valueOf(omsEcOrderProductEntity.getProductNum().intValue()));
                                            refundProductResVo.setProductCashAmountMax(omsEcOrderProductEntity.getCashAmount());
                                            refundProductResVo.setProductBalanceAmountMax(omsEcOrderProductEntity.getPayBalancePerAmount());
                                            continue;
                                        }
                                        cashAmount = cashAmount.add(refundProductEntity.getRefundCashAmountCheck());
                                        balanceAmount = balanceAmount.add(refundProductEntity.getRefundBalanceAmountCheck());
                                        refundProductResVo.setProductRefundMax(Integer.valueOf(omsEcOrderProductEntity.getProductNum().intValue() - (productNum += refundProductEntity.getProductNum().intValue())));
                                        refundProductResVo.setProductCashAmountMax(omsEcOrderProductEntity.getCashAmount().subtract(cashAmount));
                                        refundProductResVo.setProductBalanceAmountMax(omsEcOrderProductEntity.getPayBalancePerAmount().subtract(balanceAmount));
                                    }
                                    refundNumAmountMax = refundNumAmountMax.add(omsEcOrderProductEntity.getPayAmount().add(omsEcOrderProductEntity.getProductNum()).subtract(new BigDecimal(productNum).add(cashAmount).add(balanceAmount)));
                                    this.logger.info("============queryRefundList************refundNumAmountMax={}", (Object)refundNumAmountMax);
                                }
                            } else {
                                refundProductResVo.setProductRefundMax(Integer.valueOf(omsEcOrderProductEntity.getProductNum().intValue()));
                                refundProductResVo.setProductCashAmountMax(omsEcOrderProductEntity.getCashAmount());
                                refundProductResVo.setProductBalanceAmountMax(omsEcOrderProductEntity.getPayBalancePerAmount());
                                refundNumAmountMax = refundNumAmountMax.add(refundProductResVo.getProductBalanceAmountMax()).add(refundProductResVo.getProductCashAmountMax()).add(new BigDecimal(refundProductResVo.getProductRefundMax()));
                            }
                            refundProductResVo.setProductPrice(omsEcOrderProductEntity.getProductSellPrice());
                            refundProductResVo.setProductNum(Integer.valueOf(omsEcOrderProductEntity.getProductNum().intValue()));
                            refundProductResVo.setProductRefundAmount(omsEcOrderProductEntity.getProductSellAmount());
                            refundProductResVo.setRefundCashAmountApply(omsEcOrderProductEntity.getCashAmount());
                            refundProductResVo.setRefundBalanceAmountApply(omsEcOrderProductEntity.getPayBalancePerAmount());
                            refundProductResVo.setRefundCashAmountCheck(omsEcOrderProductEntity.getCashAmount());
                            refundProductResVo.setRefundBalanceAmountCheck(omsEcOrderProductEntity.getPayBalancePerAmount());
                            refundProductResVo.setIsGroup(omsEcOrderProductEntity.getIsPromotion());
                            refundProductResVo.setGroupId(omsEcOrderProductEntity.getPromotionId());
                            refundProductResVo.setGroupName(omsEcOrderProductEntity.getPromotionName());
                            refundProductResVoList.add(refundProductResVo);
                        }
                        this.logger.info("********queryRefundList*******=refundProductResVoList={},", (Object)JsonUtils.toJson(refundProductResVoList, (boolean)false));
                        WxOrderRequest wxOrderRequest1 = new WxOrderRequest();
                        wxOrderRequest1.setExternalMainOrderNo(omsEcOrderResInfoDto.getExternalMainOrderNo());
                        wxOrderRequest1.setPage(Integer.valueOf(1));
                        wxOrderRequest1.setRows(Integer.valueOf(15));
                        BaseJsonVo orderInfoListJson = this.orderEcInvoke.getOrderList(wxOrderRequest1);
                        this.logger.info("=============orderInfoListJson={}", (Object)JSON.toJSONString((Object)orderInfoListJson));
                        if (orderInfoListJson.isSuccess()) {
                            JqGridData jqGridData1 = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoListJson.getValue()), JqGridData.class);
                            List originOrderVOList1 = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData1.getRows()), OriginOrderVO.class);
                            this.logger.info("==================omsEcOrderResInfoDtoList1={}", (Object)JSON.toJSONString((Object)originOrderVOList1));
                            if (originOrderVOList1 != null && originOrderVOList1.size() > 0) {
                                int statusNum = 0;
                                for (OriginOrderVO originOrderVO : originOrderVOList1) {
                                    if (originOrderVO.getOrderStatus() != 10) continue;
                                    ++statusNum;
                                }
                                if (statusNum == originOrderVOList1.size()) {
                                    // empty if block
                                }
                            }
                        }
                        refundResVo.setRefundProductResVoList(refundProductResVoList);
                        refundResVo.setRefundNumAmountMax(refundNumAmountMax);
                    }
                    refundResVoList.add(refundResVo);
                }
            } else {
                refundResVoList = this.listRefundResVo(refundResVoList, refundParamDto, refundNumAmountMax);
            }
        } else {
            refundResVoList = this.listRefundResVo(refundResVoList, refundParamDto, refundNumAmountMax);
        }
        return BaseJsonVo.success((Object)refundResVoList);
    }

    private List<RefundResVo> listRefundResVo(List<RefundResVo> refundResVoList, RefundParamDto refundParamDto, BigDecimal refundNumAmountMax) {
        refundResVoList = this.selectRefundList(refundParamDto);
        for (RefundResVo refundResVo : refundResVoList) {
            RefundProductEntity refundProductEntity = new RefundProductEntity();
            refundProductEntity.setRefundNo(refundResVo.getRefundNo());
            List refundProductResVoList = this.refundProductInterface.selectRefundProductList(refundProductEntity);
            for (RefundProductResVo refundProductResVo : refundProductResVoList) {
                RefundPayDetailEntity refundPayDetailEntity = new RefundPayDetailEntity();
                refundPayDetailEntity.setRefundProductNo(refundProductResVo.getRefundProductNo());
                List refundPayDetailEntityList = this.refundPayDetailInterface.selectRefundPayDetailList(refundPayDetailEntity);
                refundProductResVo.setRefundPayDetailEntityList(refundPayDetailEntityList);
                refundProductResVo.setProductRefundMax(refundProductResVo.getProductNum());
                refundProductResVo.setProductCashAmountMax(refundProductResVo.getRefundCashAmountCheck());
                refundProductResVo.setProductBalanceAmountMax(refundProductResVo.getRefundBalanceAmountCheck());
                refundNumAmountMax = refundNumAmountMax.add(refundProductResVo.getProductBalanceAmountMax()).add(refundProductResVo.getProductCashAmountMax()).add(new BigDecimal(refundProductResVo.getProductRefundMax()));
            }
            refundResVo.setRefundNumAmountMax(refundNumAmountMax);
            refundResVo.setRefundProductResVoList(refundProductResVoList);
        }
        return refundResVoList;
    }

    @Transactional
    public BaseJsonVo refundApply(HttpServletRequest request, String refundParam) {
        this.logger.info("=========refundApply==refundParam={}", (Object)refundParam);
        RefundParamDto refundParamDto = (RefundParamDto)JSONObject.parseObject((String)refundParam, RefundParamDto.class);
        BaseJsonVo userInfoJson = this.getUserInfo(request);
        String userName = "";
        if (userInfoJson.isSuccess()) {
            userName = ((UserInfo)userInfoJson.getValue()).getUserName();
        }
        refundParamDto.setUserName(userName);
        BaseJsonVo refundInfoJson = this.createRefundInfo(refundParamDto);
        if (refundInfoJson.isSuccess()) {
            RefundEntity refundEntity = (RefundEntity)refundInfoJson.getValue();
            refundParamDto.setRefundNo(refundEntity.getRefundNo());
            BaseJsonVo refundProductInfoJson = this.refundProductInterface.createRefundProductInfo(refundParamDto, refundEntity);
            if (refundProductInfoJson.isSuccess()) {
                BaseJsonVo mallBaseJsonVO = this.refundOrderStatusByForce(refundParamDto, 20);
                if (mallBaseJsonVO.isSuccess()) {
                    return BaseJsonVo.success((Object)"\u6210\u529f");
                }
                return BaseJsonVo.error((String)"\u5546\u57ce\u7cfb\u7edf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
            }
            throw new RuntimeException(refundProductInfoJson.getMessage());
        }
        throw new RuntimeException(refundInfoJson.getMessage());
    }

    @Transactional
    public BaseJsonVo refundCheck(HttpServletRequest request, String refundParam, String agreeStatus) {
        this.logger.info("===========refundChecnk.refundParam={}", (Object)refundParam);
        RefundParamDto refundParamDto = (RefundParamDto)JSONObject.parseObject((String)refundParam, RefundParamDto.class);
        BaseJsonVo userInfoJson = this.getUserInfo(request);
        String userName = "";
        if (userInfoJson.isSuccess()) {
            userName = ((UserInfo)userInfoJson.getValue()).getUserName();
        }
        refundParamDto.setUserName(userName);
        BaseJsonVo updateRefundProductInfoJson = this.refundProductInterface.updateRefundProductInfo(refundParamDto, agreeStatus);
        if (updateRefundProductInfoJson.isSuccess()) {
            BaseJsonVo mallBaseJsonVO = this.refundOrderStatusByForce(refundParamDto, 26);
            if (mallBaseJsonVO.isSuccess()) {
                return BaseJsonVo.success((Object)"\u6210\u529f");
            }
            return BaseJsonVo.error((String)"\u5546\u57ce\u7cfb\u7edf\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        throw new RuntimeException(updateRefundProductInfoJson.getMessage());
    }

    public BaseJsonVo refundCancel(HttpServletRequest request, RefundParamDto refundParamDto) {
        this.logger.info("===========refundCancel******refundParamDto={}", (Object)JSON.toJSONString((Object)refundParamDto));
        BaseJsonVo userInfoJson = this.getUserInfo(request);
        String userName = "";
        if (userInfoJson.isSuccess()) {
            userName = ((UserInfo)userInfoJson.getValue()).getUserName();
        }
        refundParamDto.setUserName(userName);
        BaseJsonVo cancelRefundJson = this.updateRefundCancel(refundParamDto);
        RefundEntity refundEntity = new RefundEntity();
        refundEntity.setRefundNo(refundParamDto.getRefundNo());
        refundEntity = (RefundEntity)this.refundMapper.getSingle((Object)refundEntity);
        refundParamDto.setAfterSaleType(refundEntity.getAfterSaleType());
        refundParamDto.setAfterSaleStatus(String.valueOf(RefundStatusEnum.REFUND_CANCEL.getValue()));
        if (cancelRefundJson.isSuccess()) {
            List wxOrderEntityVOList = this.orderInterface.listWxOrderList(refundParamDto);
            BaseJsonVo omsBaseJson = this.omsInterceptOrderInterface.afterSaleAdd(wxOrderEntityVOList);
            this.logger.info("*********createRefundInfo********response param omsBaseJson={},Request param wxOrderEntityVO={}", (Object)JsonUtils.toJson((Object)omsBaseJson, (boolean)false), (Object)JsonUtils.toJson((Object)wxOrderEntityVOList, (boolean)false));
            if (omsBaseJson.getStatus() != 200) {
                return BaseJsonVo.error((String)"oms\u62e6\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e");
            }
        }
        return cancelRefundJson;
    }

    public BaseJsonVo updateRefundCancel(RefundParamDto refundParamDto) {
        RefundEntity refundEntity = new RefundEntity();
        refundEntity.setRefundNo(refundParamDto.getRefundNo());
        refundEntity.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_CANCEL.getValue()));
        int i = this.refundMapper.updateRefundStatusByParam(refundEntity);
        if (i >= 0) {
            return BaseJsonVo.success((Object)"\u53d6\u6d88\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u53d6\u6d88\u5931\u8d25");
    }

    public BaseJsonVo createRefundInfo(RefundParamDto refundParamDto) {
        refundParamDto.setAfterSaleStatus(String.valueOf(RefundStatusEnum.REFUND_APPLY.getValue()));
        RefundEntity refundEntity = new RefundEntity();
        List refundProductParamDtoList = refundParamDto.getRefundProductList();
        BigDecimal refundCashAmountCount = BigDecimal.ZERO;
        BigDecimal refundBalanceAmountCount = BigDecimal.ZERO;
        if (refundProductParamDtoList != null && refundProductParamDtoList.size() > 0) {
            for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
                refundCashAmountCount = refundCashAmountCount.add(refundProductParamDto.getRefundCashAmountApply());
                refundBalanceAmountCount = refundBalanceAmountCount.add(refundProductParamDto.getRefundBalanceAmountApply());
            }
        }
        refundEntity.setRefundAmountCheck(refundCashAmountCount.add(refundBalanceAmountCount));
        refundEntity.setRefundAmountApply(refundCashAmountCount.add(refundBalanceAmountCount));
        refundEntity.setRefundNo(IDGenerate.getUniqueIdStr());
        refundEntity.setOrderMainNo(refundParamDto.getOrderMainNo());
        refundEntity.setOrderNo(refundParamDto.getOrderNo());
        refundEntity.setDataPlatform(DataPlatFormEnum.WX_MALL.getValue());
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setExternalOrderNo(refundParamDto.getOrderNo());
        wxOrderRequest.setRows(Integer.valueOf(15));
        wxOrderRequest.setPage(Integer.valueOf(1));
        BaseJsonVo orderInfoJson = this.orderEcInvoke.getOrderList(wxOrderRequest);
        this.logger.info("============createRefundInfo=========orderInfoJson={}", (Object)JsonUtils.toJson((Object)orderInfoJson, (boolean)false));
        if (orderInfoJson.isSuccess()) {
            JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJson.getValue()), JqGridData.class);
            List originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
            if (originOrderVOList != null && originOrderVOList.size() > 0) {
                OriginOrderVO originOrderVO = (OriginOrderVO)originOrderVOList.get(0);
                refundEntity.setPayAmount(originOrderVO.getPayAmount());
                if (originOrderVO.getOrderStatus() <= 10) {
                    refundEntity.setAfterSaleType("1");
                    refundParamDto.setAfterSaleType("1");
                } else {
                    refundEntity.setAfterSaleType("2");
                    refundParamDto.setAfterSaleType("2");
                }
                if (OrderSourceEnum.CARDPLAN.getValue() == refundParamDto.getOrderSource().intValue()) {
                    String sourceOrderNo = originOrderVO.getSourceOrderMainNo();
                    WxOrderRequest wxOrderRequestMike = new WxOrderRequest();
                    wxOrderRequestMike.setExternalMainOrderNo(sourceOrderNo);
                    wxOrderRequestMike.setRows(Integer.valueOf(15));
                    wxOrderRequestMike.setPage(Integer.valueOf(1));
                    BaseJsonVo orderInfoJsonMike = this.orderEcInvoke.getOrderList(wxOrderRequestMike);
                    this.logger.info("============createRefundInfoMike=========orderInfoJsonMike={}", (Object)JsonUtils.toJson((Object)orderInfoJsonMike, (boolean)false));
                    if (orderInfoJsonMike.isSuccess()) {
                        JqGridData jqGridDataMike = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJsonMike.getValue()), JqGridData.class);
                        List originOrderVOListMike = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridDataMike.getRows()), OriginOrderVO.class);
                        if (originOrderVOList != null && originOrderVOList.size() > 0) {
                            OriginOrderVO originOrderVOMike = (OriginOrderVO)originOrderVOListMike.get(0);
                            refundEntity.setOrderMainNo(originOrderVOMike.getExternalMainOrderNo());
                            refundEntity.setOrderNo(originOrderVOMike.getExternalOrderNo());
                            refundEntity.setOtherTkOrderNo(refundParamDto.getOrderNo());
                            refundEntity.setPayAmount(originOrderVOMike.getPayAmount());
                            this.logger.info("===============createRefundInfoMike=====refundBalanceAmountCount={}", (Object)refundBalanceAmountCount);
                            refundEntity.setRefundAmountCheck(refundBalanceAmountCount);
                            refundEntity.setRefundAmountApply(refundBalanceAmountCount);
                            refundEntity.setAfterSaleType("2");
                        }
                    }
                }
            }
            refundEntity.setRefundType(Integer.valueOf(refundParamDto.getRefundType()));
            refundEntity.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_APPLY.getValue()));
            refundEntity.setRefundReasonCode(Integer.valueOf(refundParamDto.getRefundReasonCode()));
            refundEntity.setRefundReason(RefundReasonCodeEnum.getName((int)Integer.valueOf(refundParamDto.getRefundReasonCode())));
            refundEntity.setIsRefundCoupon(Integer.valueOf(refundParamDto.getIsRefundCoupon()));
            refundEntity.setCreateId(refundParamDto.getUserName());
            refundEntity.setCreateTime(new Date());
            refundEntity.setRemark(refundParamDto.getRemark());
            this.logger.info("===============createRefundInfo=====refundEntity={}", (Object)JsonUtils.toJson((Object)refundEntity, (boolean)false));
            List wxOrderEntityVOList = this.orderInterface.listWxOrderList(refundParamDto);
            this.logger.info("===============createRefundInfo=====wxOrderEntityVOList={}", (Object)JsonUtils.toJson((Object)wxOrderEntityVOList, (boolean)false));
            BaseJsonVo omsBaseJson = this.omsInterceptOrderInterface.afterSaleAdd(wxOrderEntityVOList);
            this.logger.info("*********createRefundInfo********response param omsBaseJson={}", (Object)JsonUtils.toJson((Object)omsBaseJson, (boolean)false));
            if (omsBaseJson.getStatus() != 200) {
                return BaseJsonVo.error((String)"oms\u62e6\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e");
            }
            if (this.refundMapper.insert((Object)refundEntity) <= 0) {
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u9000\u6b3e\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            return BaseJsonVo.error((String)"\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)refundEntity);
    }

    public List<RefundResVo> selectRefundList(RefundParamDto refundParamDto) {
        return this.refundMapper.selectRefundList(refundParamDto);
    }

    public List<RefundEntity> queryRefundInfoByParam(RefundEntity refundEntity) {
        return this.refundMapper.queryRefundInfoByParam(refundEntity);
    }

    public List<RefundEntity> queryRefundInfoByRefundStatusUpdateTime(int refundStatus, Date updateTime) {
        return this.refundMapper.queryRefundInfoByRefundStatusUpdateTime(refundStatus, updateTime);
    }

    public BaseJsonVo buildRefundRecord(String refundPayDetailNo) {
        RefundPayDetailEntity refundPayDetailEntity = (RefundPayDetailEntity)this.refundPayDetailInterface.selectByPrimaryKey((Serializable)((Object)refundPayDetailNo));
        if (refundPayDetailEntity == null) {
            return BaseJsonVo.error((String)("\u9000\u6b3e\u660e\u7ec6\u4e0d\u5b58\u5728refundPayDetailNo:" + refundPayDetailNo));
        }
        if (refundPayDetailEntity.getPaytypeId() == 2) {
            RefundRecordEntity refundRecordEntity = new RefundRecordEntity();
            refundRecordEntity.setRefundPayDetailNo(refundPayDetailEntity.getRefundPayDetailNo());
            refundRecordEntity.setIsSuccess(Integer.valueOf(0));
            refundRecordEntity = this.refundRecordInterface.queryRefundRecordByParam(refundRecordEntity);
            if (refundRecordEntity == null) {
                return this.buildRefundRecord(refundPayDetailEntity, refundPayDetailNo);
            }
            return BaseJsonVo.success((Object)refundRecordEntity.getRefundRecordId());
        }
        return this.buildRefundRecord(refundPayDetailEntity, refundPayDetailNo);
    }

    public RefundEntity getReturnAmountTotalByInfo(RefundEntity refundEntity) {
        return this.refundMapper.getReturnAmountTotalByInfo(refundEntity);
    }

    private BaseJsonVo buildRefundRecord(RefundPayDetailEntity refundPayDetailEntity, String refundPayDetailNo) {
        String recordId = IDGenerate.getUniqueIdStr();
        RefundRecordEntity refundRecordEntity = new RefundRecordEntity();
        refundRecordEntity.setRefundRecordId(recordId);
        refundRecordEntity.setRefundAmount(refundPayDetailEntity.getRefundPayAmountCheck().multiply(new BigDecimal(100)));
        refundRecordEntity.setIsSuccess(Integer.valueOf(0));
        refundRecordEntity.setCreateTime(new Date());
        refundRecordEntity.setTradeNo(recordId);
        refundRecordEntity.setRefundPayDetailNo(refundPayDetailNo);
        if (this.refundRecordInterface.insert((Object)refundRecordEntity) == 0) {
            return BaseJsonVo.error((String)("\u521b\u5efa\u9000\u6b3e\u8bb0\u5f55\u5931\u8d25refundPayDetailNo:" + refundPayDetailNo));
        }
        return BaseJsonVo.success((Object)recordId);
    }

    @Transactional
    public BaseJsonVo successOrderRefund(String refundId, int payTypeId, String tradeNo) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        try {
            RefundEntity refundEntity = (RefundEntity)this.refundMapper.selectByPrimaryKey((Serializable)((Object)refundId));
            if (refundEntity == null) {
                throw new Exception("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
            }
            refundEntity.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_FINISH.getValue()));
            this.refundMapper.updateRefundStatusByParam(refundEntity);
            this.refundPayDetailInterface.SuccessOrderRefund(refundId, payTypeId);
            this.refundRecordInterface.updateSuccess(tradeNo);
            RefundParamDto refundParamDto = new RefundParamDto();
            refundParamDto.setOrderNo(refundEntity.getOrderNo());
            refundParamDto.setOrderMainNo(refundEntity.getOrderMainNo());
            BaseJsonVo baseJsonVo = this.refundOrderStatusByForce(refundParamDto, 27);
            if (!baseJsonVo.isSuccess()) {
                throw new Exception(baseJsonVo.getMessage());
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u9000\u6b3e\u5b8c\u6210\u5931\u8d25,param:refundId:" + refundId + ",result:" + e.getMessage());
            return BaseJsonVo.error((String)("\u9000\u6b3e\u5b8c\u6210\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return jsonVo;
    }

    public BaseJsonVo refundOrderStatusByForce(RefundParamDto refundParamDto, int orderStatus) {
        JqGridData jqGridData;
        List originOrderVOList;
        OriginOrderVO omsEcOrderResInfoDto = new OriginOrderVO();
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setExternalOrderNo(refundParamDto.getOrderNo());
        wxOrderRequest.setPage(Integer.valueOf(1));
        wxOrderRequest.setRows(Integer.valueOf(15));
        BaseJsonVo orderInfoJson = this.orderEcInvoke.getOrderList(wxOrderRequest);
        if (orderInfoJson.isSuccess() && (originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)(jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJson.getValue()), JqGridData.class)).getRows()), OriginOrderVO.class)) != null && originOrderVOList.size() > 0 && !"1325743461067264000".equals((omsEcOrderResInfoDto = (OriginOrderVO)originOrderVOList.get(0)).getShopId()) && !"1325743461067264001".equals(omsEcOrderResInfoDto.getShopId())) {
            return BaseJsonVo.success((Object)"");
        }
        this.logger.info("***********refundOrderStatusByForce******refundParamDto={},orderStatus={}", (Object)JsonUtils.toJson((Object)refundParamDto, (boolean)false), (Object)orderStatus);
        int refundAll = 0;
        BaseJsonVo mallBaseJsonVO = new BaseJsonVo();
        RefundEntity refundEntityOrderNo = new RefundEntity();
        refundEntityOrderNo.setOrderNo(refundParamDto.getOrderNo());
        refundEntityOrderNo.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_FINISH.getValue()));
        refundEntityOrderNo = this.refundMapper.getReturnAmountTotalByInfo(refundEntityOrderNo);
        this.logger.info("***********refundOrderStatusByForce******refundEntityOrderNo={}", (Object)JsonUtils.toJson((Object)refundEntityOrderNo, (boolean)false));
        RefundEntity refundEntityOrderMian = new RefundEntity();
        refundEntityOrderMian.setOrderMainNo(refundParamDto.getOrderMainNo());
        refundEntityOrderMian.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_FINISH.getValue()));
        refundEntityOrderMian = this.refundMapper.getReturnAmountSumByOrderMain(refundEntityOrderMian);
        this.logger.info("***********refundOrderStatusByForce******refundEntityOrderMian={}", (Object)JsonUtils.toJson((Object)refundEntityOrderMian, (boolean)false));
        BigDecimal refundAmountCheckSum = new BigDecimal("0");
        List refundProductParamDtoList = refundParamDto.getRefundProductList();
        if (refundProductParamDtoList != null && refundProductParamDtoList.size() > 0) {
            for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
                refundAmountCheckSum = refundAmountCheckSum.add(refundProductParamDto.getRefundCashAmountApply()).add(refundProductParamDto.getRefundBalanceAmountApply());
            }
        }
        WxOrderRequest wxOrderRequest1 = new WxOrderRequest();
        wxOrderRequest1.setExternalMainOrderNo(refundParamDto.getOrderMainNo());
        wxOrderRequest1.setPage(Integer.valueOf(1));
        wxOrderRequest1.setRows(Integer.valueOf(1000));
        BaseJsonVo orderInfoListJson = this.orderEcInvoke.getOrderList(wxOrderRequest1);
        BigDecimal payAmountSumBig = new BigDecimal("0");
        List originOrderVOList1 = new ArrayList();
        if (orderInfoListJson.isSuccess()) {
            JqGridData jqGridData1 = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoListJson.getValue()), JqGridData.class);
            originOrderVOList1 = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData1.getRows()), OriginOrderVO.class);
            if (originOrderVOList1 != null && originOrderVOList1.size() > 0) {
                for (OriginOrderVO originOrderVO : originOrderVOList1) {
                    payAmountSumBig = payAmountSumBig.add(originOrderVO.getPayAmount());
                }
            }
        } else {
            return orderInfoListJson;
        }
        this.logger.info("**********refundOrderStatusByForce*******payAmountSumBig={}", (Object)payAmountSumBig);
        if (refundEntityOrderNo == null) {
            if (refundAmountCheckSum.compareTo(omsEcOrderResInfoDto.getPayAmount()) == 0 && refundAmountCheckSum.compareTo(payAmountSumBig) == 0) {
                refundAll = 1;
            }
        } else {
            this.logger.info("*******refundOrderStatusByForce********refundAmountCheckSum={}", (Object)refundAmountCheckSum);
            if (refundAmountCheckSum.add(refundEntityOrderNo.getRefundAmountCheck()).compareTo(refundEntityOrderNo.getPayAmount()) == 0 && refundEntityOrderMian.getRefundAmountCheck().add(refundAmountCheckSum).compareTo(payAmountSumBig) == 0) {
                refundAll = 1;
            }
        }
        this.logger.info("***********response param orderNo={},refundAll={},orderStatus={}", new Object[]{refundParamDto.getOrderNo(), refundAll, orderStatus});
        mallBaseJsonVO = this.mallOrderInvoke.refundOrderStatusByForce(refundParamDto.getOrderNo(), Integer.valueOf(refundAll), Integer.valueOf(orderStatus));
        this.logger.info("**********refundApply*****mallBaseJsonVO={}", (Object)JsonUtils.toJson((Object)mallBaseJsonVO, (boolean)false));
        return mallBaseJsonVO;
    }

    public BaseJsonVo createRefundInfoByThird(Refund refund) {
        this.logger.info("=========createRefundInfoByThird======refund={}", (Object)JsonUtils.toJson((Object)refund, (boolean)false));
        if (refund != null) {
            RefundEntity refundEntity = new RefundEntity();
            refundEntity.setRefundNo(refund.getRefundId());
            refundEntity.setOrderMainNo(String.valueOf(refund.getTid()));
            refundEntity.setOrderNo(String.valueOf(refund.getOid()));
            refundEntity.setPayAmount(new BigDecimal(refund.getPayment()));
            if (refund.getHasGoodReturn().booleanValue()) {
                refundEntity.setRefundType(Integer.valueOf(2));
            } else {
                refundEntity.setRefundType(Integer.valueOf(1));
            }
            if ("onsale".equals(refund.getRefundPhase())) {
                refundEntity.setAfterSaleType("1");
            } else {
                refundEntity.setAfterSaleType("2");
            }
            refundEntity.setRefundAmountApply(new BigDecimal(refund.getRefundFee()));
            refundEntity.setRefundAmountCheck(new BigDecimal(refund.getRefundFee()));
            switch (1.$SwitchMap$cc$lechun$csmsapi$enums$refund$TmallRefundStatusEnum[TmallRefundStatusEnum.getByValue((String)refund.getStatus()).ordinal()]) {
                case 1: {
                    refundEntity.setRefundStatus(Integer.valueOf(TmallRefundStatusEnum.getValue((String)"WAIT_SELLER_AGREE")));
                    break;
                }
                case 2: {
                    refundEntity.setRefundStatus(Integer.valueOf(TmallRefundStatusEnum.getValue((String)"WAIT_BUYER_RETURN_GOODS")));
                    break;
                }
                case 3: {
                    refundEntity.setRefundStatus(Integer.valueOf(TmallRefundStatusEnum.getValue((String)"SELLER_REFUSE_BUYER")));
                    break;
                }
                case 4: {
                    refundEntity.setRefundStatus(Integer.valueOf(TmallRefundStatusEnum.getValue((String)"SUCCESS")));
                    break;
                }
                case 5: {
                    refundEntity.setRefundStatus(Integer.valueOf(TmallRefundStatusEnum.getValue((String)"CLOSED")));
                    break;
                }
                default: {
                    refundEntity.setRefundStatus(Integer.valueOf(TmallRefundStatusEnum.getValue((String)"WAIT_SELLER_AGREE")));
                }
            }
            refundEntity.setRefundReason(refund.getReason());
            refundEntity.setLogisticsName(refund.getCompanyName());
            refundEntity.setLogisticsNo(refund.getSid());
            refundEntity.setCreateTime(DateUtils.getDateFromString((String)refund.getCreated()));
            refundEntity.setUpdateTime(DateUtils.getDateFromString((String)refund.getModified()));
            refundEntity.setDataPlatform(DataPlatFormEnum.TAOBAO_MALL.getValue());
            this.refundMapper.insert((Object)refundEntity);
        }
        return BaseJsonVo.success((Object)"");
    }
}

