/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.api;

import cc.lechun.cms.dto.ActiveDTO;
import cc.lechun.customers.api.CashticketApi;
import cc.lechun.customers.apiinvoke.cms.ActiveInvoke;
import cc.lechun.customers.apiinvoke.mall.CouponInvoke;
import cc.lechun.customers.dto.cashticket.CashticketCustomerRecordVo;
import cc.lechun.customers.entity.cashticket.CashticketBatchEntity;
import cc.lechun.customers.entity.cashticket.CashticketEntity;
import cc.lechun.customers.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.customers.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.customers.iservice.cashticket.CashticketInterface;
import cc.lechun.framework.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CashticketApiImpl
implements CashticketApi {
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private CouponInvoke couponInvoke;
    @Autowired
    private ActiveInvoke activeInvoke;

    @RequestMapping(value={"/getCashticketList"})
    public BaseJsonVo getCustomerCashticketList(String customerId, Integer pageSize, Integer pageCount) {
        Page page = this.cashticketCustomerInterface.getCustomerCashticketList(customerId, pageSize, pageCount);
        PageInfo pg = page.toPageInfo();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Long.valueOf(page.getTotal()));
        map.put("pageSize", pageSize);
        map.put("pages", Integer.valueOf(page.getPages()));
        map.put("pageNum", pageCount);
        if (pg.getList() != null && pg.getList().size() > 0) {
            ArrayList list = new ArrayList();
            pg.getList().forEach(o -> {
                CashticketCustomerRecordVo c = new CashticketCustomerRecordVo();
                BeanUtils.copyProperties((Object)o, (Object)c);
                CashticketEntity cashticketEntity = this.cashticketInterface.getCashticket(o.getTicketId().intValue());
                if (cashticketEntity != null) {
                    BeanUtils.copyProperties((Object)cashticketEntity, (Object)c);
                }
                if (o.getEndTime().before(DateUtils.now()) && o.getStatus() == 1) {
                    c.setStatus(Integer.valueOf(3));
                }
                c.setCashStatusName(CashStatusEnum.getName((Integer)c.getStatus()));
                c.setEndTime(o.getEndTime());
                c.setBeginTime(o.getBeginTime());
                CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(o.getTicketBatchId());
                c.setAmountMin(cashticketBatchEntity.getMinUseamount());
                c.setUsedRule(StringUtils.isNotEmpty((String)cashticketBatchEntity.getRemark()) ? cashticketBatchEntity.getRemark() : "");
                if (StringUtils.isNotEmpty((String)o.getBindCode())) {
                    ActiveDTO activeEntity = (ActiveDTO)this.activeInvoke.getActiveEntityByQrcode(o.getBindCode()).getValue();
                    c.setSourceActiveNo(activeEntity == null ? "" : activeEntity.getActiveName());
                }
                list.add(c);
            });
            map.put("list", list);
        }
        return BaseJsonVo.success(map);
    }

    public BaseJsonVo updateCashticketStatusDisabled(int ticketId) {
        this.cashticketInterface.updateCashticketStatus(ticketId, CashStatusEnum.jinyong);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo updateCashticketStatusEnable(int ticketId) {
        this.cashticketInterface.updateCashticketStatus(ticketId, CashStatusEnum.yijihuo);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo getEnableServiceCashticketBatch() {
        return BaseJsonVo.success((Object)this.cashticketBatchInterface.getEnableServiceCashticketBatch());
    }

    public BaseJsonVo sendCashticketByTicketBatchId(String batchId, String customerId, Integer quantity) {
        return this.couponInvoke.sendCashticketByTicketBatchId(batchId, customerId);
    }
}

