/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.api;

import cc.lechun.customers.api.CustomerApi;
import cc.lechun.customers.dto.customer.AddressForm;
import cc.lechun.customers.dto.customer.AreaCityProvinceResVo;
import cc.lechun.customers.dto.customer.CustomerQueryVo;
import cc.lechun.customers.entity.customer.CustomerAddressEntity;
import cc.lechun.customers.iservice.customer.CustomerAddressInterface;
import cc.lechun.customers.iservice.customer.CustomerInterface;
import cc.lechun.customers.iservice.customer.CustomerOpenIdInterface;
import cc.lechun.customers.iservice.vip.MallVipInterface;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerApiImpl
implements CustomerApi {
    @Autowired
    private CustomerInterface customerInterface;
    @Resource
    private MallVipInterface mallVipInterface;
    @Autowired
    private CustomerOpenIdInterface customerOpenIdInterface;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;

    public BaseJsonVo getCustomerList(CustomerQueryVo customerQueryVo) {
        if (StringUtils.isEmpty((String)customerQueryVo.getOpenId())) {
            customerQueryVo.setOpenId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getCustomerId())) {
            customerQueryVo.setCustomerId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getMobile())) {
            customerQueryVo.setMobile(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getNickName())) {
            customerQueryVo.setNickName(null);
        }
        return BaseJsonVo.success((Object)this.customerInterface.getCustomerList(customerQueryVo));
    }

    public BaseJsonVo getCustomerInfo(String customerId) {
        HashedMap map = new HashedMap();
        map.put("custmerInfo", this.customerInterface.getCustomer(customerId));
        map.put("centerInfo", this.mallVipInterface.centerInfo(customerId));
        map.put("openIdList", this.customerOpenIdInterface.getCustomerOpenidList(customerId));
        return BaseJsonVo.success((Object)map);
    }

    public BaseJsonVo getCustomerAddressList(String customerId) {
        HashedMap map = new HashedMap();
        map.put("addressList", this.customerAddressInterface.getValidCustomerAddressList(customerId, "", -1));
        map.put("addressType", this.customerAddressInterface.getAddressType());
        return BaseJsonVo.success((Object)map);
    }

    public BaseJsonVo getProvinceCityAreaByErp(Integer transportType, Integer isLongPeriodBuy) {
        return BaseJsonVo.success((Object)this.customerAddressInterface.getProvinceCityAreaByErp(transportType, isLongPeriodBuy));
    }

    public BaseJsonVo saveMobile(String customerId, String mobile) {
        return BaseJsonVo.success((Object)this.customerInterface.saveMobile(mobile, customerId));
    }

    public BaseJsonVo updateVipLevel(String customerId, Integer level) {
        this.mallVipInterface.updateVipLevel(customerId, level);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo deleteUserVipInfoCache(String customerId) {
        this.mallVipInterface.deleteUserVipInfoCache(customerId);
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo addAddress(AddressForm addressForm) {
        return this.customerAddressInterface.saveCustomerAddress(addressForm);
    }

    public BaseJsonVo updateAddress(AddressForm addressForm) {
        return this.customerAddressInterface.saveCustomerAddress(addressForm);
    }

    public BaseJsonVo deleteCustomerAddress(String customerId, String addrId) {
        return this.customerAddressInterface.deleteCustomerAddress(customerId, addrId);
    }

    public BaseJsonVo getCustomerAddress(String customerId, String addrId) {
        CustomerAddressEntity add = this.customerAddressInterface.getCustomerAddress(addrId);
        if (add == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (!add.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u5730\u5740");
        }
        return BaseJsonVo.success((Object)add);
    }

    public BaseJsonVo getAddressByParam(String addrId) {
        AreaCityProvinceResVo areaCityProvince = this.customerAddressInterface.getAddressByParam(Integer.valueOf(addrId).intValue());
        return BaseJsonVo.success((Object)areaCityProvince);
    }
}

