/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.api;

import cc.lechun.customers.api.CustomerBalanceApi;
import cc.lechun.customers.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.customers.dto.balance.PrepayCardDetailQueryVo;
import cc.lechun.customers.dto.balance.PrepayCardQueryVo;
import cc.lechun.customers.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardQueryInterface;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerBalanceApiImpl
implements CustomerBalanceApi {
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    PrepayCardQueryInterface prepayCardQueryInterface;
    @Autowired
    private PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;

    public BaseJsonVo getTotalBalance(String customerId) {
        return this.balanceAccountInvoke.getUserBalance(customerId);
    }

    public BaseJsonVo getUserBalanceDetail(String customerId) {
        return this.balanceAccountInvoke.getUserBalanceDetail(customerId);
    }

    public BaseJsonVo increaseManual(String customerId, BigDecimal increaseAmount, String detailSubTypeDesc) {
        return this.balanceAccountInvoke.increaseManual(customerId, increaseAmount, "", detailSubTypeDesc);
    }

    public BaseJsonVo reduceManual(String customerId, BigDecimal reduceAmount, String detailSubTypeDesc) {
        return this.balanceAccountInvoke.reduceManual(customerId, reduceAmount, "", detailSubTypeDesc);
    }

    public BaseJsonVo getPrepayCardVoList(PrepayCardQueryVo prepayCardQueryVo) {
        return BaseJsonVo.success((Object)this.prepayCardQueryInterface.getPrepayCardVoList(prepayCardQueryVo));
    }

    public BaseJsonVo getPrepayCardDetailVoList(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        prepayCardDetailQueryVo.setEndDate(prepayCardDetailQueryVo.getEnd());
        prepayCardDetailQueryVo.setStartDate(prepayCardDetailQueryVo.getStart());
        return BaseJsonVo.success((Object)this.prepayCardPlanDetailInterface.getPrepayCardDetailVoList(prepayCardDetailQueryVo));
    }

    public BaseJsonVo disabledCard(String cardId) {
        return this.prepayCardQueryInterface.disabledCard(cardId);
    }
}

