/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.apiinvoke.balance;

import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.balance.dto.UserBalanceDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.customers.apiinvoke.config.FeignConfig;
import cc.lechun.customers.apiinvoke.fallback.balance.BalanceAccountFallback;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="lechun-balance", url="${feign.bind.url.balance}", fallbackFactory=BalanceAccountFallback.class, configuration={FeignConfig.class})
public interface BalanceAccountInvoke {
    @RequestMapping(value={"/api/getUserBalance"}, method={RequestMethod.GET})
    public BaseJsonVo<UserBalanceDTO> getUserBalance(@RequestParam(value="customerId") String var1);

    @RequestMapping(value={"/api/getUserBalanceDetail"}, method={RequestMethod.GET})
    public BaseJsonVo<UserBalanceDetailDTO> getUserBalanceDetail(@RequestParam(value="customerId") String var1);

    @RequestMapping(value={"/api/charge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> charge(@RequestParam(value="customerId") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="productId") String var3);

    @RequestMapping(value={"/api/cardCharge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> cardCharge(@RequestParam(value="customerId") String var1, @RequestParam(value="cardNo") String var2);

    @RequestMapping(value={"/api/payOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> payOrder(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2, @RequestParam(value="orderAmount") BigDecimal var3);

    @RequestMapping(value={"/api/cancleOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> cancleOrder(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2);

    @RequestMapping(value={"/api/refundOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> refundOrder(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2, @RequestParam(value="refundAmount") BigDecimal var3, @RequestParam(value="operator") String var4);

    @RequestMapping(value={"/api/refundSpecialCardOrder"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> refundSpecialCardOrder(@RequestParam(value="cardNo") String var1, @RequestParam(value="orderMainNo") String var2, @RequestParam(value="refundAmount") BigDecimal var3, @RequestParam(value="operator") String var4);

    @RequestMapping(value={"/api/refundCharge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> refundCharge(@RequestParam(value="customerId") String var1, @RequestParam(value="tradeNo") String var2, @RequestParam(value="operator") String var3);

    @RequestMapping(value={"/api/activeCharge"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> activeCharge(@RequestParam(value="customerId") String var1, @RequestParam(value="increaseAmount") BigDecimal var2, @RequestParam(value="detailSubTypeDesc") String var3, @RequestParam(value="notice") Boolean var4, @RequestParam(value="noticeText") String var5, @RequestParam(value="remark") String var6);

    @RequestMapping(value={"/api/increaseManual"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> increaseManual(@RequestParam(value="customerId") String var1, @RequestParam(value="increaseAmount") BigDecimal var2, @RequestParam(value="operator") String var3, @RequestParam(value="detailSubTypeDesc") String var4);

    @RequestMapping(value={"/api/reduceManual"}, method={RequestMethod.GET})
    public BaseJsonVo<BalanceChangeDTO> reduceManual(@RequestParam(value="customerId") String var1, @RequestParam(value="reduceAmount") BigDecimal var2, @RequestParam(value="operator") String var3, @RequestParam(value="remark") String var4);

    @RequestMapping(value={"/storage/findStorageCards"}, method={RequestMethod.GET})
    public BaseJsonVo<List<StorageCardDTO>> findStorageCards();
}

