/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.customer;

import cc.lechun.customers.dao.customer.CustomerOnlineMapper;
import cc.lechun.customers.dto.customer.CustomerQueryVo;
import cc.lechun.customers.entity.customer.CustomerOnlineEntity;
import cc.lechun.customers.iservice.customer.CustomerOnlineInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerOnlineService
extends BaseService<CustomerOnlineEntity, String>
implements CustomerOnlineInterface {
    @Resource
    private CustomerOnlineMapper customerOnlineMapper;

    public PageInfo<CustomerOnlineEntity> getCustomerList(CustomerQueryVo customerQueryVo) {
        Page page = PageHelper.startPage((int)customerQueryVo.getCurrentPage(), (int)customerQueryVo.getPageSize());
        page.setOrderBy("CREATE_TIME desc");
        this.customerOnlineMapper.getCustomerOnlineList(customerQueryVo.getIsOnLine(), customerQueryVo.getOpenId(), customerQueryVo.getCustomerId());
        return page.toPageInfo();
    }

    public BaseJsonVo saveCustomerOnline(CustomerOnlineEntity customerOnlineEntity) {
        CustomerOnlineEntity temp = new CustomerOnlineEntity();
        temp.setOpenId(customerOnlineEntity.getOpenId());
        Boolean result = false;
        result = this.existsByEntity((Object)temp) >= 1 ? Boolean.valueOf(super.updateByPrimaryKeySelective((Object)customerOnlineEntity) > 0) : Boolean.valueOf(super.insert((Object)customerOnlineEntity) > 0);
        return result != false ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5728\u7ebf\u5ba2\u670d\u5931\u8d25");
    }

    public boolean checkIsExistOnline(String openId) {
        boolean flag = false;
        CustomerOnlineEntity temp = new CustomerOnlineEntity();
        temp.setOpenId(openId);
        CustomerOnlineEntity single = (CustomerOnlineEntity)super.getSingle((Object)temp);
        if (single == null) {
            return flag;
        }
        flag = DateUtils.getDateDiff((Date)single.getCreateTime(), (Date)DateUtils.now()) <= 0L;
        return flag;
    }
}

