/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.prepay;

import cc.lechun.cms.dto.PromotionDTO;
import cc.lechun.customers.apiinvoke.cms.PromotionInvoke;
import cc.lechun.customers.dao.prepay.PrepayCardPlanDetailMapper;
import cc.lechun.customers.dto.balance.PrepayCardDetailQueryVo;
import cc.lechun.customers.entity.customer.CustomerAddressEntity;
import cc.lechun.customers.entity.prepay.PrepayCardDetailVo;
import cc.lechun.customers.entity.prepay.PrepayCardPlanDetailEntity;
import cc.lechun.customers.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.customers.iservice.customer.CustomerAddressInterface;
import cc.lechun.customers.iservice.customer.CustomerInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardPlanDetailService
extends BaseService<PrepayCardPlanDetailEntity, Integer>
implements PrepayCardPlanDetailInterface {
    @Resource
    private PrepayCardPlanDetailMapper prepayCardPlanDetailMapper;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private PromotionInvoke promotionInvoke;
    @Autowired
    private CustomerInterface customerInterface;

    public PageInfo<PrepayCardDetailVo> getPrepayCardDetailVoList(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        Page page = PageHelper.startPage((int)prepayCardDetailQueryVo.getCurrentPage(), (int)prepayCardDetailQueryVo.getPageSize());
        if (StringUtils.isNotEmpty((String)prepayCardDetailQueryVo.getOrderBy())) {
            page.setOrderBy(prepayCardDetailQueryVo.getOrderBy());
        }
        if (prepayCardDetailQueryVo.getOrderSource() != null && prepayCardDetailQueryVo.getOrderSource() == 0) {
            prepayCardDetailQueryVo.setOrderSource(null);
        }
        if (StringUtils.isEmpty((String)prepayCardDetailQueryVo.getCardId())) {
            prepayCardDetailQueryVo.setCardId(null);
        }
        this.prepayCardPlanDetailMapper.getListByDate(prepayCardDetailQueryVo);
        List list = page.toPageInfo().getList();
        ArrayList resultList = new ArrayList();
        list.forEach(c -> {
            PrepayCardDetailVo prepayCardDetailVo = new PrepayCardDetailVo();
            BeanUtils.copyProperties((Object)c, (Object)prepayCardDetailVo);
            prepayCardDetailVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            CustomerAddressEntity customerAddressEntity = this.customerAddressInterface.getCustomerAddress(c.getAddrId());
            BeanUtils.copyProperties((Object)customerAddressEntity, (Object)prepayCardDetailVo);
            prepayCardDetailVo.setStatus(c.getStatus());
            prepayCardDetailVo.setStatusName(PrepayCardPlanStatusEnum.getName((int)c.getStatus()));
            prepayCardDetailVo.setCreateTime(c.getCreateTime());
            BaseJsonVo jsonVo = this.promotionInvoke.getPromotion(c.getPromotionId());
            if (jsonVo.isSuccess()) {
                prepayCardDetailVo.setPromotionName(jsonVo.getValue() == null ? "" : ((PromotionDTO)jsonVo.getValue()).getPromotionName());
            }
            prepayCardDetailVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            resultList.add(prepayCardDetailVo);
        });
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(page.getTotal());
        return pg2;
    }
}

