/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.prepay;

import cc.lechun.customers.dto.balance.PrepayCardQueryVo;
import cc.lechun.customers.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.customers.entity.prepay.PrepayCardEntity;
import cc.lechun.customers.entity.prepay.PrepayCardPlanDetailEntity;
import cc.lechun.customers.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.customers.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.customers.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.customers.entity.prepay.PrepayCardVo;
import cc.lechun.customers.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.customers.iservice.prepay.PrepayCardQueryInterface;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.MallSelectDataVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardQueryService
implements PrepayCardQueryInterface {
    @Autowired
    private PrepayCardInterface prepayCardService;
    @Autowired
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchService;

    public PageInfo<PrepayCardVo> getPrepayCardVoList(PrepayCardQueryVo prepayCardQueryVo) {
        PrepayCardEntity query = new PrepayCardEntity();
        BeanUtils.copyProperties((Object)prepayCardQueryVo, (Object)query);
        if (StringUtils.isNotEmpty((String)prepayCardQueryVo.getCustomerId())) {
            query.setBelongCustomerId(prepayCardQueryVo.getCustomerId());
        }
        if (prepayCardQueryVo.getOrderSource() != null && prepayCardQueryVo.getOrderSource() == 0) {
            query.setOrderSource(null);
        }
        if (StringUtils.isEmpty((String)prepayCardQueryVo.getCardId())) {
            query.setCardId(null);
        }
        Page page = PageHelper.startPage((int)prepayCardQueryVo.getCurrentPage(), (int)prepayCardQueryVo.getPageSize());
        page.setOrderBy("CREATE_TIME desc ");
        this.prepayCardService.getList((Object)query, 0L);
        List list = page.toPageInfo().getList();
        ArrayList resultList = new ArrayList();
        list.forEach(c -> {
            PrepayCardVo prepayCardVo = new PrepayCardVo();
            BeanUtils.copyProperties((Object)c, (Object)prepayCardVo);
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey((Serializable)c.getBatchId());
            prepayCardVo.setBatchName(prepayCardBatchEntity.getBatchName());
            prepayCardVo.setTitle(prepayCardBatchEntity.getTitle());
            if (c.getEndTime() != null && c.getEndTime().before(DateUtils.now())) {
                prepayCardVo.setStatus(Integer.valueOf(PrepayCardStatusEnum.NOEFFECT.getValue()));
            }
            prepayCardVo.setStatusName(PrepayCardStatusEnum.getName((int)prepayCardVo.getStatus()));
            prepayCardVo.setOrderSourceName(OrderSourceEnum.getName((int)c.getOrderSource()));
            prepayCardVo.setCardTypeName(PrepayCardTypeEnum.getName((int)c.getCardType()));
            PrepayCardPlanDetailEntity prepayCardDetailEntity = new PrepayCardPlanDetailEntity();
            prepayCardDetailEntity.setCardId(c.getCardId());
            List detailList = this.prepayCardPlanDetailService.getList((Object)prepayCardDetailEntity, 0L);
            Integer noDeliveryNum = 0;
            if (detailList.size() > 0) {
                for (int j = 0; j < detailList.size(); ++j) {
                    if (((PrepayCardPlanDetailEntity)detailList.get(j)).getStatus().intValue() != PrepayCardPlanStatusEnum.DELIVERY.getValue() || !((PrepayCardPlanDetailEntity)detailList.get(j)).getPickTime().after(DateUtils.currentDate())) continue;
                    noDeliveryNum = noDeliveryNum + ((PrepayCardPlanDetailEntity)detailList.get(j)).getQuantity();
                }
                prepayCardVo.setNoDeliveryNum(noDeliveryNum);
            } else {
                prepayCardVo.setNoDeliveryNum(noDeliveryNum);
            }
            resultList.add(prepayCardVo);
        });
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(page.getTotal());
        return pg2;
    }

    public List<MallSelectDataVo> getOrderSourceNameList() {
        PrepayCardEntity query = new PrepayCardEntity();
        List list = this.prepayCardService.getList((Object)query);
        List orderSourceList = list.stream().map(PrepayCardEntity::getOrderSource).collect(Collectors.toList());
        HashSet set = new HashSet(orderSourceList);
        ArrayList<MallSelectDataVo> sourceList = new ArrayList<MallSelectDataVo>();
        for (Integer source : set) {
            MallSelectDataVo selectDataVo = new MallSelectDataVo();
            selectDataVo.setName(OrderSourceEnum.getName((int)source));
            selectDataVo.setId(source.toString());
            sourceList.add(selectDataVo);
        }
        return sourceList;
    }

    public BaseJsonVo disabledCard(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361");
        }
        if (prepayCardEntity.getRemainCount() == 0) {
            return BaseJsonVo.error((String)"\u7981\u7528\u5931\u8d25\uff0c\u5361\u8ba1\u5212\u90fd\u5df2\u914d\u9001!");
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue() || prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.UNTAKED.getValue()) {
            return this.disabledCard(prepayCardEntity);
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            BaseJsonVo baseJsonVo = this.disabledCard(prepayCardEntity);
            if (baseJsonVo.isSuccess()) {
                return BaseJsonVo.success((Object)"\u5df2\u7981\u7528\uff0c\u8be5\u5361\u8fd8\u6709\u8ba2\u5355\u4e2d\u914d\u9001\u4e2d\u8bf7\u6839\u636e\u5b9e\u9645\u5904\u7406\u8be5\u5361\u4e0b\u5c5e\u8ba2\u5355");
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)("\u5361" + PrepayCardStatusEnum.getName((int)prepayCardEntity.getStatus()) + "\u65e0\u6cd5\u7981\u7528"));
    }

    private BaseJsonVo disabledCard(PrepayCardEntity prepayCardEntity) {
        PrepayCardEntity update = new PrepayCardEntity();
        update.setStatus(Integer.valueOf(PrepayCardStatusEnum.NOEFFECT.getValue()));
        update.setRemainCount(Integer.valueOf(0));
        update.setCardId(prepayCardEntity.getCardId());
        return this.prepayCardService.updateByPrimaryKeySelective((Object)update) > 0 ? BaseJsonVo.success((Object)"\u5df2\u7981\u7528") : BaseJsonVo.error((String)"\u7981\u7528\u5931\u8d25\u8bf7\u91cd\u8bd5");
    }
}

