/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.config.artemis;

import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;

@Configuration
public class JmsConfig {
    @Value(value="${spring.artemis.url}")
    private String url;
    @Value(value="${spring.artemis.user}")
    private String user;
    @Value(value="${spring.artemis.password}")
    private String password;

    public ConnectionFactory connectionFactoryArtemis() {
        return new ActiveMQConnectionFactory(this.user, this.password, this.url);
    }

    public JmsTemplate jmsTemplateArtemis(@Qualifier(value="connectionFactoryArtemis") ConnectionFactory connectionFactory) {
        JmsTemplate template = new JmsTemplate(connectionFactory);
        template.setPubSubDomain(true);
        return template;
    }
}

