/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common;

import cc.lechun.erp.config.Cache;
import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.erp.domain.common.entity.Cust;
import cc.lechun.erp.domain.common.entity.Dept;
import cc.lechun.erp.domain.common.entity.Emp;
import cc.lechun.erp.domain.common.entity.Factory;
import cc.lechun.erp.domain.common.entity.Logistic;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.MatClass;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.domain.common.entity.Store;
import cc.lechun.erp.util.MyCopy;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;

@Service
public class ErpCommonDoMain {
    private Logger log = LoggerFactory.getLogger((String)"ErpCache");
    public static HashMap<String, Packing> packingNumMap = new HashMap();
    @Autowired
    private ErpCommonMapper erpCommonMapper;
    public static String DELETE_CACHE = "DELETE_CACHE";
    @Autowired
    @Qualifier(value="jmsTemplateArtemis")
    private JmsTemplate jmsTemplate;
    public static HashMap<String, Mat> matIdMap = new HashMap();
    public static HashMap<String, Mat> matCodeMap = new HashMap();
    public static HashMap<String, Mat> matNameMap = new HashMap();
    public static HashMap<String, Mat> matCbarcodeMap = new HashMap();
    public static HashMap<String, Cust> custIdMap = new HashMap();
    public static HashMap<String, Cust> custNameMap = new HashMap();
    public static HashMap<String, Cust> custCodeMap = new HashMap();
    public static HashMap<String, Store> storeIdMap = new HashMap();
    public static HashMap<String, Store> storeCodeMap = new HashMap();
    public static HashMap<String, Store> storeNameMap = new HashMap();
    public static HashMap<String, Factory> factoryIdMap = new HashMap();
    public static HashMap<String, Factory> factoryCodeMap = new HashMap();
    public static HashMap<String, Factory> factoryNameMap = new HashMap();
    public static HashMap<String, Dept> deptIdMap = new HashMap();
    public static HashMap<String, Dept> deptCodeMap = new HashMap();
    public static HashMap<String, Dept> deptNameMap = new HashMap();
    public static HashMap<String, MatClass> classIdMap = new HashMap();
    public static HashMap<String, MatClass> classCodeMap = new HashMap();
    public static HashMap<String, MatClass> classNameMap = new HashMap();
    public static HashMap<String, Logistic> logisticIdMap = new HashMap();
    public static HashMap<String, Logistic> logisticCodeMap = new HashMap();
    public static HashMap<String, Logistic> logisticNameMap = new HashMap();
    public static HashMap<String, Logistic> logisticOutCodeMap = new HashMap();
    public static HashMap<String, Shop> shopIdMap = new HashMap();
    public static HashMap<String, Shop> shopCodeMap = new HashMap();
    public static HashMap<String, Shop> shopOutCodeMap = new HashMap();
    public static HashMap<String, Shop> shopNameMap = new HashMap();
    public static HashMap<String, Emp> empIdMap = new HashMap();
    public static HashMap<String, Emp> empCodeMap = new HashMap();
    public static HashMap<String, Emp> empNameMap = new HashMap();

    public Emp getEmpById(String id) {
        if (empIdMap.get(id) == null) {
            Emp find = this.erpCommonMapper.getEmp(id, null, null);
            if (null != find) {
                empIdMap.put(id, find);
                empCodeMap.put(find.getCode(), find);
                empNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(empIdMap.get(id));
        }
        return null;
    }

    public Emp getEmpByCode(String code) {
        if (empCodeMap.get(code) == null) {
            Emp find = this.erpCommonMapper.getEmp(null, code, null);
            if (null != find) {
                empCodeMap.put(code, find);
                empIdMap.put(find.getCguid(), find);
                empNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(empCodeMap.get(code));
        }
        return null;
    }

    public Emp getEmpByName(String name) {
        if (empNameMap.get(name) == null) {
            Emp find = this.erpCommonMapper.getEmp(null, null, name);
            if (null != find) {
                empNameMap.put(name, find);
                empCodeMap.put(find.getCode(), find);
                empIdMap.put(find.getCguid(), find);
                return find;
            }
        } else {
            return MyCopy.copy(empNameMap.get(name));
        }
        return null;
    }

    public void jobClear() {
        this.clear();
    }

    private synchronized void clear() {
        matIdMap.clear();
        matCodeMap.clear();
        matNameMap.clear();
        matCbarcodeMap.clear();
        custIdMap.clear();
        custCodeMap.clear();
        custNameMap.clear();
        storeIdMap.clear();
        storeCodeMap.clear();
        storeNameMap.clear();
        factoryIdMap.clear();
        factoryCodeMap.clear();
        factoryNameMap.clear();
        deptIdMap.clear();
        deptCodeMap.clear();
        deptNameMap.clear();
        classIdMap.clear();
        classCodeMap.clear();
        classNameMap.clear();
        logisticIdMap.clear();
        logisticCodeMap.clear();
        logisticNameMap.clear();
        logisticOutCodeMap.clear();
        shopIdMap.clear();
        shopCodeMap.clear();
        shopOutCodeMap.clear();
        shopNameMap.clear();
        empIdMap.clear();
        empCodeMap.clear();
        empNameMap.clear();
        packingNumMap.clear();
        this.classMapInit();
    }

    public Mat getMatById(String id) {
        if (matIdMap.get(id) == null) {
            Mat find = this.erpCommonMapper.getMat(id, null, null, null);
            if (null != find) {
                matIdMap.put(id, find);
                matCodeMap.put(find.getCode(), find);
                matNameMap.put(find.getName(), find);
                matCbarcodeMap.put(find.getCbarcode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matIdMap.get(id));
        }
        return null;
    }

    public Cust getCustById(String id) {
        if (custIdMap.get(id) == null) {
            Cust find = this.erpCommonMapper.getCust(id, null, null);
            if (null != find) {
                custIdMap.put(id, find);
                custCodeMap.put(find.getCode(), find);
                custNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(custIdMap.get(id));
        }
        return null;
    }

    public Store getStoreById(String id) {
        if (storeIdMap.get(id) == null) {
            Store find = this.erpCommonMapper.getStore(id, null, null);
            if (null != find) {
                storeIdMap.put(id, find);
                storeCodeMap.put(find.getCode(), find);
                storeNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(storeIdMap.get(id));
        }
        return null;
    }

    public Factory getFactoryById(String id) {
        if (factoryIdMap.get(id) == null) {
            Factory find = this.erpCommonMapper.getFactory(id, null, null);
            if (null != find) {
                factoryIdMap.put(id, find);
                factoryCodeMap.put(find.getCode(), find);
                factoryNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(factoryIdMap.get(id));
        }
        return null;
    }

    public Dept getDeptById(String id) {
        if (deptIdMap.get(id) == null) {
            Dept find = this.erpCommonMapper.getDept(id, null, null);
            if (null != find) {
                deptIdMap.put(id, find);
                deptCodeMap.put(find.getCode(), find);
                deptNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(deptIdMap.get(id));
        }
        return null;
    }

    public Logistic getLogisticById(String id) {
        if (logisticIdMap.get(id) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(id, null, null, null);
            if (null != find) {
                logisticIdMap.put(id, find);
                logisticCodeMap.put(find.getCode(), find);
                logisticNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    logisticOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(logisticIdMap.get(id));
        }
        return null;
    }

    public Shop getShopById(String id) {
        if (shopIdMap.get(id) == null) {
            Shop find = this.erpCommonMapper.getShop(id, null, null, null);
            if (null != find) {
                shopIdMap.put(id, find);
                shopCodeMap.put(find.getCode(), find);
                shopNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    shopOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(shopIdMap.get(id));
        }
        return null;
    }

    public MatClass getMatClassById(String id) {
        if (classIdMap.get(id) == null) {
            List<MatClass> finds = this.erpCommonMapper.matClass(id, null, null);
            if (null != finds && finds.size() > 0) {
                classIdMap.put(id, finds.get(0));
                classCodeMap.put(finds.get(0).getCode(), finds.get(0));
                classNameMap.put(finds.get(0).getName(), finds.get(0));
                return finds.get(0);
            }
        } else {
            return MyCopy.copy(classIdMap.get(id));
        }
        return null;
    }

    public Mat getMatByCode(String code) {
        if (matCodeMap.get(code) == null) {
            Mat find = this.erpCommonMapper.getMat(null, code, null, null);
            if (null != find) {
                matCodeMap.put(code, find);
                matIdMap.put(find.getCguid(), find);
                matNameMap.put(find.getName(), find);
                matCbarcodeMap.put(find.getCbarcode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matCodeMap.get(code));
        }
        return null;
    }

    public Cust getCustByCode(String code) {
        if (custCodeMap.get(code) == null) {
            Cust find = this.erpCommonMapper.getCust(null, code, null);
            if (null != find) {
                custCodeMap.put(code, find);
                custIdMap.put(find.getCguid(), find);
                custNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(custCodeMap.get(code));
        }
        return null;
    }

    public Store getStoreByCode(String code) {
        if (storeCodeMap.get(code) == null) {
            Store find = this.erpCommonMapper.getStore(null, code, null);
            if (null != find) {
                storeCodeMap.put(code, find);
                storeIdMap.put(find.getCguid(), find);
                storeNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(storeCodeMap.get(code));
        }
        return null;
    }

    public Factory getFactoryByCode(String code) {
        if (factoryCodeMap.get(code) == null) {
            Factory find = this.erpCommonMapper.getFactory(null, code, null);
            if (null != find) {
                factoryCodeMap.put(code, find);
                factoryIdMap.put(find.getCguid(), find);
                factoryNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(factoryCodeMap.get(code));
        }
        return null;
    }

    public Dept getDeptByCode(String code) {
        if (deptCodeMap.get(code) == null) {
            Dept find = this.erpCommonMapper.getDept(null, code, null);
            if (null != find) {
                deptCodeMap.put(code, find);
                deptIdMap.put(find.getCguid(), find);
                deptNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(deptCodeMap.get(code));
        }
        return null;
    }

    public Logistic getLogisticByCode(String code) {
        if (logisticCodeMap.get(code) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(null, code, null, null);
            if (null != find) {
                logisticCodeMap.put(code, find);
                logisticIdMap.put(find.getCguid(), find);
                logisticNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    logisticOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(logisticCodeMap.get(code));
        }
        return null;
    }

    public Shop getShopByCode(String code) {
        if (shopCodeMap.get(code) == null) {
            Shop find = this.erpCommonMapper.getShop(null, code, null, null);
            if (null != find) {
                shopCodeMap.put(code, find);
                shopIdMap.put(find.getCguid(), find);
                shopNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    shopOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(shopCodeMap.get(code));
        }
        return null;
    }

    public Mat getMatByName(String name) {
        if (matNameMap.get(name) == null) {
            Mat find = this.erpCommonMapper.getMat(null, null, name, null);
            if (null != find) {
                matNameMap.put(name, find);
                matIdMap.put(find.getCguid(), find);
                matCodeMap.put(find.getCode(), find);
                matCbarcodeMap.put(find.getCbarcode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matNameMap.get(name));
        }
        return null;
    }

    public Mat getMatByCbarcode(String cbarcode) {
        if (matCbarcodeMap.get(cbarcode) == null) {
            Mat find = this.erpCommonMapper.getMat(null, null, null, cbarcode);
            if (null != find) {
                matCbarcodeMap.put(cbarcode, find);
                matIdMap.put(find.getCguid(), find);
                matCodeMap.put(find.getCode(), find);
                matNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matCbarcodeMap.get(cbarcode));
        }
        return null;
    }

    public Cust getCustByName(String name) {
        if (custNameMap.get(name) == null) {
            Cust find = this.erpCommonMapper.getCust(null, null, name);
            if (null != find) {
                custNameMap.put(name, find);
                custIdMap.put(find.getCguid(), find);
                custCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(custNameMap.get(name));
        }
        return null;
    }

    public Store getStoreByName(String name) {
        if (storeNameMap.get(name) == null) {
            Store find = this.erpCommonMapper.getStore(null, null, name);
            if (null != find) {
                storeNameMap.put(name, find);
                storeIdMap.put(find.getCguid(), find);
                storeCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(storeNameMap.get(name));
        }
        return null;
    }

    public Factory getFactoryByName(String name) {
        if (factoryNameMap.get(name) == null) {
            Factory find = this.erpCommonMapper.getFactory(null, null, name);
            if (null != find) {
                factoryNameMap.put(name, find);
                factoryIdMap.put(find.getCguid(), find);
                factoryCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(factoryNameMap.get(name));
        }
        return null;
    }

    public Dept getDeptByName(String name) {
        if (deptNameMap.get(name) == null) {
            Dept find = this.erpCommonMapper.getDept(null, null, name);
            if (null != find) {
                deptNameMap.put(name, find);
                deptIdMap.put(find.getCguid(), find);
                deptCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(deptNameMap.get(name));
        }
        return null;
    }

    public Logistic getLogisticByName(String name) {
        if (logisticNameMap.get(name) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(null, null, name, null);
            if (null != find) {
                logisticNameMap.put(name, find);
                logisticCodeMap.put(find.getCode(), find);
                logisticIdMap.put(find.getCguid(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    logisticOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(logisticNameMap.get(name));
        }
        return null;
    }

    public Shop getShopByName(String name) {
        if (shopNameMap.get(name) == null) {
            Shop find = this.erpCommonMapper.getShop(null, null, name, null);
            if (null != find) {
                shopNameMap.put(name, find);
                shopCodeMap.put(find.getCode(), find);
                shopIdMap.put(find.getCguid(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    shopOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(shopNameMap.get(name));
        }
        return null;
    }

    public MatClass getMatClassByName(String name) {
        if (classNameMap.get(name) == null) {
            List<MatClass> finds = this.erpCommonMapper.matClass(null, null, name);
            if (null != finds && finds.size() > 0) {
                classNameMap.put(name, finds.get(0));
                classCodeMap.put(finds.get(0).getCode(), finds.get(0));
                classIdMap.put(finds.get(0).getCguid(), finds.get(0));
                return finds.get(0);
            }
        } else {
            return MyCopy.copy(classNameMap.get(name));
        }
        return null;
    }

    public Logistic getLogisticByOutCode(String outCode) {
        if (logisticOutCodeMap.get(outCode) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(null, null, null, outCode);
            if (null != find) {
                logisticOutCodeMap.put(outCode, find);
                logisticCodeMap.put(find.getCode(), find);
                logisticIdMap.put(find.getCguid(), find);
                logisticNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(logisticOutCodeMap.get(outCode));
        }
        return null;
    }

    public Shop getShopByOutCode(String outCode) {
        if (shopOutCodeMap.get(outCode) == null) {
            Shop find = this.erpCommonMapper.getShop(null, null, null, outCode);
            if (null != find) {
                shopOutCodeMap.put(outCode, find);
                shopCodeMap.put(find.getCode(), find);
                shopIdMap.put(find.getCguid(), find);
                shopNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(shopOutCodeMap.get(outCode));
        }
        return null;
    }

    private void classMapInit() {
        this.log.info("\u83b7\u53d6\u4ea7\u54c1\u7ebf\u5f00\u59cb=\u300b");
        List<MatClass> list = this.erpCommonMapper.matClass(null, null, null);
        list.forEach(matClass -> {
            classIdMap.put(matClass.getCguid(), (MatClass)matClass);
            classCodeMap.put(matClass.getCode(), (MatClass)matClass);
            classNameMap.put(matClass.getName(), (MatClass)matClass);
        });
        this.log.info("\u83b7\u53d6\u4ea7\u54c1\u7ebf\u7ed3\u675f=\u300b");
    }

    public Packing getPacking(String custId, String matId) {
        String key = custId + "|" + matId;
        if (packingNumMap.get(key) == null) {
            Packing find = this.erpCommonMapper.getPacking(custId, matId);
            if (null != find) {
                packingNumMap.put(key, find);
                return find;
            }
        } else {
            return MyCopy.copy(packingNumMap.get(key));
        }
        return null;
    }

    public void sendMessage(Cache message) {
        this.jmsTemplate.send(DELETE_CACHE, session -> {
            TextMessage textMessage = session.createTextMessage(JSONObject.toJSONString((Object)message));
            return textMessage;
        });
    }

    @JmsListener(containerFactory="listenerArtemisFactory", destination="DELETE_CACHE")
    public void receiveMessage(TextMessage message) throws JMSException {
        Store obj;
        this.log.info("\u63a5\u53d7\u6d88\u606f\u4fe1\u606f\uff1a=\u300b{}", (Object)message.getText());
        Cache cache = null;
        try {
            cache = (Cache)JSONObject.parseObject((String)message.getText(), Cache.class);
        }
        catch (Exception e) {
            return;
        }
        if (null == cache || StringUtils.isBlank((CharSequence)cache.getType()) || StringUtils.isBlank((CharSequence)cache.getKey())) {
            return;
        }
        if (cache.getType().equals("Cust")) {
            Cust obj2 = custIdMap.get(cache.getKey());
            if (null != obj2) {
                custIdMap.remove(obj2.getCguid());
                custNameMap.remove(obj2.getName());
                custCodeMap.remove(obj2.getCode());
            }
        } else if (cache.getType().equals("Dept")) {
            Dept obj3 = deptIdMap.get(cache.getKey());
            if (null != obj3) {
                deptIdMap.remove(obj3.getCguid());
                deptCodeMap.remove(obj3.getCode());
                deptNameMap.remove(obj3.getName());
            }
        } else if (cache.getType().equals("Factory")) {
            Factory obj4 = factoryIdMap.get(cache.getKey());
            if (null != obj4) {
                factoryIdMap.remove(obj4.getCguid());
                factoryCodeMap.remove(obj4.getCode());
                factoryNameMap.remove(obj4.getName());
            }
        } else if (cache.getType().equals("Logistic")) {
            Logistic obj5 = logisticIdMap.get(cache.getKey());
            if (null != obj5) {
                logisticIdMap.remove(obj5.getCguid());
                logisticCodeMap.remove(obj5.getCode());
                logisticNameMap.remove(obj5.getName());
                logisticOutCodeMap.remove(obj5.getOutCode());
            }
        } else if (cache.getType().equals("Mat")) {
            Mat obj6 = matIdMap.get(cache.getKey());
            if (null != obj6) {
                matIdMap.remove(obj6.getCguid());
                matCodeMap.remove(obj6.getCode());
                matNameMap.remove(obj6.getName());
                matCbarcodeMap.remove(obj6.getCbarcode());
            }
        } else if (cache.getType().equals("MatClass")) {
            MatClass obj7 = classIdMap.get(cache.getKey());
            if (null != obj7) {
                classIdMap.remove(obj7.getCguid());
                classCodeMap.remove(obj7.getCode());
                classNameMap.remove(obj7.getName());
            }
        } else if (cache.getType().equals("Packing")) {
            Packing obj8 = packingNumMap.get(cache.getKey());
            if (null != obj8) {
                packingNumMap.remove(cache.getKey());
            }
        } else if (cache.getType().equals("Shop")) {
            Shop obj9 = shopIdMap.get(cache.getKey());
            if (null != obj9) {
                shopIdMap.remove(obj9.getCguid());
                shopCodeMap.remove(obj9.getCode());
                shopNameMap.remove(obj9.getName());
                shopOutCodeMap.remove(obj9.getOutCode());
            }
        } else if (cache.getType().equals("Store")) {
            Store obj10 = storeIdMap.get(cache.getKey());
            if (null != obj10) {
                storeIdMap.remove(obj10.getCguid());
                storeCodeMap.remove(obj10.getCode());
                storeNameMap.remove(obj10.getName());
            }
        } else if (cache.getType().equals("Emp")) {
            Store obj11 = storeIdMap.get(cache.getKey());
            if (null != obj11) {
                empIdMap.remove(obj11.getCguid());
                empCodeMap.remove(obj11.getCode());
                empNameMap.remove(obj11.getName());
            }
        } else if (cache.getType().equals("all") && null != (obj = storeIdMap.get(cache.getKey()))) {
            this.clear();
        }
    }
}

