/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common;

import cc.lechun.erp.config.Cache;
import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.erp.domain.common.entity.Cust;
import cc.lechun.erp.domain.common.entity.Dept;
import cc.lechun.erp.domain.common.entity.Dict;
import cc.lechun.erp.domain.common.entity.Emp;
import cc.lechun.erp.domain.common.entity.Factory;
import cc.lechun.erp.domain.common.entity.Freshness;
import cc.lechun.erp.domain.common.entity.Logistic;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.MatClass;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.domain.common.entity.ShopLogistic;
import cc.lechun.erp.domain.common.entity.Store;
import cc.lechun.erp.util.MyCopy;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;

@Service
public class ErpCommonDoMain {
    private Logger log = LoggerFactory.getLogger((String)"ErpCache");
    public static ConcurrentHashMap<String, Packing> packingNumMap = new ConcurrentHashMap();
    @Autowired
    private ErpCommonMapper erpCommonMapper;
    public static String DELETE_CACHE = "DELETE_CACHE";
    @Autowired
    @Qualifier(value="jmsTemplateArtemis")
    private JmsTemplate jmsTemplate;
    public static ConcurrentHashMap<String, Mat> matIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Mat> matCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Mat> matNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Mat> matCbarcodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Cust> custIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Cust> custNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Cust> custCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Store> storeIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Store> storeCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Store> storeNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Factory> factoryIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Factory> factoryCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Factory> factoryNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Dept> deptIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Dept> deptCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Dept> deptNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, MatClass> classIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, MatClass> classCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, MatClass> classNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Logistic> logisticIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Logistic> logisticCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Logistic> logisticNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Logistic> logisticOutCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Shop> shopIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Shop> shopCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Shop> shopOutCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Shop> shopNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Emp> empIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Emp> empCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Emp> empNameMap = new ConcurrentHashMap();
    public static HashMap<String, Freshness> freshnessKeyMap = new HashMap();
    public static ConcurrentHashMap<String, ConcurrentHashMap<String, Dict>> dictIdMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, ConcurrentHashMap<String, Dict>> dictCodeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, ConcurrentHashMap<String, Dict>> dictNameMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, ShopLogistic> shopLogisticMap = new ConcurrentHashMap();

    public Emp getEmpById(String id) {
        if (empIdMap.get(id) == null) {
            Emp find = this.erpCommonMapper.getEmp(id, null, null);
            if (null != find) {
                empIdMap.put(id, find);
                empCodeMap.put(find.getCode(), find);
                empNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(empIdMap.get(id));
        }
        return null;
    }

    public Emp getEmpByCode(String code) {
        if (empCodeMap.get(code) == null) {
            Emp find = this.erpCommonMapper.getEmp(null, code, null);
            if (null != find) {
                empCodeMap.put(code, find);
                empIdMap.put(find.getCguid(), find);
                empNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(empCodeMap.get(code));
        }
        return null;
    }

    public Emp getEmpByName(String name) {
        if (empNameMap.get(name) == null) {
            Emp find = this.erpCommonMapper.getEmp(null, null, name);
            if (null != find) {
                empNameMap.put(name, find);
                empCodeMap.put(find.getCode(), find);
                empIdMap.put(find.getCguid(), find);
                return find;
            }
        } else {
            return MyCopy.copy(empNameMap.get(name));
        }
        return null;
    }

    public Freshness getFreshness(String customerId, String storeId, String matId) {
        String shelfLifeClass = this.getMatById(matId).getShelfLifeClass();
        if (StringUtils.isNotBlank((CharSequence)shelfLifeClass)) {
            String key = customerId + "|" + storeId + "|" + shelfLifeClass;
            if (freshnessKeyMap.get(key) == null) {
                Freshness find = this.erpCommonMapper.getFreshness(customerId, storeId, shelfLifeClass);
                if (null != find) {
                    freshnessKeyMap.put(key, find);
                    return find;
                }
            } else {
                return MyCopy.copy(freshnessKeyMap.get(key));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dict getDictById(String parentCode, String id) {
        if (dictIdMap.get(parentCode) != null) {
            if (dictIdMap.get(parentCode).get(id) != null) return MyCopy.copy(dictIdMap.get(parentCode).get(id));
            Dict find = this.erpCommonMapper.getDict(parentCode, id, null, null);
            if (null == find) return null;
            dictIdMap.get(parentCode).put(id, find);
            return find;
        }
        Dict find = this.erpCommonMapper.getDict(parentCode, id, null, null);
        if (null == find) return null;
        ConcurrentHashMap<String, Dict> new_ = new ConcurrentHashMap<String, Dict>();
        new_.put(id, find);
        dictIdMap.put(parentCode, new_);
        return find;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dict getDictByCode(String parentCode, String code) {
        if (dictCodeMap.get(parentCode) != null) {
            if (dictCodeMap.get(parentCode).get(code) != null) return MyCopy.copy(dictCodeMap.get(parentCode).get(code));
            Dict find = this.erpCommonMapper.getDict(parentCode, null, code, null);
            if (null == find) return null;
            dictCodeMap.get(parentCode).put(code, find);
            return find;
        }
        Dict find = this.erpCommonMapper.getDict(parentCode, null, code, null);
        if (null == find) return null;
        ConcurrentHashMap<String, Dict> new_ = new ConcurrentHashMap<String, Dict>();
        new_.put(code, find);
        dictCodeMap.put(parentCode, new_);
        return find;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dict getDictByName(String parentCode, String name) {
        if (dictNameMap.get(parentCode) != null) {
            if (dictNameMap.get(parentCode).get(name) != null) return MyCopy.copy(dictNameMap.get(parentCode).get(name));
            Dict find = this.erpCommonMapper.getDict(parentCode, null, null, name);
            if (null == find) return null;
            dictNameMap.get(parentCode).put(name, find);
            return find;
        }
        Dict find = this.erpCommonMapper.getDict(parentCode, null, null, name);
        if (null == find) return null;
        ConcurrentHashMap<String, Dict> new_ = new ConcurrentHashMap<String, Dict>();
        new_.put(name, find);
        dictNameMap.put(parentCode, new_);
        return find;
    }

    public ShopLogistic getShopLogistic(String shopId, String logisticId) {
        String key = shopId + "|" + logisticId;
        if (shopLogisticMap.get(key) == null) {
            ShopLogistic find = this.erpCommonMapper.getShopLogistic(shopId, logisticId);
            if (null != find) {
                shopLogisticMap.put(key, find);
                return find;
            }
        } else {
            return MyCopy.copy(shopLogisticMap.get(key));
        }
        return null;
    }

    private synchronized void clear() {
        matIdMap.clear();
        matCodeMap.clear();
        matNameMap.clear();
        matCbarcodeMap.clear();
        custIdMap.clear();
        custCodeMap.clear();
        custNameMap.clear();
        storeIdMap.clear();
        storeCodeMap.clear();
        storeNameMap.clear();
        factoryIdMap.clear();
        factoryCodeMap.clear();
        factoryNameMap.clear();
        deptIdMap.clear();
        deptCodeMap.clear();
        deptNameMap.clear();
        classIdMap.clear();
        classCodeMap.clear();
        classNameMap.clear();
        logisticIdMap.clear();
        logisticCodeMap.clear();
        logisticNameMap.clear();
        logisticOutCodeMap.clear();
        shopIdMap.clear();
        shopCodeMap.clear();
        shopOutCodeMap.clear();
        shopNameMap.clear();
        empIdMap.clear();
        empCodeMap.clear();
        empNameMap.clear();
        packingNumMap.clear();
        freshnessKeyMap.clear();
        dictIdMap.clear();
        dictCodeMap.clear();
        dictNameMap.clear();
        this.classMapInit();
    }

    public Mat getMatById(String id) {
        if (matIdMap.get(id) == null) {
            Mat find = this.erpCommonMapper.getMat(id, null, null, null);
            if (null != find) {
                matIdMap.put(id, find);
                matCodeMap.put(find.getCode(), find);
                matNameMap.put(find.getName(), find);
                matCbarcodeMap.put(find.getCbarcode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matIdMap.get(id));
        }
        return null;
    }

    public Cust getCustById(String id) {
        if (custIdMap.get(id) == null) {
            Cust find = this.erpCommonMapper.getCust(id, null, null);
            if (null != find) {
                custIdMap.put(id, find);
                custCodeMap.put(find.getCode(), find);
                custNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(custIdMap.get(id));
        }
        return null;
    }

    public Store getStoreById(String id) {
        if (storeIdMap.get(id) == null) {
            Store find = this.erpCommonMapper.getStore(id, null, null);
            if (null != find) {
                storeIdMap.put(id, find);
                storeCodeMap.put(find.getCode(), find);
                storeNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(storeIdMap.get(id));
        }
        return null;
    }

    public Factory getFactoryById(String id) {
        if (factoryIdMap.get(id) == null) {
            Factory find = this.erpCommonMapper.getFactory(id, null, null);
            if (null != find) {
                factoryIdMap.put(id, find);
                factoryCodeMap.put(find.getCode(), find);
                factoryNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(factoryIdMap.get(id));
        }
        return null;
    }

    public Dept getDeptById(String id) {
        if (deptIdMap.get(id) == null) {
            Dept find = this.erpCommonMapper.getDept(id, null, null);
            if (null != find) {
                deptIdMap.put(id, find);
                deptCodeMap.put(find.getCode(), find);
                deptNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(deptIdMap.get(id));
        }
        return null;
    }

    public Logistic getLogisticById(String id) {
        if (logisticIdMap.get(id) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(id, null, null, null);
            if (null != find) {
                logisticIdMap.put(id, find);
                logisticCodeMap.put(find.getCode(), find);
                logisticNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    logisticOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(logisticIdMap.get(id));
        }
        return null;
    }

    public Shop getShopById(String id) {
        if (shopIdMap.get(id) == null) {
            Shop find = this.erpCommonMapper.getShop(id, null, null, null);
            if (null != find) {
                shopIdMap.put(id, find);
                shopCodeMap.put(find.getCode(), find);
                shopNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    shopOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(shopIdMap.get(id));
        }
        return null;
    }

    public MatClass getMatClassById(String id) {
        if (classIdMap.get(id) == null) {
            List<MatClass> finds = this.erpCommonMapper.matClass(id, null, null);
            if (null != finds && finds.size() > 0) {
                classIdMap.put(id, finds.get(0));
                classCodeMap.put(finds.get(0).getCode(), finds.get(0));
                classNameMap.put(finds.get(0).getName(), finds.get(0));
                return finds.get(0);
            }
        } else {
            return MyCopy.copy(classIdMap.get(id));
        }
        return null;
    }

    public Mat getMatByCode(String code) {
        if (matCodeMap.get(code) == null) {
            Mat find = this.erpCommonMapper.getMat(null, code, null, null);
            if (null != find) {
                matCodeMap.put(code, find);
                matIdMap.put(find.getCguid(), find);
                matNameMap.put(find.getName(), find);
                matCbarcodeMap.put(find.getCbarcode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matCodeMap.get(code));
        }
        return null;
    }

    public Cust getCustByCode(String code) {
        if (custCodeMap.get(code) == null) {
            Cust find = this.erpCommonMapper.getCust(null, code, null);
            if (null != find) {
                custCodeMap.put(code, find);
                custIdMap.put(find.getCguid(), find);
                custNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(custCodeMap.get(code));
        }
        return null;
    }

    public Store getStoreByCode(String code) {
        if (storeCodeMap.get(code) == null) {
            Store find = this.erpCommonMapper.getStore(null, code, null);
            if (null != find) {
                storeCodeMap.put(code, find);
                storeIdMap.put(find.getCguid(), find);
                storeNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(storeCodeMap.get(code));
        }
        return null;
    }

    public Factory getFactoryByCode(String code) {
        if (factoryCodeMap.get(code) == null) {
            Factory find = this.erpCommonMapper.getFactory(null, code, null);
            if (null != find) {
                factoryCodeMap.put(code, find);
                factoryIdMap.put(find.getCguid(), find);
                factoryNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(factoryCodeMap.get(code));
        }
        return null;
    }

    public Dept getDeptByCode(String code) {
        if (deptCodeMap.get(code) == null) {
            Dept find = this.erpCommonMapper.getDept(null, code, null);
            if (null != find) {
                deptCodeMap.put(code, find);
                deptIdMap.put(find.getCguid(), find);
                deptNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(deptCodeMap.get(code));
        }
        return null;
    }

    public Logistic getLogisticByCode(String code) {
        if (logisticCodeMap.get(code) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(null, code, null, null);
            if (null != find) {
                logisticCodeMap.put(code, find);
                logisticIdMap.put(find.getCguid(), find);
                logisticNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    logisticOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(logisticCodeMap.get(code));
        }
        return null;
    }

    public Shop getShopByCode(String code) {
        if (shopCodeMap.get(code) == null) {
            Shop find = this.erpCommonMapper.getShop(null, code, null, null);
            if (null != find) {
                shopCodeMap.put(code, find);
                shopIdMap.put(find.getCguid(), find);
                shopNameMap.put(find.getName(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    shopOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(shopCodeMap.get(code));
        }
        return null;
    }

    public Mat getMatByName(String name) {
        if (matNameMap.get(name) == null) {
            Mat find = this.erpCommonMapper.getMat(null, null, name, null);
            if (null != find) {
                matNameMap.put(name, find);
                matIdMap.put(find.getCguid(), find);
                matCodeMap.put(find.getCode(), find);
                matCbarcodeMap.put(find.getCbarcode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matNameMap.get(name));
        }
        return null;
    }

    public Mat getMatByCbarcode(String cbarcode) {
        if (matCbarcodeMap.get(cbarcode) == null) {
            Mat find = this.erpCommonMapper.getMat(null, null, null, cbarcode);
            if (null != find) {
                matCbarcodeMap.put(cbarcode, find);
                matIdMap.put(find.getCguid(), find);
                matCodeMap.put(find.getCode(), find);
                matNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(matCbarcodeMap.get(cbarcode));
        }
        return null;
    }

    public Cust getCustByName(String name) {
        if (custNameMap.get(name) == null) {
            Cust find = this.erpCommonMapper.getCust(null, null, name);
            if (null != find) {
                custNameMap.put(name, find);
                custIdMap.put(find.getCguid(), find);
                custCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(custNameMap.get(name));
        }
        return null;
    }

    public Store getStoreByName(String name) {
        if (storeNameMap.get(name) == null) {
            Store find = this.erpCommonMapper.getStore(null, null, name);
            if (null != find) {
                storeNameMap.put(name, find);
                storeIdMap.put(find.getCguid(), find);
                storeCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(storeNameMap.get(name));
        }
        return null;
    }

    public Factory getFactoryByName(String name) {
        if (factoryNameMap.get(name) == null) {
            Factory find = this.erpCommonMapper.getFactory(null, null, name);
            if (null != find) {
                factoryNameMap.put(name, find);
                factoryIdMap.put(find.getCguid(), find);
                factoryCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(factoryNameMap.get(name));
        }
        return null;
    }

    public Dept getDeptByName(String name) {
        if (deptNameMap.get(name) == null) {
            Dept find = this.erpCommonMapper.getDept(null, null, name);
            if (null != find) {
                deptNameMap.put(name, find);
                deptIdMap.put(find.getCguid(), find);
                deptCodeMap.put(find.getCode(), find);
                return find;
            }
        } else {
            return MyCopy.copy(deptNameMap.get(name));
        }
        return null;
    }

    public Logistic getLogisticByName(String name) {
        if (logisticNameMap.get(name) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(null, null, name, null);
            if (null != find) {
                logisticNameMap.put(name, find);
                logisticCodeMap.put(find.getCode(), find);
                logisticIdMap.put(find.getCguid(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    logisticOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(logisticNameMap.get(name));
        }
        return null;
    }

    public Shop getShopByName(String name) {
        if (shopNameMap.get(name) == null) {
            Shop find = this.erpCommonMapper.getShop(null, null, name, null);
            if (null != find) {
                shopNameMap.put(name, find);
                shopCodeMap.put(find.getCode(), find);
                shopIdMap.put(find.getCguid(), find);
                if (StringUtils.isNotBlank((CharSequence)find.getOutCode())) {
                    shopOutCodeMap.put(find.getOutCode(), find);
                }
                return find;
            }
        } else {
            return MyCopy.copy(shopNameMap.get(name));
        }
        return null;
    }

    public MatClass getMatClassByName(String name) {
        if (classNameMap.get(name) == null) {
            List<MatClass> finds = this.erpCommonMapper.matClass(null, null, name);
            if (null != finds && finds.size() > 0) {
                classNameMap.put(name, finds.get(0));
                classCodeMap.put(finds.get(0).getCode(), finds.get(0));
                classIdMap.put(finds.get(0).getCguid(), finds.get(0));
                return finds.get(0);
            }
        } else {
            return MyCopy.copy(classNameMap.get(name));
        }
        return null;
    }

    public Logistic getLogisticByOutCode(String outCode) {
        if (logisticOutCodeMap.get(outCode) == null) {
            Logistic find = this.erpCommonMapper.getLogistic(null, null, null, outCode);
            if (null != find) {
                logisticOutCodeMap.put(outCode, find);
                logisticCodeMap.put(find.getCode(), find);
                logisticIdMap.put(find.getCguid(), find);
                logisticNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(logisticOutCodeMap.get(outCode));
        }
        return null;
    }

    public Shop getShopByOutCode(String outCode) {
        if (shopOutCodeMap.get(outCode) == null) {
            Shop find = this.erpCommonMapper.getShop(null, null, null, outCode);
            if (null != find) {
                shopOutCodeMap.put(outCode, find);
                shopCodeMap.put(find.getCode(), find);
                shopIdMap.put(find.getCguid(), find);
                shopNameMap.put(find.getName(), find);
                return find;
            }
        } else {
            return MyCopy.copy(shopOutCodeMap.get(outCode));
        }
        return null;
    }

    private void classMapInit() {
        this.log.info("\u83b7\u53d6\u4ea7\u54c1\u7ebf\u5f00\u59cb=\u300b");
        List<MatClass> list = this.erpCommonMapper.matClass(null, null, null);
        list.forEach(matClass -> {
            classIdMap.put(matClass.getCguid(), (MatClass)matClass);
            classCodeMap.put(matClass.getCode(), (MatClass)matClass);
            classNameMap.put(matClass.getName(), (MatClass)matClass);
        });
        this.log.info("\u83b7\u53d6\u4ea7\u54c1\u7ebf\u7ed3\u675f=\u300b");
    }

    public Packing getPacking(String custId, String matId) {
        String key = custId + "|" + matId;
        if (packingNumMap.get(key) == null) {
            Packing find = this.erpCommonMapper.getPacking(custId, matId);
            if (null != find) {
                packingNumMap.put(key, find);
                return find;
            }
        } else {
            return MyCopy.copy(packingNumMap.get(key));
        }
        return null;
    }

    public void sendMessage(Cache message) {
        this.jmsTemplate.send(DELETE_CACHE, session -> {
            TextMessage textMessage = session.createTextMessage(JSONObject.toJSONString((Object)message));
            return textMessage;
        });
    }

    @JmsListener(containerFactory="listenerArtemisFactory", destination="DELETE_CACHE")
    public void receiveMessage(TextMessage message) throws JMSException {
        Cache cache = null;
        try {
            cache = (Cache)JSONObject.parseObject((String)message.getText(), Cache.class);
        }
        catch (Exception e) {
            return;
        }
        if (null == cache || StringUtils.isBlank((CharSequence)cache.getType()) || StringUtils.isBlank((CharSequence)cache.getKey())) {
            return;
        }
        if (cache.getType().equals("Cust")) {
            this.log.info("\u6e05\u9664Cust\uff1a=\u300b{}", (Object)message.getText());
            Cust obj = custIdMap.get(cache.getKey());
            if (null != obj) {
                custIdMap.remove(obj.getCguid());
                custNameMap.remove(obj.getName());
                custCodeMap.remove(obj.getCode());
            }
        } else if (cache.getType().equals("Dept")) {
            this.log.info("\u6e05\u9664Dept\uff1a=\u300b{}", (Object)message.getText());
            Dept obj = deptIdMap.get(cache.getKey());
            if (null != obj) {
                deptIdMap.remove(obj.getCguid());
                deptCodeMap.remove(obj.getCode());
                deptNameMap.remove(obj.getName());
            }
        } else if (cache.getType().equals("Factory")) {
            this.log.info("\u6e05\u9664Factory\uff1a=\u300b{}", (Object)message.getText());
            Factory obj = factoryIdMap.get(cache.getKey());
            if (null != obj) {
                factoryIdMap.remove(obj.getCguid());
                factoryCodeMap.remove(obj.getCode());
                factoryNameMap.remove(obj.getName());
            }
        } else if (cache.getType().equals("Logistic")) {
            this.log.info("\u6e05\u9664Logistic\uff1a=\u300b{}", (Object)message.getText());
            Logistic obj = logisticIdMap.get(cache.getKey());
            if (null != obj) {
                logisticIdMap.remove(obj.getCguid());
                logisticCodeMap.remove(obj.getCode());
                logisticNameMap.remove(obj.getName());
                logisticOutCodeMap.remove(obj.getOutCode());
            }
        } else if (cache.getType().equals("Mat")) {
            this.log.info("\u6e05\u9664Mat\uff1a=\u300b{}", (Object)message.getText());
            Mat obj = matIdMap.get(cache.getKey());
            if (null != obj) {
                matIdMap.remove(obj.getCguid());
                matCodeMap.remove(obj.getCode());
                matNameMap.remove(obj.getName());
                matCbarcodeMap.remove(obj.getCbarcode());
            }
        } else if (cache.getType().equals("MatClass")) {
            this.log.info("\u6e05\u9664MatClass\uff1a=\u300b{}", (Object)message.getText());
            MatClass obj = classIdMap.get(cache.getKey());
            if (null != obj) {
                classIdMap.remove(obj.getCguid());
                classCodeMap.remove(obj.getCode());
                classNameMap.remove(obj.getName());
            }
        } else if (cache.getType().equals("Packing")) {
            this.log.info("\u6e05\u9664Packing\uff1a=\u300b{}", (Object)message.getText());
            Packing obj = packingNumMap.get(cache.getKey());
            if (null != obj) {
                packingNumMap.remove(cache.getKey());
            }
        } else if (cache.getType().equals("Shop")) {
            this.log.info("\u6e05\u9664Shop\uff1a=\u300b{}", (Object)message.getText());
            Shop obj = shopIdMap.get(cache.getKey());
            if (null != obj) {
                shopIdMap.remove(obj.getCguid());
                shopCodeMap.remove(obj.getCode());
                shopNameMap.remove(obj.getName());
                shopOutCodeMap.remove(obj.getOutCode());
            }
        } else if (cache.getType().equals("Store")) {
            this.log.info("\u6e05\u9664Store\uff1a=\u300b{}", (Object)message.getText());
            Store obj = storeIdMap.get(cache.getKey());
            if (null != obj) {
                storeIdMap.remove(obj.getCguid());
                storeCodeMap.remove(obj.getCode());
                storeNameMap.remove(obj.getName());
            }
        } else if (cache.getType().equals("Emp")) {
            this.log.info("\u6e05\u9664Emp\uff1a=\u300b{}", (Object)message.getText());
            Store obj = storeIdMap.get(cache.getKey());
            if (null != obj) {
                empIdMap.remove(obj.getCguid());
                empCodeMap.remove(obj.getCode());
                empNameMap.remove(obj.getName());
            }
        } else if (cache.getType().equals("Freshness")) {
            this.log.info("\u6e05\u9664Freshness\uff1a=\u300b{}", (Object)message.getText());
            Freshness obj = freshnessKeyMap.get(cache.getKey());
            if (null != obj) {
                freshnessKeyMap.remove(cache.getKey());
            }
        } else if (cache.getType().equals("Dict")) {
            this.log.info("\u6e05\u9664Dict\u6839\u636e\u7236\u7c7b\u7f16\u7801\uff1a=\u300b{}", (Object)message.getText());
            ConcurrentHashMap<String, Dict> obj = dictIdMap.get(cache.getKey());
            if (null != obj) {
                dictIdMap.remove(cache.getKey());
                dictCodeMap.remove(cache.getKey());
                dictNameMap.remove(cache.getKey());
            }
        } else if (cache.getType().equals("ShopLogistic")) {
            this.log.info("\u6e05\u9664ShopLogistic\uff1a=\u300b{}", (Object)message.getText());
            ShopLogistic obj = shopLogisticMap.get(cache.getKey());
            if (null != obj) {
                shopLogisticMap.remove(cache.getKey());
            }
        } else if (cache.getType().equals("all")) {
            this.log.info("\u6e05\u9664all\uff1a=\u300b{}", (Object)message.getText());
            this.clear();
        }
    }
}

