/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.batch;

import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.erp.domain.batch.BatchRedis;
import cc.lechun.erp.domain.batch.entity.CanUseQty;
import cc.lechun.erp.domain.batch.entity.batch.MatchBatch;
import cc.lechun.erp.domain.batch.entity.batch.Product;
import cc.lechun.erp.domain.batch.entity.batch.ReturnProduct;
import cc.lechun.erp.util.MyCopy;
import cc.lechun.erp.util.MyDateUtil;
import cc.lechun.erp.util.redisLock.ErpRedisLock;
import cc.lechun.framework.common.utils.date.DateUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatchTheBatchDomainTobOrTocNewService {
    @Autowired
    protected ErpRedisLock erpRedisLock;
    @Autowired
    protected BatchRedis batchRedis;
    @Autowired
    private ErpCommonMapper erpCommonMapper;

    public void matchTobBatchByOrder(MatchBatch o, boolean matchByPacking) throws Exception {
        Map<String, List<Product>> matIds = o.getList().stream().collect(Collectors.groupingBy(Product::getProductId));
        for (Map.Entry<String, List<Product>> product : matIds.entrySet()) {
            String matAndStore = product.getKey() + "|" + o.getStoreId();
            this.matchTobBatchByOrder(o.getPickupTime(), product.getValue(), matAndStore, matchByPacking);
        }
        this.ifBackStoreTobNumByOrder(o);
    }

    public void ifBackStoreTobNumByOrder(MatchBatch o) throws Exception {
        BigDecimal productNumSum = o.getList().stream().map(Product::getProductNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (productNumSum.doubleValue() > 0.0) {
            o.setStatus(500);
            for (Product v : o.getList()) {
                String matAndStore = v.getProductId() + "|" + o.getStoreId();
                this.ifBackStoreTobNumByOrder(v, matAndStore);
                if (v.getProductNum().doubleValue() == 0.0) continue;
                v.setStatus(500);
                v.setErroMessage("\u5e93\u5b58\u4e0d\u8db3");
            }
        }
    }

    public void ifBackStoreTobNumByOrder(Product v, String matAndStore) throws Exception {
        this.erpRedisLock.myLock("matAndStore" + matAndStore, () -> {
            for (Map.Entry<String, ReturnProduct> mappr : v.getReturnMap().entrySet()) {
                this.batchRedis.setAddBatch(mappr.getKey(), mappr.getValue().getProductNum());
            }
        });
    }

    public void matchTobBatchByOrder(Date picupdate, List<Product> vs, String matAndStore, boolean matchByPacking) throws Exception {
        this.erpRedisLock.myLock("matAndStore" + matAndStore, () -> {
            String[] sp = matAndStore.split("\\|");
            Map<String, BigDecimal> canUseQtyMap = this.getCanUseQty(sp[1], sp[0]);
            for (Product v : vs) {
                this.matchTobMoreBatchByOrder(picupdate, v, matAndStore, canUseQtyMap, matchByPacking);
                this.matchTobOneBatchByOrder(picupdate, v, matAndStore, canUseQtyMap, matchByPacking);
            }
        });
    }

    void matchTobMoreBatchByOrder(Date picupdate, Product o, String matAndStore, Map<String, BigDecimal> canUseQtyMap, boolean matchByPacking) throws Exception {
        if (o.getIfMoreBatch().equals("\u662f")) {
            if (o.getIfBatch() == 1) {
                List<BigDecimal> everyPackMatNumS = o.everyPackMatNum();
                String key = matAndStore + "|";
                if (null == o.getProdTime()) {
                    List<Integer> dates = MyDateUtil.getFresshDates(picupdate, o.getFreshnessStart(), o.getFreshnessEnd());
                    for (Integer date : dates) {
                        if (o.getProductNum().doubleValue() != 0.0) {
                            String key1 = key + date;
                            this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, DateUtils.getDateFromString((String)(date + ""), (String)"yyyyMMdd"), matchByPacking);
                            continue;
                        }
                        break;
                    }
                } else {
                    String key1 = key + DateUtils.formatDate((Date)o.getProdTime(), (String)"yyyyMMdd");
                    this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, o.getProdTime(), matchByPacking);
                }
            } else {
                this.matchTobBatchByOrder(o, matAndStore, canUseQtyMap, Collections.singletonList(o.getProductNum()), null, matchByPacking);
            }
        }
    }

    void matchTobBatchByOrder(Product o, String matAndStore, Map<String, BigDecimal> canUseQtyMap, List<BigDecimal> everyPackMatNumS, Date prodTime, boolean matchByPacking) {
        if (canUseQtyMap.containsKey(matAndStore) && null != everyPackMatNumS) {
            for (BigDecimal everyPackMatNum_ : everyPackMatNumS) {
                BigDecimal everyPackMatNum = MyCopy.copy(everyPackMatNum_);
                if (!matchByPacking) {
                    everyPackMatNum = o.getProductNum();
                }
                if (o.getProductNum().doubleValue() == 0.0) break;
                BigDecimal canUse = this.batchRedis.getBatch(matAndStore, canUseQtyMap);
                if (canUse.doubleValue() == 0.0) continue;
                if (canUse.subtract(everyPackMatNum).doubleValue() >= 0.0) {
                    canUseQtyMap.put(matAndStore, canUse.subtract(everyPackMatNum));
                    o.setProductNum(o.getProductNum().subtract(everyPackMatNum));
                } else {
                    o.setProductNum(o.getProductNum().subtract(everyPackMatNum));
                    canUseQtyMap.put(matAndStore, new BigDecimal(0));
                }
                o.returnMap(matAndStore, everyPackMatNum, prodTime);
                this.batchRedis.setBatch(matAndStore, canUseQtyMap.get(matAndStore));
            }
        }
    }

    void matchTobOneBatchByOrder(Date picupdate, Product o, String matAndStore, Map<String, BigDecimal> canUseQtyMap, boolean matchByPacking) {
        if (!o.getIfMoreBatch().equals("\u662f")) {
            List<BigDecimal> everyPackMatNumS = Collections.singletonList(o.getProductNum());
            if (o.getIfBatch() == 1) {
                String key = matAndStore + "|";
                if (null == o.getProdTime()) {
                    List<Integer> dates = MyDateUtil.getFresshDates(picupdate, o.getFreshnessStart(), o.getFreshnessEnd());
                    for (Integer date : dates) {
                        String key1 = key + date;
                        this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, DateUtils.getDateFromString((String)(date + ""), (String)"yyyyMMdd"), matchByPacking);
                    }
                } else {
                    String key1 = key + DateUtils.formatDate((Date)o.getProdTime(), (String)"yyyyMMdd");
                    this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, o.getProdTime(), matchByPacking);
                }
            } else {
                this.matchTobBatchByOrder(o, matAndStore, canUseQtyMap, everyPackMatNumS, null, matchByPacking);
            }
        }
    }

    private Map<String, BigDecimal> getCanUseQty(String storeId, final String matId) {
        List<CanUseQty> list = this.erpCommonMapper.getCanUseQty(storeId, new HashSet<String>(){
            {
                this.add(matId);
            }
        });
        return list.stream().collect(Collectors.toMap(CanUseQty::getOneKey, CanUseQty::getCanUseQty));
    }
}

