/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.config.imp;

import cc.lechun.erp.config.entity.OrderNo;
import cc.lechun.framework.core.common.SpringGetBeanUtil;
import com.alibaba.fastjson.JSONObject;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.core.JmsTemplate;

public abstract class JmsOrderMain {
    private Logger log = LoggerFactory.getLogger((String)"PullOrderMain");
    private static final String DATE_CODE = "ORDER_NO";

    public void send(OrderNo orderNo) {
        try {
            ((JmsTemplate)SpringGetBeanUtil.getBean((String)"jmsTemplateQueue")).send(DATE_CODE, session -> {
                this.log.info("JMS=====\u53d1\u9001======> \u5355\u53f7:" + orderNo.getOrderNo());
                return session.createTextMessage(JSONObject.toJSONString((Object)orderNo));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JmsListener(containerFactory="listenerQueueFactory", destination="ORDER_NO")
    public void getOrderNo(TextMessage message) throws JMSException {
        OrderNo orderNo = (OrderNo)JSONObject.parseObject((String)message.getText(), OrderNo.class);
        this.log.info("JMS=====\u83b7\u53d6======> \u5355\u53f7:" + orderNo.getOrderNo());
        if (!this.doOrderNo(orderNo)) {
            this.send(orderNo);
        }
    }

    public abstract boolean doOrderNo(OrderNo var1);
}

