/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.config.imp;

import cc.lechun.erp.config.entity.Log;
import cc.lechun.erp.dao.common.ErpCommonMapper;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogMain {
    private Logger log = LoggerFactory.getLogger((String)"LogMain");
    @Autowired
    @Qualifier(value="jmsTemplateQueue")
    private JmsTemplate jmsTemplate;
    @Resource
    private HttpServletRequest request;
    @Autowired
    private ErpCommonMapper erpCommonMapper;

    public void addLog(String function, String operateContent, String dateCode) {
        try {
            BaseUser user = JedisUtils.getBaseUser((HttpServletRequest)this.request);
            Log message = new Log(function, operateContent, dateCode, this.getIpAddr(this.request), user.getEmployeeName());
            this.jmsTemplate.send("ADD_LOG", session -> session.createTextMessage(JSONObject.toJSONString((Object)message)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JmsListener(containerFactory="listenerQueueFactory", destination="ADD_LOG")
    @Transactional(rollbackFor={Exception.class})
    public void getLog(TextMessage message) throws JMSException {
        long idA = System.currentTimeMillis();
        Log log = (Log)JSONObject.parseObject((String)message.getText(), Log.class);
        log.setCguid(IDGenerate.getUniqueIdStr() + idA);
        log.setOperateTime(new Date());
        try {
            this.erpCommonMapper.addLog(log);
        }
        catch (Exception e) {
            log.setCguid(IDGenerate.getUniqueIdStr() + idA);
            this.erpCommonMapper.addLog(log);
        }
    }

    private String getIpAddr(HttpServletRequest request) {
        if (null == request) {
            return "127.0.0.1";
        }
        String ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("X-Forwarded-For")) ? request.getHeader("X-Forwarded-For") : request.getHeader("x-forwarded-for");
        this.log.info(ipAddresses);
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("Proxy-Client-IP")) ? request.getHeader("Proxy-Client-IP") : request.getHeader("proxy-Client-ip");
            this.log.info(ipAddresses);
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("WL-Proxy-Client-IP")) ? request.getHeader("WL-Proxy-Client-IP") : request.getHeader("wl-proxy-client-ip");
            this.log.info(ipAddresses);
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("HTTP_CLIENT_IP")) ? request.getHeader("HTTP_CLIENT_IP") : request.getHeader("http_client_ip");
            this.log.info(ipAddresses);
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("X-Real-IP")) ? request.getHeader("X-Real-IP") : request.getHeader("x-real-ip");
            this.log.info(ipAddresses);
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getRemoteAddr();
            this.log.info(ipAddresses);
        }
        if (StringUtils.isNotBlank((CharSequence)ipAddresses) && ipAddresses.equals("0:0:0:0:0:0:0:1")) {
            ipAddresses = "127.0.0.1";
            this.log.info(ipAddresses);
        }
        return ipAddresses;
    }
}

