/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common.domain;

import cc.lechun.erp.config.imp.CacheMainDel;
import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.domain.batch.entity.CanUseFiled;
import cc.lechun.erp.domain.batch.entity.CanUseQty;
import cc.lechun.erp.domain.common.domain.MatDo;
import cc.lechun.erp.domain.common.domain.StoreDo;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.util.method.Method;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperationDataMapperDo
implements Serializable {
    public static String getCanUseKey(String storeId, String matId, Date productionDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(matId).append("|");
        sb.append(storeId);
        if (null != productionDate) {
            sb.append("|").append(DateUtils.formatDate((Date)productionDate, (String)"yyyyMMdd"));
        }
        return sb.toString();
    }

    public static BaseJsonVo<String> getCanUseQtys(String storeId, List<CanUseFiled> mats, Object notInOrderType) {
        List matIds = mats.stream().map(v -> v.getMatId()).collect(Collectors.toList());
        List<CanUseQty> list = OperationDataMapperDo.getCanUseQty(storeId, matIds, notInOrderType);
        Map<String, CanUseQty> canUseMap = list.stream().collect(Collectors.toMap(m -> m.getOneKey(), canUseQty -> canUseQty));
        Map<String, List<CanUseFiled>> mapGroup = mats.stream().collect(Collectors.groupingBy(s -> OperationDataMapperDo.getCanUseKey(storeId, s.getMatId(), s.getProductionDate())));
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, List<CanUseFiled>> group : mapGroup.entrySet()) {
            BigDecimal matNumSum = group.getValue().stream().map(v -> v.getMatNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (canUseMap.containsKey(group.getKey())) {
                BigDecimal diff = matNumSum.subtract(canUseMap.get(group.getKey()).getCanUseQty());
                if (!(diff.doubleValue() > 0.0)) continue;
                sb.append("\u4ed3\u5e93(" + StoreDo.id(storeId).getName() + ")\u7269\u54c1(" + MatDo.id(group.getValue().get(0).getMatId()).getName());
                if (null != group.getValue().get(0).getProductionDate()) {
                    sb.append("- \u6279\u6b21 :").append(DateUtils.formatDate((Date)group.getValue().get(0).getProductionDate(), (String)"yyyyMMdd"));
                }
                sb.append(")\u53f0\u8d26\u5dee(" + diff.doubleValue() + ")\u4e2a").append("\u3002");
                continue;
            }
            sb.append("\u4ed3\u5e93(" + StoreDo.id(storeId).getName() + ")\u7269\u54c1(" + MatDo.id(group.getValue().get(0).getMatId()).getName());
            if (null != group.getValue().get(0).getProductionDate()) {
                sb.append("- \u6279\u6b21 :").append(DateUtils.formatDate((Date)group.getValue().get(0).getProductionDate(), (String)"yyyyMMdd"));
            }
            sb.append(") \u53f0\u8d26\u5dee(" + matNumSum.doubleValue() + ")\u4e2a").append("\u3002");
        }
        if (!sb.toString().equals("")) {
            return BaseJsonVo.error((String)sb.toString());
        }
        return BaseJsonVo.success((Object)"");
    }

    private static List<CanUseQty> getCanUseQty(Object storeIds, Object matIds, Object notInOrderType) {
        return Method.getBean(ErpOperationDataMapper.class).getCanUseQty(storeIds, matIds, notInOrderType);
    }

    public static void updateShopToken(String id, String shopToken) {
        Method.getBean(ErpOperationDataMapper.class).updateShopToken(id, shopToken);
        CacheMainDel.delete(Shop.delteCache("all"));
    }

    public static void saveDispatchOrderAccountDetails(String mainId, String storeId) {
        Method.getBean(ErpOperationDataMapper.class).saveDispatchOrderAccountDetails(mainId, storeId, "\u53d1\u8d27\u5355", "0");
    }

    public static void saveStoreOrderAccountDetails(String mainId, String storeId, String billType, String inOuttype) {
        Method.getBean(ErpOperationDataMapper.class).saveStoreOrderAccountDetails(mainId, storeId, billType, inOuttype);
    }

    public static void savePuStoreOrderAccountDetails(String mainId, String storeId) {
        Method.getBean(ErpOperationDataMapper.class).savePuStoreOrderAccountDetails(mainId, storeId, "\u91c7\u8d2d\u5165\u5e93\u5355", "1");
    }
}

