/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util.redisLock;

import cc.lechun.erp.util.redisLock.classnew.MyMethod;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.stereotype.Service;

@Service
public class ErpRedisReturnLock {
    private static final Logger log = LoggerFactory.getLogger((String)"RedisReturnDatasLock");
    private static final Long timeout = 60000L;
    private static final String Lock = "RedisLock";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public <T> T myLock(String key, MyMethod<T> method) {
        long a = System.currentTimeMillis();
        T flag = this.lock(Lock + key, method);
        long b = System.currentTimeMillis();
        log.info("--------------\u9501\u5185\u6267\u884c\u6570\u636e\u8017\u65f6-------------------" + (double)(b - a) / 1000.0);
        return flag;
    }

    private <T> T lock(String key, MyMethod<T> method) {
        T t = null;
        long startTime = System.currentTimeMillis();
        String randomStr = String.valueOf(IDGenerate.getUniqueID());
        boolean flag = this.tryLock(key, randomStr);
        if (flag) {
            try {
                t = method.runMethod();
                this.unlock(key, randomStr);
            }
            catch (Exception e) {
                log.error("< \u5206\u5e03\u5f0f\u9501 (" + key + ")\uff08" + flag + "\uff09\u9501\u5185\u8fd0\u884c\u7a0b\u5e8f\u5f02\u5e38 > {}", (Throwable)e);
                this.unlock(key, randomStr);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("< \u5206\u5e03\u5f0f\u9501 (" + key + ") \uff08" + flag + "\uff09\uff0c\u8fd0\u884c \u8017\u65f6 \uff1a" + (endTime - startTime) + " \u6beb\u79d2 >");
        return t;
    }

    private boolean tryLock(String key, String randomStr) {
        try {
            int tryTimes = 0;
            while ((long)tryTimes <= timeout / 500L + 1L) {
                String currentValue = (String)this.redisTemplate.opsForValue().get((Object)key);
                long a = System.currentTimeMillis();
                if (currentValue == null || currentValue.equals("")) {
                    Boolean lockC = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)randomStr);
                    if (lockC.booleanValue()) {
                        boolean expireFlag = this.setExpire(key);
                        if (expireFlag) {
                            long b = System.currentTimeMillis();
                            log.info("\u65f6\u95f4\u7d2f\u52a0 < \u5206\u5e03\u5f0f\u9501 (" + key + ")\uff0c\u52a0\u9501\u9648\u6210\u529fA > \u8017\u65f6 " + (double)(b - a) / 1000.0);
                            return true;
                        }
                        log.info("< \u5206\u5e03\u5f0f\u9501 (" + key + ")\uff0c\u52a0\u9501\u9648\u6210\u529fA >,\u4f46\u662f\u8bbe\u7f6e\u5931\u6548\u5931\u8d25,\u6545\u91ca\u653e\u9501");
                        this.unlock(key, randomStr);
                    }
                } else {
                    TimeUnit.MILLISECONDS.sleep(120L);
                }
                log.error("\u5c1d\u8bd5\u67b7\u9501\u6b21\u6570" + tryTimes++);
            }
        }
        catch (Exception e) {
            log.error("< \u5206\u5e03\u5f0f\u9501 (" + key + ")  > \u52a0\u9501\u5f02\u5e38, {\u975e\u5206\u5e03\u5f0f\u6267\u884c\uff0c\u8bf7\u5c3d\u5feb\u67e5\u627e\u95ee\u9898} {}", (Throwable)e);
            return false;
        }
        return false;
    }

    private void unlock(final String key, final String randomStr) {
        try {
            long a = System.currentTimeMillis();
            SessionCallback<Boolean> sessionCallback = new SessionCallback<Boolean>(){

                public Boolean execute(RedisOperations operations) throws DataAccessException {
                    operations.watch((Object)key);
                    String currentValue = (String)operations.opsForValue().get((Object)key);
                    if (null == currentValue || !currentValue.equals(randomStr)) {
                        return false;
                    }
                    operations.multi();
                    operations.opsForValue().getOperations().delete((Object)key);
                    operations.exec();
                    return true;
                }
            };
            Boolean flag = (Boolean)this.redisTemplate.execute((SessionCallback)sessionCallback);
            long b = System.currentTimeMillis();
            if (flag.booleanValue()) {
                log.info("\u65f6\u95f4\u7d2f\u52a0 < \u5206\u5e03\u5f0f\u9501 (" + key + ")\uff0c\u89e3\u9501\u9648\u6210\u529fA > \u8017\u65f6" + (double)(b - a) / 1000.0);
            } else {
                log.info("\u65f6\u95f4\u7d2f\u52a0 <  \u5206\u5e03\u5f0f\u9501 (" + key + ")\uff0c \u89e3\u9501\u5931\u8d25 > \u8017\u65f6" + (double)(b - a) / 1000.0);
            }
        }
        catch (Exception e) {
            log.error("<  \u5206\u5e03\u5f0f\u9501 (" + key + ")\uff0c \u89e3\u9501\u5f02\u5e38 > {}", (Throwable)e);
        }
    }

    private boolean setExpire(String key) {
        boolean expireFlag = false;
        int tryTimes = 0;
        while (tryTimes < 3) {
            expireFlag = this.redisTemplate.expire((Object)key, timeout.longValue(), TimeUnit.MILLISECONDS);
            if (expireFlag) {
                return expireFlag;
            }
            ++tryTimes;
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error("<  \u5206\u5e03\u5f0f\u9501 \u5f02\u5e38 > {}", (Throwable)e);
                e.printStackTrace();
            }
        }
        return expireFlag;
    }
}

