/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.batch;

import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.domain.batch.entity.CanUseQty;
import cc.lechun.erp.domain.batch.entity.batch.MatchBatch;
import cc.lechun.erp.domain.batch.entity.batch.Product;
import cc.lechun.erp.domain.common.domain.MatDo;
import cc.lechun.erp.domain.common.domain.StoreDo;
import cc.lechun.erp.util.MyDateUtil;
import cc.lechun.erp.util.method.Method;
import cc.lechun.framework.common.utils.date.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MatchTheBatchDomainTobOrTocNewService {
    private static Logger log = LoggerFactory.getLogger((String)"MatchTheBatchDomainTobOrTocNewService");

    public void matchTobBatchByOrder(MatchBatch o, boolean matchByPacking) {
        Map<String, BigDecimal> canUseQtyMap = this.getCanUseQty(o.getStoreId(), o.getList().stream().map(Product::getProductId).collect(Collectors.toList()));
        log.info("canUseQtyMap:{}", (Object)JSONObject.toJSONString(canUseQtyMap));
        Map<String, List<Product>> matIds = o.getList().stream().collect(Collectors.groupingBy(Product::getProductId));
        for (Map.Entry<String, List<Product>> product : matIds.entrySet()) {
            String matAndStore = product.getKey() + "|" + o.getStoreId();
            this.matchTobBatchByOrder(o.getPickupTime(), product.getValue(), matAndStore, matchByPacking, canUseQtyMap);
        }
        log.info("canUseQtyMap:{}", (Object)JSONObject.toJSONString(canUseQtyMap));
        this.ifBackStoreTobNumByOrder(o);
    }

    public void ifBackStoreTobNumByOrder(MatchBatch o) {
        BigDecimal productNumSum = o.getList().stream().map(Product::getProductNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (productNumSum.doubleValue() > 0.0) {
            o.setStatus(500);
            HashSet<String> message = new HashSet<String>();
            for (Product v : o.getList()) {
                if (v.getProductNum().doubleValue() == 0.0) continue;
                v.setStatus(500);
                message.add("\u4ed3\uff08" + StoreDo.id(o.getStoreId()).getName() + "\uff09\u7269\u54c1 \uff08" + MatDo.id(v.getProductId()).getName() + "\uff09\u65b0\u9c9c\u5ea6\uff08" + v.getFreshnessStart() + "-" + v.getFreshnessEnd() + "\uff09 \u8303\u56f4\u5185\u7684\u5e93\u5b58 \u5dee" + v.getProductNum() + "\u4e2a");
            }
            o.setErroMessage(String.join((CharSequence)",", message));
        }
    }

    public void matchTobBatchByOrder(Date picupdate, List<Product> vs, String matAndStore, boolean matchByPacking, Map<String, BigDecimal> canUseQtyMap) {
        for (Product v : vs) {
            this.matchTobMoreBatchByOrder(picupdate, v, matAndStore, canUseQtyMap, matchByPacking);
            this.matchTobOneBatchByOrder(picupdate, v, matAndStore, canUseQtyMap, matchByPacking);
        }
    }

    void matchTobMoreBatchByOrder(Date picupdate, Product o, String matAndStore, Map<String, BigDecimal> canUseQtyMap, boolean matchByPacking) {
        if (o.getIfMoreBatch().equals("\u662f")) {
            if (o.getIfBatch() == 1) {
                List<BigDecimal> everyPackMatNumS = null;
                everyPackMatNumS = matchByPacking ? o.everyPackMatNum() : Collections.singletonList(o.getProductNum());
                String key = matAndStore + "|";
                if (null == o.getProdTime()) {
                    List<String> dates = MyDateUtil.getFresshDatesStr(picupdate, o.getFreshnessStart(), o.getFreshnessEnd());
                    for (String date : dates) {
                        if (o.getProductNum().doubleValue() == 0.0) break;
                        String key1 = key + date + "|" + MatDo.id(o.getProductId()).getIexpirydays().intValue();
                        this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"), matchByPacking);
                    }
                    log.info("everyPackMatNumS:{}", (Object)JSONObject.toJSONString(everyPackMatNumS));
                } else {
                    String key1 = key + DateUtils.formatDate((Date)o.getProdTime(), (String)"yyyy-MM-dd") + "|" + MatDo.id(o.getProductId()).getIexpirydays().intValue();
                    this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, o.getProdTime(), matchByPacking);
                }
            } else {
                this.matchTobBatchByOrder(o, matAndStore, canUseQtyMap, Collections.singletonList(o.getProductNum()), null, matchByPacking);
            }
        }
    }

    void matchTobBatchByOrder(Product o, String matAndStore, Map<String, BigDecimal> canUseQtyMap, List<BigDecimal> everyPackMatNumS, Date prodTime, boolean matchByPacking) {
        log.info("matAndStore:{}", (Object)matAndStore);
        if (canUseQtyMap.containsKey(matAndStore) && null != everyPackMatNumS) {
            Iterator<BigDecimal> iterator = everyPackMatNumS.iterator();
            while (iterator.hasNext()) {
                BigDecimal everyPackMatNum_;
                BigDecimal everyPackMatNum = everyPackMatNum_ = iterator.next();
                if (!matchByPacking) {
                    everyPackMatNum = o.getProductNum();
                }
                if (everyPackMatNum.doubleValue() == 0.0) continue;
                if (o.getProductNum().doubleValue() == 0.0) break;
                BigDecimal canUse = canUseQtyMap.get(matAndStore);
                if (canUse.doubleValue() == 0.0) continue;
                if (canUse.subtract(everyPackMatNum).doubleValue() >= 0.0) {
                    canUseQtyMap.put(matAndStore, canUse.subtract(everyPackMatNum));
                    o.setProductNum(o.getProductNum().subtract(everyPackMatNum));
                    o.returnMap(matAndStore, everyPackMatNum, prodTime);
                    log.info("canUse.subtract(everyPackMatNum):{}  | {} = {}   / {}", new Object[]{canUse, everyPackMatNum, canUse.subtract(everyPackMatNum), o.getProductNum()});
                    continue;
                }
                o.setProductNum(o.getProductNum().subtract(canUse));
                canUseQtyMap.put(matAndStore, new BigDecimal(0));
                o.returnMap(matAndStore, canUse, prodTime);
                log.info("canUse.subtract(everyPackMatNum):{}  | {} = {}   / {}", new Object[]{canUse, everyPackMatNum, canUse.subtract(everyPackMatNum), o.getProductNum()});
            }
        }
    }

    void matchTobOneBatchByOrder(Date picupdate, Product o, String matAndStore, Map<String, BigDecimal> canUseQtyMap, boolean matchByPacking) {
        if (!o.getIfMoreBatch().equals("\u662f")) {
            List<BigDecimal> everyPackMatNumS = Collections.singletonList(o.getProductNum());
            if (o.getIfBatch() == 1) {
                String key = matAndStore + "|";
                if (null == o.getProdTime()) {
                    List<String> dates = MyDateUtil.getFresshDatesStr(picupdate, o.getFreshnessStart(), o.getFreshnessEnd());
                    for (String date : dates) {
                        String key1 = key + date + "|" + MatDo.id(o.getProductId()).getIexpirydays().intValue();
                        this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"), matchByPacking);
                    }
                } else {
                    String key1 = key + DateUtils.formatDate((Date)o.getProdTime(), (String)"yyyy-MM-dd") + "|" + MatDo.id(o.getProductId()).getIexpirydays().intValue();
                    this.matchTobBatchByOrder(o, key1, canUseQtyMap, everyPackMatNumS, o.getProdTime(), matchByPacking);
                }
            } else {
                this.matchTobBatchByOrder(o, matAndStore, canUseQtyMap, everyPackMatNumS, null, matchByPacking);
            }
        }
    }

    private Map<String, BigDecimal> getCanUseQty(String storeId, List<String> matIds) {
        List<CanUseQty> list = Method.getBean(ErpOperationDataMapper.class).getCanUseQty(storeId, matIds, null);
        return list.stream().collect(Collectors.toMap(CanUseQty::getOneKey, CanUseQty::getCanUseQty, (k1, k2) -> k1));
    }
}

