/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.batch;

import cc.lechun.erp.domain.batch.MatchTheBatchDoTobOrToc;
import cc.lechun.erp.domain.batch.entity.batch.MatchBatch;
import cc.lechun.erp.domain.batch.entity.batch.Product;
import cc.lechun.erp.domain.batch.entity.batch.ReturnProduct;
import cc.lechun.erp.domain.common.domain.CustDo;
import cc.lechun.erp.domain.common.domain.MatDo;
import cc.lechun.erp.domain.common.domain.PackingDo;
import cc.lechun.erp.domain.common.domain.StoreDo;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.util.MyCopy;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MatchTheBatchDo {
    private static Logger log = LoggerFactory.getLogger((String)"MatchTheBatchDo");
    @Autowired
    private MatchTheBatchDoTobOrToc matchTheBatchDoTobOrToc;

    @Transactional(rollbackFor={Exception.class})
    public MatchBatch matcBatchByOrder(MatchBatch o) {
        this.checkOrder(o);
        if (o.getStatus() == 200) {
            boolean toB = false;
            if (o.getTypeTobOrToc().equals("B\u7aef") && (o.getOrderSonType() == 1 || o.getOrderSonType() == 5 || o.getOrderSonType() == 13)) {
                toB = true;
            }
            this.checkOrderPacking(o, toB);
            log.info("\u5f00\u59cb\u5339\u914d matchByPacking :{}", (Object)JSONObject.toJSONString((Object)o));
            if (o.getStatus() == 200) {
                this.matchTheBatchDoTobOrToc.matchTobOrTocByOrder(o, toB);
            }
            if (o.getStatus() == 200) {
                this.sumPackingQuantity(o);
            }
        }
        return o;
    }

    private void sumPackingQuantity(MatchBatch o) {
        for (Product p : o.getList()) {
            if (!StringUtils.isNotBlank((CharSequence)p.getPackingId()) || null == p.getReturnMap() || p.getReturnMap().isEmpty()) continue;
            for (Map.Entry<String, ReturnProduct> va : p.getReturnMap().entrySet()) {
                va.getValue().setPackingQuantity(new BigDecimal(va.getValue().getProductNum().intValue() / p.getPackingMatNum().intValue() + (va.getValue().getProductNum().intValue() % p.getPackingMatNum().intValue() > 0 ? 1 : 0)));
            }
        }
    }

    private void checkOrderPacking(MatchBatch order, boolean matchByPacking) {
        HashSet<String> mess = new HashSet<String>();
        for (Product v : order.getList()) {
            if (v.getIfBatch() != 1) continue;
            if (matchByPacking) {
                Packing packing = PackingDo.get_(order.getCustId(), v.getProductId());
                if (null == packing) {
                    mess.add("\u672a\u627e\u5230\u5305\u6750\u914d\u7f6e \u5ba2\u6236\uff08" + CustDo.id(order.getCustId()).getName() + "\uff09 \u7269\u54c1\uff08" + MatDo.id(v.getProductId()).getName() + "\uff09");
                    continue;
                }
                v.setIfMoreBatch(packing.getIfMoreBatch());
                v.setPackingId(packing.getCguid());
                v.setPackingMatNum(packing.getPackingMatNum());
                v.setPackingQuantity(new BigDecimal(v.getProductNum().intValue() / v.getPackingMatNum().intValue() + (v.getProductNum().intValue() % v.getPackingMatNum().intValue() > 0 ? 1 : 0)));
                continue;
            }
            v.setIfMoreBatch("\u662f");
        }
        if (!mess.isEmpty()) {
            order.setStatus(500);
            order.setErroMessage(JSONObject.toJSONString(mess));
        }
    }

    public void checkOrder(MatchBatch order) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)order.getOrderNo())) {
            sb.append("\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
        }
        if (StringUtils.isBlank((CharSequence)order.getCustId())) {
            sb.append("\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
        } else if (CustDo.id(order.getCustId()) == null) {
            sb.append("\u5ba2\u6237id\u4e0d\u5b58\u5728").append("\u3002");
        }
        if (StringUtils.isBlank((CharSequence)order.getStoreId())) {
            sb.append("\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
        } else if (StoreDo.id(order.getStoreId()) == null) {
            sb.append("\u4ed3\u5e93id\u4e0d\u5b58\u5728").append("\u3002");
        }
        if (StringUtils.isBlank((CharSequence)order.getTypeTobOrToc())) {
            sb.append("\u8ba2\u5355B\u7aef/C\u7aef( \u4e0d\u80fd\u4e3a\u7a7a)").append("\u3002");
        } else if (!order.getTypeTobOrToc().equals("B\u7aef") && !order.getTypeTobOrToc().equals("C\u7aef")) {
            sb.append("\u8ba2\u5355B\u7aef/C\u7aef \u53ea\u80fd\u4e3a(B\u7aef \u6216 C\u7aef)").append("\u3002");
        }
        if (null == order.getOrderSonType()) {
            sb.append("\u8ba2\u5355\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a ").append("\u3002");
        }
        if (null == order.getPickupTime()) {
            sb.append("\u63d0\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
        }
        if (null == order.getList() || order.getList().isEmpty()) {
            sb.append("\u5b50\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
        } else {
            for (Product p : order.getList()) {
                Mat mat;
                p.setProductNumOld(MyCopy.copy(p.getProductNum()));
                StringBuffer row = new StringBuffer();
                if (StringUtils.isBlank((CharSequence)p.getCguid())) {
                    row.append("\u5b50\u5355Id\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
                }
                if (StringUtils.isBlank((CharSequence)p.getProductId())) {
                    row.append("\u7269\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
                } else if (MatDo.id(p.getProductId()) == null) {
                    row.append("\u7269\u54c1id\u4e0d\u5b58\u5728").append("\u3002");
                }
                if (null == p.getProductNum()) {
                    row.append("\u7269\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
                }
                if ((mat = MatDo.id(p.getProductId())).getIguarantee() == 1) {
                    p.setIfBatch(1);
                    if (null == p.getFreshnessStart()) {
                        row.append("\u5f00\u59cb\u65b0\u9c9c\u5ea6\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
                    }
                    if (null == p.getFreshnessEnd()) {
                        row.append("\u7ed3\u675f\u65b0\u9c9c\u5ea6\u4e0d\u80fd\u4e3a\u7a7a").append("\u3002");
                    }
                    p.setExpiredDays(mat.getIexpirydays().intValue());
                }
                if (row.toString().isEmpty()) continue;
                sb.append(row.toString());
            }
        }
        if (!sb.toString().isEmpty()) {
            order.setStatus(500);
            order.setErroMessage(sb.toString());
        }
    }
}

