/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.batch;

import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.domain.batch.entity.CanUseQty;
import cc.lechun.erp.domain.batch.entity.batch.MatchBatch;
import cc.lechun.erp.domain.batch.entity.batch.Product;
import cc.lechun.erp.domain.common.domain.CustDo;
import cc.lechun.erp.domain.common.domain.MatDo;
import cc.lechun.erp.domain.common.domain.OperationDataDo;
import cc.lechun.erp.domain.common.domain.PackingDo;
import cc.lechun.erp.domain.common.entity.Packing;
import cc.lechun.erp.util.MyCopy;
import cc.lechun.erp.util.MyDateUtil;
import cc.lechun.erp.util.method.Method;
import cc.lechun.framework.common.utils.date.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MatchTheBatchDoTobOrToc {
    private static Logger log = LoggerFactory.getLogger((String)"MatchTheBatchDomainTobOrTocNewService");

    private Map<String, BigDecimal> getCanUseQty(String storeId, List<String> matIds) {
        List<CanUseQty> list = Method.getBean(ErpOperationDataMapper.class).getCanUseQty(storeId, matIds, null);
        return list.stream().collect(Collectors.toMap(CanUseQty::getOneKey, CanUseQty::getCanUseQty, (k1, k2) -> k1));
    }

    public void matchTobOrTocByOrder(MatchBatch o, boolean toB) {
        if (toB) {
            this.matchTobByOrder(o);
        } else {
            this.matchTocByOrder(o);
        }
    }

    private void matchPacking(MatchBatch order) {
        HashSet<String> mess = new HashSet<String>();
        for (Product v : order.getList()) {
            if (v.getIfBatch() != 1) continue;
            Packing packing = PackingDo.get_(order.getCustId(), v.getProductId());
            if (null == packing) {
                mess.add("\u672a\u627e\u5230\u5305\u6750\u914d\u7f6e \u5ba2\u6236\uff08" + CustDo.id(order.getCustId()).getName() + "\uff09 \u7269\u54c1\uff08" + MatDo.id(v.getProductId()).getName() + "\uff09");
                continue;
            }
            v.setIfMoreBatch(packing.getIfMoreBatch());
            v.setPackingId(packing.getCguid());
            v.setPackingMatNum(packing.getPackingMatNum());
            v.setPackingQuantity(new BigDecimal(v.getProductNum().intValue() / v.getPackingMatNum().intValue() + (v.getProductNum().intValue() % v.getPackingMatNum().intValue() > 0 ? 1 : 0)));
            v.everyPackMatNum();
        }
        if (!mess.isEmpty()) {
            order.setStatus(500);
            order.setErroMessage(JSONObject.toJSONString(mess));
        }
    }

    private void matchTocIsMoreBatch(MatchBatch order) {
        for (Product v : order.getList()) {
            if (v.getIfBatch() != 1) continue;
            v.setIfMoreBatch("\u662f");
        }
    }

    public void matchTobByOrder(MatchBatch o) {
        this.matchPacking(o);
        if (o.getStatus() != 200) {
            return;
        }
        Map<String, BigDecimal> canUseQtyMap = this.getCanUseQty(o.getStoreId(), o.getList().stream().map(Product::getProductId).collect(Collectors.toList()));
        for (Product v : o.getList()) {
            if (v.getIfBatch() == 1) {
                if (v.getIfMoreBatch().equals("\u662f")) {
                    this.matchTobMoreBatch(o, v, canUseQtyMap);
                    continue;
                }
                this.matchTobOneBatch(o, v, canUseQtyMap);
                continue;
            }
            this.matchIsNoBatch(o, v, canUseQtyMap);
        }
    }

    public void matchTocByOrder(MatchBatch o) {
        this.matchTocIsMoreBatch(o);
        Map<String, BigDecimal> canUseQtyMap = this.getCanUseQty(o.getStoreId(), o.getList().stream().map(Product::getProductId).collect(Collectors.toList()));
        for (Product v : o.getList()) {
            if (v.getIfBatch() == 1) {
                this.matchTocMoreBatch(o, v, canUseQtyMap);
                continue;
            }
            this.matchIsNoBatch(o, v, canUseQtyMap);
        }
    }

    public void matchTobMoreBatch(MatchBatch v, Product o, Map<String, BigDecimal> canUseQtyMap) {
        for (Map.Entry<Integer, BigDecimal> map_ : o.getEveryPackMatNum().entrySet()) {
            if (!this.matchMoreBatchByDays(v, o, map_.getValue(), canUseQtyMap)) break;
        }
    }

    public boolean matchMoreBatchByDays(MatchBatch v, Product o, BigDecimal matNum, Map<String, BigDecimal> canUseQtyMap) {
        List<String> dates = MyDateUtil.getFresshDatesStr(v.getPickupTime(), o.getFreshnessStart(), o.getFreshnessEnd());
        for (String day : dates) {
            String key = OperationDataDo.getCanUseKey(v.getStoreId(), o.getProductId(), DateUtils.getDateFromString((String)day, (String)"yyyy-MM-dd"));
            if (matNum.doubleValue() == 0.0) break;
            log.info("============>{}", (Object)JSONObject.toJSONString(canUseQtyMap));
            BigDecimal canUse = canUseQtyMap.get(key) == null ? new BigDecimal(0) : canUseQtyMap.get(key);
            if (canUse.doubleValue() == 0.0) continue;
            if (canUse.subtract(matNum).doubleValue() >= 0.0) {
                canUseQtyMap.put(key, canUse.subtract(matNum));
                o.setProductNum(o.getProductNum().subtract(matNum));
                o.returnMap(key, MyCopy.copy(matNum), DateUtils.getDateFromString((String)day, (String)"yyyy-MM-dd"));
                matNum = new BigDecimal(0);
                continue;
            }
            canUseQtyMap.put(key, new BigDecimal(0));
            o.setProductNum(o.getProductNum().subtract(canUse));
            o.returnMap(key, canUse, DateUtils.getDateFromString((String)day, (String)"yyyy-MM-dd"));
            matNum = matNum.subtract(canUse);
        }
        return !(matNum.doubleValue() > 0.0);
    }

    public void matchIsNoBatch(MatchBatch v, Product o, Map<String, BigDecimal> canUseQtyMap) {
        BigDecimal canUse;
        String key = OperationDataDo.getCanUseKey(v.getStoreId(), o.getProductId(), null);
        BigDecimal bigDecimal = canUse = canUseQtyMap.get(key) == null ? new BigDecimal(0) : canUseQtyMap.get(key);
        if (canUse.doubleValue() == 0.0) {
            return;
        }
        if (canUse.subtract(o.getProductNum()).doubleValue() >= 0.0) {
            canUseQtyMap.put(key, canUse.subtract(o.getProductNum()));
            o.returnMap(key, MyCopy.copy(o.getProductNum()), null);
            o.setProductNum(new BigDecimal(0));
        }
    }

    public void matchTocMoreBatch(MatchBatch o, Product v, Map<String, BigDecimal> canUseQtyMap) {
        this.matchMoreBatchByDays(o, v, v.getProductNum(), canUseQtyMap);
    }

    public void matchTobOneBatch(MatchBatch v, Product o, Map<String, BigDecimal> canUseQtyMap) {
        List<String> dates = MyDateUtil.getFresshDatesStr(v.getPickupTime(), o.getFreshnessStart(), o.getFreshnessEnd());
        for (String day : dates) {
            BigDecimal canUse;
            String key = OperationDataDo.getCanUseKey(v.getStoreId(), o.getProductId(), DateUtils.getDateFromString((String)day, (String)"yyyy-MM-dd"));
            BigDecimal bigDecimal = canUse = canUseQtyMap.get(key) == null ? new BigDecimal(0) : canUseQtyMap.get(key);
            if (canUse.doubleValue() == 0.0) {
                return;
            }
            if (!(canUse.subtract(o.getProductNum()).doubleValue() >= 0.0)) continue;
            canUseQtyMap.put(key, canUse.subtract(o.getProductNum()));
            o.returnMap(key, MyCopy.copy(o.getProductNum()), DateUtils.getDateFromString((String)day, (String)"yyyy-MM-dd"));
            o.setProductNum(new BigDecimal(0));
        }
    }
}

