/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.config.imp;

import cc.lechun.erp.config.entity.Log;
import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.util.method.Method;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class LogMain {
    private Logger log = LoggerFactory.getLogger((String)"LogMain");
    @Autowired
    @Qualifier(value="jmsTemplateQueue")
    private JmsTemplate jmsTemplate;

    public void addLog(String function, String operateContent, String dateCode, String outCode) {
        try {
            HttpServletRequest request = this.getCurrentHttpRequest();
            Log message = null;
            if (null != request) {
                BaseUser user = JedisUtils.getBaseUser((HttpServletRequest)request);
                message = new Log(function, operateContent, dateCode, this.getIpAddr(request), user.getEmployeeName(), outCode);
            } else {
                message = new Log(function, operateContent, dateCode, "127.0.0.1", "SYS-\u7cfb\u7edf");
            }
            Log finalMessage = message;
            this.jmsTemplate.send("ADD_LOG", session -> session.createTextMessage(JSONObject.toJSONString((Object)finalMessage)));
        }
        catch (Exception e) {
            this.log.error("\u5f02\u5e38\uff1a{} ", (Throwable)e);
        }
    }

    public static void addLogs(String function, String operateContent, String dateCode, String outCode) {
        Method.getBean(LogMain.class).addLog(function, operateContent, dateCode, outCode);
    }

    public static void addLogs(String function, String operateContent, String dateCode) {
        Method.getBean(LogMain.class).addLog(function, operateContent, dateCode, null);
    }

    public static void addLogs(String function, String operateContent) {
        Method.getBean(LogMain.class).addLog(function, operateContent, null, null);
    }

    @JmsListener(containerFactory="listenerQueueFactory", destination="ADD_LOG")
    public void getLog(TextMessage message) throws JMSException {
        long idA = System.currentTimeMillis();
        Log log = (Log)JSONObject.parseObject((String)message.getText(), Log.class);
        log.setCguid(IDGenerate.getUniqueIdStr() + idA);
        if (StringUtils.isBlank((CharSequence)log.getOutCode())) {
            log.setOutCode(log.getDateCode());
        }
        log.setOperateTime(new Date());
        try {
            Method.getBean(ErpOperationDataMapper.class).addLog(log);
        }
        catch (Exception e) {
            log.setCguid(IDGenerate.getUniqueIdStr() + idA);
            Method.getBean(ErpOperationDataMapper.class).addLog(log);
        }
    }

    private String getIpAddr(HttpServletRequest request) {
        String ipAddresses;
        if (null == request) {
            return "127.0.0.1";
        }
        String string = ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("X-Forwarded-For")) ? request.getHeader("X-Forwarded-For") : request.getHeader("x-forwarded-for");
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            String string2 = ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("Proxy-Client-IP")) ? request.getHeader("Proxy-Client-IP") : request.getHeader("proxy-Client-ip");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            String string3 = ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("WL-Proxy-Client-IP")) ? request.getHeader("WL-Proxy-Client-IP") : request.getHeader("wl-proxy-client-ip");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            String string4 = ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("HTTP_CLIENT_IP")) ? request.getHeader("HTTP_CLIENT_IP") : request.getHeader("http_client_ip");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            String string5 = ipAddresses = StringUtils.isNotBlank((CharSequence)request.getHeader("X-Real-IP")) ? request.getHeader("X-Real-IP") : request.getHeader("x-real-ip");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getRemoteAddr();
        }
        if (StringUtils.isNotBlank((CharSequence)ipAddresses) && ipAddresses.equals("0:0:0:0:0:0:0:1")) {
            ipAddresses = "127.0.0.1";
        }
        return ipAddresses;
    }

    private HttpServletRequest getCurrentHttpRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return attributes != null ? attributes.getRequest() : null;
    }
}

