/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.archive;

import cc.lechun.erp.dao.common.ErpArchiveIcAccountDetailMapper;
import cc.lechun.erp.util.GetBean;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TheArchiveTable {
    @Autowired
    ErpArchiveIcAccountDetailMapper erpArchiveIcAccountDetailMapper;

    public void theArchiveIcAccountDetail() {
        List<JSONObject> outIds = this.erpArchiveIcAccountDetailMapper.getOutIds();
        for (JSONObject out : outIds) {
            GetBean.getBean(TheArchiveTable.class).theArchiveIcAccountDetail(out);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void theArchiveIcAccountDetail(JSONObject out) {
        JSONObject in = this.erpArchiveIcAccountDetailMapper.getInId(out.getString("cguid"));
        if (in == null) {
            return;
        }
        BigDecimal inNum = in.getBigDecimal("num");
        BigDecimal outNum = out.getBigDecimal("num");
        BigDecimal diffNum = inNum.subtract(outNum);
        JSONObject inId_h = this.erpArchiveIcAccountDetailMapper.getInIdH(in.getString("cguid"));
        JSONObject outId_h = this.erpArchiveIcAccountDetailMapper.getOutIdH(out.getString("cguid"));
        if (diffNum.doubleValue() >= 0.0) {
            if (outId_h != null) {
                this.erpArchiveIcAccountDetailMapper.updateHistoryById(outId_h.getString("cguid"), outNum);
            } else {
                this.erpArchiveIcAccountDetailMapper.addHistoryById(out.getString("cguid"), outNum);
            }
            this.erpArchiveIcAccountDetailMapper.deleteById(out.getString("cguid"));
            if (inId_h != null) {
                this.erpArchiveIcAccountDetailMapper.updateHistoryById(inId_h.getString("cguid"), outNum);
            } else {
                this.erpArchiveIcAccountDetailMapper.addHistoryById(in.getString("cguid"), outNum);
            }
            this.erpArchiveIcAccountDetailMapper.updateById(inId_h.getString("cguid"), diffNum);
        } else {
            if (outId_h != null) {
                this.erpArchiveIcAccountDetailMapper.updateHistoryById(outId_h.getString("cguid"), inNum);
            } else {
                this.erpArchiveIcAccountDetailMapper.addHistoryById(out.getString("cguid"), inNum);
            }
            this.erpArchiveIcAccountDetailMapper.updateById(outId_h.getString("cguid"), new BigDecimal(0).subtract(diffNum));
            if (inId_h != null) {
                this.erpArchiveIcAccountDetailMapper.updateHistoryById(inId_h.getString("cguid"), inNum);
            } else {
                this.erpArchiveIcAccountDetailMapper.addHistoryById(in.getString("cguid"), inNum);
            }
            this.erpArchiveIcAccountDetailMapper.deleteById(in.getString("cguid"));
        }
    }
}

