/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common.domain;

import cc.lechun.erp.dao.common.ErpSpuMatMapper;
import cc.lechun.erp.domain.common.entity.SpuMat;
import cc.lechun.erp.util.method.Method;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpuMatDo
implements Serializable {
    private static Map<String, List<SpuMat>> idList = new HashMap<String, List<SpuMat>>();
    private static Map<String, List<SpuMat>> codeList = new HashMap<String, List<SpuMat>>();
    private static Map<String, List<SpuMat>> nameList = new HashMap<String, List<SpuMat>>();

    public static List<SpuMat> id(String id) {
        return Method.getObj(id, idList, () -> SpuMatDo.sumPercent(Method.getBean(ErpSpuMatMapper.class).getObj(id, null, null)));
    }

    public static List<SpuMat> code(String code) {
        return Method.getObj(code, codeList, () -> SpuMatDo.sumPercent(Method.getBean(ErpSpuMatMapper.class).getObj(null, code, null)));
    }

    public static List<SpuMat> name(String name) {
        return Method.getObj(name, nameList, () -> SpuMatDo.sumPercent(Method.getBean(ErpSpuMatMapper.class).getObj(null, null, name)));
    }

    private static List<SpuMat> sumPercent(List<SpuMat> list) {
        if (list != null && !list.isEmpty()) {
            list.forEach(v -> {
                if (null != v.getIsGift() && v.getIsGift() == 0) {
                    v.setIamt(new BigDecimal(0));
                } else {
                    v.setIamt(v.getPrice().multiply(v.getQuantity()));
                }
            });
            BigDecimal totalIamt = list.stream().map(SpuMat::getIamt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalPercent = new BigDecimal(1);
            for (int i = 0; i < list.size(); ++i) {
                SpuMat d = list.get(i);
                if (null != d.getIsGift() && d.getIsGift() == 0) {
                    d.setPercent(new BigDecimal(0));
                    continue;
                }
                if (i < list.size() - 1) {
                    d.setPercent(d.getIamt().divide(totalIamt, 3, 4));
                    totalPercent = totalPercent.subtract(d.getPercent());
                    continue;
                }
                if (i != list.size() - 1) continue;
                d.setPercent(totalPercent);
                totalPercent = totalPercent.subtract(d.getPercent());
            }
        }
        return list;
    }

    public static void clear() {
        idList = new HashMap<String, List<SpuMat>>();
        codeList = new HashMap<String, List<SpuMat>>();
        nameList = new HashMap<String, List<SpuMat>>();
    }
}

