/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util.otherHttp;

import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.otherHttp.entity.U8HttpParam;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class U8Http {
    private static Logger log = LoggerFactory.getLogger(U8Http.class);
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Value(value="${u8.getBaseUrl:1}")
    private String getBaseUrl;
    @Value(value="${u8.from_account:1}")
    private String from_account;
    @Value(value="${u8.to_account:1}")
    private String to_account;
    @Value(value="${u8.app_key:1}")
    private String app_key;
    @Value(value="${u8.app_secret:1}")
    private String app_secret;
    public String redisTokenKey = "redisTokenKeyU8";
    private String tokenUrl = "system/token";

    public static String operationU8Datas(U8HttpParam u8HttpParam) {
        return GetBean.getBean(U8Http.class).operation(u8HttpParam);
    }

    public String operation(@RequestBody U8HttpParam u8HttpParam) {
        long a = System.currentTimeMillis();
        log.info("\u53d1\u9001U8 \u5f00\u59cb ========================================================================================================================  \u300b\u300b \n");
        String returnStr = this.operationU8DatasBuild(u8HttpParam);
        if (!this.checkTokenIfBoolean(returnStr)) {
            this.getToken();
        }
        long b = System.currentTimeMillis();
        log.info("\u53d1\u9001U8 \u7ed3\u675f ======================================================================================================================== \u300b\u300b \u8017\u65f6" + (double)(b - a) / 1000.0 + " \n");
        return returnStr;
    }

    public static JSONObject operationU8JsonDatas(U8HttpParam u8HttpParam) {
        return GetBean.getBean(U8Http.class).operationU8Json(u8HttpParam);
    }

    public JSONObject operationU8Json(@RequestBody U8HttpParam u8HttpParam) {
        long a = System.currentTimeMillis();
        log.info("\u53d1\u9001U8 \u5f00\u59cb ========================================================================================================================  \u300b\u300b \n");
        String returnStr = this.operationU8DatasBuild(u8HttpParam);
        if (!this.checkTokenIfBoolean(returnStr)) {
            this.getToken();
        }
        long b = System.currentTimeMillis();
        log.info("\u53d1\u9001U8 \u7ed3\u675f ======================================================================================================================== \u300b\u300b \u8017\u65f6" + (double)(b - a) / 1000.0 + " \n");
        return (JSONObject)JSONObject.parseObject((String)returnStr, JSONObject.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String operationU8DatasBuild(U8HttpParam u8HttpParam) {
        StringBuffer sb = new StringBuffer();
        if (u8HttpParam != null) {
            if (!StringUtils.isNotBlank((CharSequence)u8HttpParam.getHttpType())) return "{\"errcode\":500,\"errmsg\":\"" + sb.toString() + "\"}";
            if (u8HttpParam.getHttpType().equals(U8HttpParam.GET_HTRTP)) {
                if (null == u8HttpParam.getParamsBody() || u8HttpParam.getParamsBody().size() <= 0) return this.getRequstDataByGET(u8HttpParam.getUrlMethod(), u8HttpParam.getParamsUrl());
                sb.append(" GET \u8bf7\u6c42\u8bf7 \u7ed9 paramsUrl \u8d4b\u503c ,\u53c2\u8003U8 \u6587\u6863\u63a5\u53e3");
                return "{\"errcode\":500,\"errmsg\":\"" + sb.toString() + "\"}";
            } else {
                if (!u8HttpParam.getHttpType().equals(U8HttpParam.POST_HTRTP)) return "{\"errcode\":500,\"errmsg\":\"" + sb.toString() + "\"}";
                if (null != u8HttpParam.getParamsBody() || u8HttpParam.getParamsBody().size() != 0) return this.operationU8DataByPost(u8HttpParam.getUrlMethod(), u8HttpParam.getParamsUrl(), u8HttpParam.getParamsBody());
                sb.append(" POST \u8bf7\u6c42\u8bf7 \u7ed9 paramsBody \u8d4b\u503c,\u53c2\u8003U8 \u6587\u6863\u63a5\u53e3");
            }
            return "{\"errcode\":500,\"errmsg\":\"" + sb.toString() + "\"}";
        } else {
            sb.append(" \u8bf7\u6c42\u53c2\u6570 \u4e3a\u7a7a");
        }
        return "{\"errcode\":500,\"errmsg\":\"" + sb.toString() + "\"}";
    }

    public String getTokenFromRedis() {
        return this.redisCacheUtil.get(this.redisTokenKey).toString();
    }

    private String getGetAllUrl(String url) {
        return this.getBaseUrl + url + "?from_account=" + this.from_account + "&to_account=" + this.to_account + "&app_key=" + this.app_key + "&token=" + this.getTokenByRedis() + "&";
    }

    private String paramToUrl(Map<String, String> paramsUrl) {
        StringBuffer paramStr = new StringBuffer();
        if (paramsUrl != null && paramsUrl.size() > 0) {
            for (Map.Entry<String, String> param : paramsUrl.entrySet()) {
                try {
                    paramStr.append(param.getKey() + "=" + URLEncoder.encode(param.getValue(), "UTF-8") + "&");
                }
                catch (Exception e) {}
            }
        }
        return paramStr.toString();
    }

    private String getRequstDataByGET(String urlMethod, Map<String, String> paramsUrl) {
        StringBuffer paramStr = new StringBuffer();
        if (paramsUrl != null && paramsUrl.size() > 0) {
            for (Map.Entry<String, String> param : paramsUrl.entrySet()) {
                try {
                    paramStr.append(param.getKey() + "=" + URLEncoder.encode(param.getValue(), "UTF-8") + "&");
                }
                catch (Exception e) {}
            }
        }
        String url = this.getGetAllUrl(urlMethod) + this.paramToUrl(paramsUrl);
        log.info("GET\u8bf7\u6c42\u5730\u5740 : " + url);
        String result = this.getRequstData(url, null, "GET");
        if (url.contains("add") || url.contains("audit") || url.contains("verify") || url.contains("unverify") || url.contains("abandon")) {
            log.info("GET\u8fd4\u56de\u6570\u636e : " + result);
        }
        return result;
    }

    private String operationU8DataByPost(String urlMethod, Map<String, String> paramsUrl, JSONObject paramsBody) {
        String url = this.getGetAllUrl(urlMethod) + this.paramToUrl(paramsUrl);
        String body = JSONObject.toJSONString((Object)paramsBody);
        log.info("POST\u8bf7\u6c42\u5730\u5740 : " + url);
        log.info("POST\u8bf7\u6c42\u53c2\u6570 : " + body);
        String result = this.getRequstData(url, body, "POST");
        if (url.contains("add") || url.contains("audit") || url.contains("verify") || url.contains("unverify") || url.contains("abandon")) {
            log.info("\u8fd4\u56de\u6570\u636e : " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequstData(String urlNew, String params, String getType) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlNew);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod(getType);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.connect();
            if (getType.equals("POST") && StringUtils.isNotBlank((CharSequence)params)) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
                writer.write(params);
                writer.close();
            }
            int responseCode = connection.getResponseCode();
            StringBuilder builder = new StringBuilder();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                builder.setLength(0);
                String line = "";
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                String string = builder.toString();
                return string;
            }
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 responseCode \u5f02\u5e38\u4fe1\u606f:<{}> ", (Object)responseCode);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 url <{}> \u53c2\u6570 <{}> \u5f02\u5e38\u4fe1\u606f:<{}> ", new Object[]{urlNew, params, e});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private String getTokenByRedis() {
        Object keyvalue = this.redisCacheUtil.get(this.redisTokenKey);
        if (keyvalue != null) {
            return keyvalue.toString();
        }
        return "false";
    }

    private boolean checkTokenIfBoolean(String returnJson) {
        JSONObject param;
        return !StringUtils.isNotBlank((CharSequence)returnJson) || !(null != (param = (JSONObject)JSONObject.parseObject((String)returnJson, JSONObject.class)).get((Object)"errcode") && param.get((Object)"errcode").toString().equals("30011") || null != param.get((Object)"errcode") && param.get((Object)"errcode").toString().equals("30012") || null != param.get((Object)"errmsg") && param.get((Object)"errmsg").equals("\u53c2\u6570token\u5df2\u8fc7\u671f")) && (null == param.get((Object)"errmsg") || !param.get((Object)"errmsg").equals("\u53c2\u6570token\u4e0d\u5408\u6cd5"));
    }

    private boolean getToken() {
        String url = this.getBaseUrl + this.tokenUrl + "?from_account=" + this.from_account + "&app_key=" + this.app_key + "&app_secret=" + this.app_secret;
        String json = this.getRequstData(url, null, "GET");
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject u8TokenMain = (JSONObject)JSONObject.parseObject((String)json, JSONObject.class);
            if (u8TokenMain != null) {
                if (u8TokenMain.getString("errcode").equals("0")) {
                    if (u8TokenMain.getJSONObject("token") != null && StringUtils.isNotBlank((CharSequence)u8TokenMain.getJSONObject("token").getString("id"))) {
                        this.redisCacheUtil.set(this.redisTokenKey, (Object)u8TokenMain.getJSONObject("token").getString("id"));
                        log.info("\u5b9a\u65f6\u4efb\u52a1 token \u8bf7\u6c42\u6210\u529f redis(key= " + this.redisTokenKey + " | valule=" + u8TokenMain.getJSONObject("token").getString("id") + ") ====>> " + json);
                        flag = true;
                    } else {
                        log.error("token \u672a\u83b7\u53d6\u5230 \u8fd4\u56de\u6570\u636e ====>> " + json);
                    }
                } else {
                    log.error("token \u672a\u83b7\u53d6\u5230 \u8fd4\u56de\u6570\u636e ====>> " + json);
                }
            } else {
                log.error("token \u672a\u83b7\u53d6\u5230 \u8fd4\u56de\u6570\u636e ====>> " + json);
            }
        } else {
            log.error("token \u672a\u83b7\u53d6\u5230 \u8fd4\u56de\u6570\u636e ====>> " + json);
        }
        return flag;
    }
}

