/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common.domain;

import cc.lechun.erp.dao.common.GetCodeMapper;
import cc.lechun.erp.util.GetBean;
import com.alibaba.fastjson.JSONObject;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GetCode {
    public static String code(String cbilltype) {
        return GetBean.getBean(GetCode.class).buildCode(cbilltype);
    }

    @Transactional(rollbackFor={Exception.class})
    public String buildCode(String cbilltype) {
        if (StringUtils.isBlank((String)cbilltype)) {
            return String.valueOf(new Date().getTime());
        }
        JSONObject codeFind = GetBean.getBean(GetCodeMapper.class).code(cbilltype);
        if (null == codeFind) {
            return String.valueOf(new Date().getTime());
        }
        String regulation = codeFind.getString("cregulation");
        Integer currentValue = codeFind.getInteger("icurrvalue");
        if (currentValue == null) {
            currentValue = 0;
        }
        JSONObject codeUpdate = new JSONObject();
        if (codeFind.getIntValue("ieveryday") == 1) {
            String oldDate;
            String today = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            if (!today.equals(oldDate = codeFind.getString("ccurrdate"))) {
                codeUpdate.put("ccurrdate", (Object)today);
                currentValue = codeFind.getInteger("iinitvalue");
            } else {
                currentValue = currentValue + 1;
            }
        } else {
            currentValue = currentValue + 1;
        }
        String tm = currentValue + "";
        if (tm.length() > codeFind.getIntValue("ilength")) {
            currentValue = 1;
        }
        codeUpdate.put("icurrvalue", (Object)currentValue);
        codeUpdate.put("cguid", (Object)codeFind.getString("cguid"));
        GetBean.getBean(GetCodeMapper.class).update(codeUpdate);
        return this.getByRule(regulation, codeFind.getIntValue("ilength"), currentValue);
    }

    private String getByRule(String rule, int length, int curValue) {
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        Integer month = calendar.get(2) + 1;
        Integer day = calendar.get(5);
        String shortMonth = "" + month;
        String longMonth = month < 10 ? "0" + month : "" + month;
        String seqNo = this.getSeqNo(rule, curValue, length);
        String shortDay = "" + day;
        String longDay = day < 10 ? "0" + day : "" + day;
        String rtn = rule.replace("{yyyy}", year).replace("{MM}", longMonth).replace("{mm}", shortMonth).replace("{DD}", longDay).replace("{dd}", shortDay).replace("{NO}", seqNo).replace("{no}", seqNo);
        return rtn;
    }

    private String getSeqNo(String rule, int curValue, int length) {
        String tmp = curValue + "";
        int len = 0;
        if (tmp.length() <= length) {
            len = length - tmp.length();
        }
        String rtn = "";
        for (int i = 0; i < len; ++i) {
            rtn = rtn + "0";
        }
        if (rule.contains("NO")) {
            return tmp + rtn;
        }
        return rtn + tmp;
    }
}

