/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.aop;

import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.domain.common.domain.DateTimeToDateDo;
import cc.lechun.erp.domain.common.domain.DaysToHoursDo;
import cc.lechun.erp.domain.common.pudingding.PuDingDing;
import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.RefectUtil;
import cc.lechun.erp.util.redisLock.ErpRedisReturnLock;
import cc.lechun.erp.util.redisLock.classnew.MyMethod;
import com.alibaba.fastjson.JSONObject;
import com.qimen.api.request.DeliveryorderCreateRequest;
import com.qimen.api.request.EntryorderCreateRequest;
import com.qimen.api.request.SingleitemSynchronizeRequest;
import com.qimen.api.request.StockoutCreateRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LockOmsAop {
    private static final Logger log = LoggerFactory.getLogger((String)"RedisLock");

    @Around(value="execution(* cc.lechun.*.service.order.third.jingdong.impl.JdServiceImpl.insert(..)) && args(mapparam, shopId, coupon)")
    public Object jingDongZiYingLock(ProceedingJoinPoint joinPoint, Map<String, Object> mapparam, String shopId, Object coupon) throws Exception {
        String key = LockOmsAop.builKey(null, RefectUtil.getValueFromBody(mapparam.get("jdOrdersVO"), "orderId").toString());
        return this.runMethod(joinPoint, key.toString());
    }

    @Around(value="execution(* cc.lechun.*.service.order.third.doudian.impl.DouDianServiceImpl.insert(..)) && args(douDianOrderRespCVo, shopByOuterCode, isModifyAddress, type, tag)")
    public Object douDianLock(ProceedingJoinPoint joinPoint, Object douDianOrderRespCVo, Object shopByOuterCode, Object isModifyAddress, Object type, Object tag) throws Exception {
        String key = LockOmsAop.builKey(null, RefectUtil.getValueFromBody(douDianOrderRespCVo, "orderId").toString());
        return this.runMethod(joinPoint, key.toString());
    }

    @Around(value="execution(* cc.lechun.*.service.order.transfer.impl.OriginOrderToProcessOrderTransferImpl.originToProcessTransfer(..)) && args( find,type,picupdateFromHtml)")
    public Object dingDanLiuZhuanLock(ProceedingJoinPoint joinPoint, Object find, Integer type, Date picupdateFromHtml) throws Exception {
        String key = LockOmsAop.builKey(null, RefectUtil.getValueFromBody(find, "externalOrderNo").toString());
        return this.runMethod(joinPoint, key.toString());
    }

    @Around(value="execution(* cc.lechun.*.jms.jst.JiShuiTanApiServiceDomain.getOrder(..)) && args( json)")
    public Object juShuiTanLock(ProceedingJoinPoint joinPoint, JSONObject json) throws Exception {
        String key = json.getString("io_id");
        return this.runMethod(joinPoint, key);
    }

    @Around(value="execution(* cc.lechun.*.domain.dingtalk.DingtalkDoMain.sendDingTalkFlow(..)) && args(  map,  ids, dbStore)")
    public Object dingDingCaiGouShenQing(ProceedingJoinPoint joinPoint, Map<String, Object> map, List<String> ids, String dbStore) {
        try {
            return GetBean.getBean(PuDingDing.class).sendDingTalkFlow(map, ids, dbStore);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Around(value="execution(* cc.lechun.*.wms.service.send.wms.impl.QimenSendWmsServiceImpl.entryorderrCreate(..)) && args( request,  req)")
    public Object instore(ProceedingJoinPoint joinPoint, HttpServletRequest request, EntryorderCreateRequest req) {
        try {
            if (StringUtils.isNotBlank((CharSequence)req.getCustomerId()) && (req.getCustomerId().equals("BJ4418054919926") || req.getCustomerId().equals("BJ4418055110028") || req.getCustomerId().equals("BJ4418057150859"))) {
                req.getEntryOrder().setSupplierCode("20220825");
                req.getEntryOrder().setOrderType("CGRK");
            }
            return joinPoint.proceed();
        }
        catch (Exception e) {
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    @Around(value="execution(* cc.lechun.*.wms.service.send.wms.impl.QimenSendWmsServiceImpl.stockoutCreate(..)) && args(   request,  req)")
    public Object outstore(ProceedingJoinPoint joinPoint, HttpServletRequest request, StockoutCreateRequest req) {
        try {
            if ((StringUtils.isNotBlank((CharSequence)req.getCustomerId()) && (req.getCustomerId().equals("BJ4418054919926") || req.getCustomerId().equals("BJ4418055110028")) || req.getCustomerId().equals("BJ4418057150859")) && !req.getDeliveryOrder().getOrderType().equals("CGTH")) {
                req.getDeliveryOrder().setOrderType("B2BCK");
            }
            return joinPoint.proceed();
        }
        catch (Exception e) {
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    @Around(value="execution(* cc.lechun.*.wms.service.send.wms.impl.QimenSendWmsServiceImpl.singleitemSynchronize(..)) && args(   request,  req)")
    public Object singleitemSynchronizeA(ProceedingJoinPoint joinPoint, HttpServletRequest request, SingleitemSynchronizeRequest req) {
        try {
            boolean dateTimeToDate = DaysToHoursDo.daysToHours(req.getCustomerId());
            if (StringUtils.isNotBlank((CharSequence)req.getCustomerId()) && dateTimeToDate && null != req.getItem() && null != req.getItem().getShelfLife()) {
                req.getItem().setShelfLife(Long.valueOf(req.getItem().getShelfLife() * 24L));
            }
            return joinPoint.proceed();
        }
        catch (Exception e) {
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    @Around(value="execution(* cc.lechun.*.wms.service.send.wms.impl.QimenSendWmsServiceImpl.deliveryorderCreate(..)) && args(   request,  req)")
    public Object deliveryorderCreateA(ProceedingJoinPoint joinPoint, HttpServletRequest request, DeliveryorderCreateRequest req) {
        try {
            boolean dateTimeToDate = DateTimeToDateDo.dateTimeToDate(req.getCustomerId());
            if (StringUtils.isNotBlank((CharSequence)req.getCustomerId()) && dateTimeToDate && null != req.getOrderLines()) {
                for (DeliveryorderCreateRequest.OrderLine orderLine : req.getOrderLines()) {
                    if (StringUtils.isNotBlank((CharSequence)orderLine.getProductDate())) {
                        orderLine.setProductDate(orderLine.getProductDate().replace(" 00:00:00", ""));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)orderLine.getExpireDate())) continue;
                    orderLine.setExpireDate(orderLine.getExpireDate().replace(" 00:00:00", ""));
                }
            }
            return joinPoint.proceed();
        }
        catch (Exception e) {
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    @Around(value="execution(* cc.lechun.*.domain.forecast.SaleForecastDomainService.getOrderDataForProduce(..)) && args(  orderId)")
    public Object getOrderDataForProduceA(ProceedingJoinPoint joinPoint, String orderId) {
        try {
            GetBean.getBean(ErpOperationDataMapper.class).deletePredict(orderId);
            GetBean.getBean(ErpOperationDataMapper.class).addPredict(orderId);
            return joinPoint.proceed();
        }
        catch (Exception e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Around(value="execution(* cc.lechun.*.domain.forecast.SaleForecastDomainService.deleteForecast(..)) && args(  cguid)")
    public Object deleteForecastA(ProceedingJoinPoint joinPoint, String cguid) {
        try {
            GetBean.getBean(ErpOperationDataMapper.class).deletePredict(cguid);
            return joinPoint.proceed();
        }
        catch (Exception e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String builKey(String orderNo, String externalOrderNo) {
        return StringUtils.isNotBlank((CharSequence)externalOrderNo) ? externalOrderNo : orderNo;
    }

    public Object runMethod(final ProceedingJoinPoint joinPoint, String key) {
        return GetBean.getBean(ErpRedisReturnLock.class).myLock(key, new MyMethod<Object>(){

            @Override
            public Object runMethod() throws Exception {
                try {
                    return joinPoint.proceed();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

