/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.batch.entity;

import cc.lechun.erp.domain.batch.entity.CanUseFiled;
import cc.lechun.erp.util.MyDateUtil;
import cc.lechun.erp.util.method.AtoB;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Batch
implements Serializable {
    private Integer status = 200;
    private String erroMessage;
    private String orderNo;
    private String storeId;
    private Date pickupTime;
    List<Product> products;

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public Date getPickupTime() {
        return this.pickupTime;
    }

    public void setPickupTime(Date pickupTime) {
        this.pickupTime = pickupTime;
    }

    public <T> Batch(String orderNo, String storeId, Date pickupTime, List<T> products, AtoB<T> atob) {
        this.orderNo = orderNo;
        this.storeId = storeId;
        this.pickupTime = pickupTime;
        ArrayList<Product> list = new ArrayList<Product>();
        for (T t : products) {
            list.add((Product)atob.aToB(t));
        }
        this.products = list;
    }

    public class Product {
        private String productId;
        private BigDecimal productNum;
        private List<Integer> batchs;
        private List<CanUseFiled> canUses;

        public Product(String productId, BigDecimal productNum) {
            this.productId = productId;
            this.productNum = productNum;
        }

        public Product(String productId, BigDecimal productNum, Date picupdate, int start, int end) {
            this.productId = productId;
            this.productNum = productNum;
            this.batchs = MyDateUtil.getFresshDates(picupdate, start, end);
        }

        public String getProductId() {
            return this.productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public BigDecimal getProductNum() {
            return this.productNum;
        }

        public void setProductNum(BigDecimal productNum) {
            this.productNum = productNum;
        }

        public List<Integer> getBatchs() {
            return this.batchs;
        }

        public void setBatchs(List<Integer> batchs) {
            this.batchs = batchs;
        }

        public List<CanUseFiled> getCanUses() {
            return this.canUses;
        }

        public void setCanUses(List<CanUseFiled> canUses) {
            this.canUses = canUses;
        }
    }
}

