/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common.domain;

import cc.lechun.erp.dao.common.ErpSuitMatMapper;
import cc.lechun.erp.domain.common.entity.SuitMat;
import cc.lechun.erp.util.method.Method;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuitMatDo
implements Serializable {
    private static Logger log = LoggerFactory.getLogger((String)"SuitMatDo");
    private static Map<String, List<SuitMat>> suiIdList = new HashMap<String, List<SuitMat>>();
    private static Map<String, List<SuitMat>> suiCodeList = new HashMap<String, List<SuitMat>>();
    private static Map<String, List<SuitMat>> suiOutCodeList = new HashMap<String, List<SuitMat>>();
    private static Map<String, List<SuitMat>> suiNameList = new HashMap<String, List<SuitMat>>();

    public static List<SuitMat> suitId(String suiId) {
        return Method.getObj(suiId, suiIdList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(suiId, null, null, null, null)));
    }

    public static List<SuitMat> suitId(String suiId, String shopId) {
        return Method.getObj(Method.getKey(shopId, suiId), suiIdList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(suiId, null, null, null, shopId)));
    }

    public static List<SuitMat> suitCode(String suitCode) {
        return Method.getObj(suitCode, suiCodeList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(null, suitCode, null, null, null)));
    }

    public static List<SuitMat> suitCode(String suitCode, String shopId) {
        return Method.getObj(Method.getKey(shopId, suitCode), suiCodeList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(null, suitCode, null, null, shopId)));
    }

    public static List<SuitMat> suitName(String suitName) {
        return Method.getObj(suitName, suiNameList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(null, null, suitName, null, null)));
    }

    public static List<SuitMat> suitName(String suitName, String shopId) {
        return Method.getObj(Method.getKey(shopId, suitName), suiNameList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(null, null, suitName, null, shopId)));
    }

    public static List<SuitMat> suitOutCode(String suitOutCode) {
        return Method.getObj(suitOutCode, suiOutCodeList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(null, null, null, suitOutCode, null)));
    }

    public static List<SuitMat> suitOutCode(String suitOutCode, String shopId) {
        return Method.getObj(Method.getKey(shopId, suitOutCode), suiOutCodeList, () -> SuitMatDo.sumPercent(Method.getBean(ErpSuitMatMapper.class).getObj(null, null, null, suitOutCode, shopId)));
    }

    private static List<SuitMat> sumPercent(List<SuitMat> list) {
        if (list != null && !list.isEmpty()) {
            list.forEach(v -> v.setIamt(v.getPrice().multiply(v.getQuantity())));
            BigDecimal totalIamt = list.stream().map(SuitMat::getIamt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalPercent = new BigDecimal(1);
            log.info(" obj --> {}", (Object)JSONObject.toJSONString(list));
            for (int i = 0; i < list.size(); ++i) {
                SuitMat d = list.get(i);
                if (i < list.size() - 1) {
                    d.setPercent(d.getIamt().divide(totalIamt, 3, 4));
                    log.info("d.getIamt() :{}   /   totalIamt : {}  / d.setPercent :{}", new Object[]{d.getIamt(), totalIamt, d.getPercent()});
                    totalPercent = totalPercent.subtract(d.getPercent());
                    continue;
                }
                if (i != list.size() - 1) continue;
                d.setPercent(totalPercent);
            }
        }
        return list;
    }

    public static void clear() {
        suiIdList.clear();
        suiCodeList.clear();
        suiOutCodeList.clear();
        suiNameList.clear();
    }
}

