/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util.redisLock;

import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.Redis;
import cc.lechun.erp.util.redisLock.classnew.MyMethod;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ErpRedisReturnLock {
    private static final Logger log = LoggerFactory.getLogger((String)"RedisReturnDatasLock");

    public static <T> T myLock(String key, MyMethod<T> method) {
        return ErpRedisReturnLock.lock(key, 30L, 1L, method, true).getValue();
    }

    public static <T> BaseJsonVo<T> lock(String key, MyMethod<T> method) {
        return ErpRedisReturnLock.lock(key, 30L, 1L, method, true);
    }

    public static <T> BaseJsonVo<T> lockNoTry(String key, MyMethod<T> method) {
        return ErpRedisReturnLock.lock(key, 30L, 1L, method, false);
    }

    public static <T> BaseJsonVo<T> lock(String key, Long timeout, Long timewait, MyMethod<T> method, boolean ifTry) {
        BaseJsonVo<T> t = null;
        long startTime = System.currentTimeMillis();
        String keyLock = ErpRedisReturnLock.getKeyLock(key);
        t = GetBean.getBean(ErpRedisReturnLock.class).tryLock(keyLock, timeout, timewait, method, ifTry ? Integer.valueOf("" + timeout / timewait) : 1);
        log.info("\u3010redis\u5206\u5e03\u5f0f\u9501 \uff0c\u6267\u884c\u5b8c\u6bd5\u3011" + keyLock + " \u8017\u65f6 " + (System.currentTimeMillis() - startTime) + " \u6beb\u79d2");
        return t;
    }

    public <T> BaseJsonVo<T> tryLock(String key, Long timeout, Long timewait, MyMethod<T> method, Integer ciShu) {
        long startTime = System.currentTimeMillis();
        Object t = null;
        for (int i = 0; i < ciShu; ++i) {
            boolean lock = this.iflock(key, timeout);
            if (lock) {
                long startTime_ = System.currentTimeMillis();
                try {
                    t = method.runMethod();
                    ErpRedisReturnLock.unlock(key);
                    return new BaseJsonVo<Object>(200, "\u6267\u884c\u6210\u529f", t);
                }
                catch (Throwable e) {
                    ErpRedisReturnLock.unlock(key);
                    log.error("{}\u5f02\u5e38:{}", (Object)key, (Object)e);
                    return new BaseJsonVo<Object>(500, key + "\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u5f02\u5e38", t);
                }
            }
            if (ciShu - 1 == i) continue;
            this.sleep(timewait);
        }
        log.info("{}\u91cd\u8bd5\u8d85\u8fc7:{}\u6b21 ", (Object)key, (Object)ciShu);
        return new BaseJsonVo<Object>(500, key + "\u91cd\u8bd5\u8d85\u8fc7:" + ciShu + "\u6b21", t);
    }

    private void sleep(Long timewait) {
        try {
            TimeUnit.MILLISECONDS.sleep(timewait);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void unlock(String key) {
        Redis.redis().opsForValue().getOperations().delete((Object)key);
    }

    protected static String getKeyLock(String key) {
        return "TASK_LOCK|" + key;
    }

    private boolean iflock(String key, Long timeout) {
        return Redis.redis().opsForValue().setIfAbsent((Object)key, (Object)0, timeout.longValue(), TimeUnit.SECONDS);
    }
}

