/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.core.baseclass;

import cc.lechun.framework.common.vo.JedisUtils;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DbSql
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(DbSql.class);
    private static boolean debug = false;

    @Value(value="${cc.lechun.framework.core.DbSql.debug:false}")
    public void setDebug(boolean debug) {
        DbSql.debug = debug;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            Connection conn = (Connection)invocation.getArgs()[0];
            StatementHandler handler = (StatementHandler)invocation.getTarget();
            Statement stmt = handler.prepare(conn, Integer.valueOf(300));
            handler.parameterize(stmt);
            RealSqlStrategyUtil.getSql(stmt, invocation);
        }
        return invocation.proceed();
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }

    class RealSqlStrategyUtil {
        private static Logger log = LoggerFactory.getLogger(DbSql.class);
        static Map<String, Function<DruidPooledStatement, String>> map = new HashMap<String, Function<DruidPooledStatement, String>>();

        RealSqlStrategyUtil() {
        }

        public static void getSql(Statement stmt, Invocation invocation) throws SQLException {
            if (stmt instanceof DruidPooledStatement) {
                if (stmt == null || stmt.getConnection() == null) {
                    log.error("PreparedStatement is null ! ps = {}", (Object)stmt);
                    return;
                }
                if (debug) {
                    DruidPooledStatement ps = (DruidPooledStatement)stmt;
                    MetaObject metaObject = SystemMetaObject.forObject((Object)invocation.getTarget());
                    Object objMapped = metaObject.getValue("delegate.mappedStatement");
                    MappedStatement mapper = null;
                    if (null != objMapped) {
                        mapper = (MappedStatement)objMapped;
                    }
                    String dbType = ps.getConnection().getMetaData().getDatabaseProductName().toUpperCase();
                    String dataSourceName = ((DruidPooledConnection)ps.getConnection()).getConnectionHolder().getDataSource().getName();
                    String url = ((DruidPooledConnection)ps.getConnection()).getConnectionHolder().getDataSource().getUrl();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"\u7c7b\u578b", (Object)dataSourceName);
                    jsonObject.put((Object)"\u64cd\u4f5c\u4eba", (Object)JedisUtils.getBaseUser().getEmployeeName());
                    jsonObject.put((Object)"SQL", (Object)RealSqlStrategyUtil.getRealSqlByPreparedStatement(dbType, ps));
                    jsonObject.put((Object)"URL", (Object)url);
                    jsonObject.put((Object)"mapper", (Object)mapper.getId());
                    logger.info("{}", (Object)JSONObject.toJSONString((Object)jsonObject, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
                }
            }
        }

        public static String getRealSqlByPreparedStatement(String dbType, DruidPooledStatement ps) {
            Function<DruidPooledStatement, String> statementStringFunction = map.get(dbType);
            if (statementStringFunction == null) {
                throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301 " + String.valueOf(map.keySet()) + " \u6570\u636e\u6e90\uff01");
            }
            return statementStringFunction.apply(ps).replaceAll("\\s+", " ");
        }

        static {
            map.put("MYSQL", ps -> {
                String temp = ps.toString();
                return temp.substring(temp.indexOf(58) + 1);
            });
        }
    }
}

