/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.core.quartz;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.quartz.QuartzResultVo;
import com.alibaba.fastjson2.JSON;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    private static final Logger quartzJob = LoggerFactory.getLogger((String)"quartzJob");

    public final void execute(JobExecutionContext context) throws JobExecutionException {
        new Thread(() -> {
            String logId = this.beforeExecute(context);
            Object result = "";
            Date start_time = DateUtils.now();
            try {
                result = this.doExecute(context);
            }
            catch (Exception e) {
                result = "quartz \u5b9a\u65f6\u4efb\u52a1\u7c7b\u6267\u884c\u51fa\u9519";
                log.error("quartz \u5b9a\u65f6\u4efb\u52a1\u7c7b\u6267\u884c\u51fa\u9519", (Throwable)e);
            }
            this.afterExecute(context, result, start_time);
        }).start();
    }

    protected String beforeExecute(JobExecutionContext context) {
        return "";
    }

    protected void afterExecute(JobExecutionContext context, Object message, Date start_time) {
        QuartzResultVo vo = new QuartzResultVo();
        vo.setJob_name(context.getJobDetail().getKey().getName());
        vo.setDescription(context.getJobDetail().getDescription());
        vo.setBegin_time(start_time);
        vo.setEnd_time(DateUtils.now());
        vo.setMessage(JSON.toJSONString((Object)message));
        quartzJob.info(JSON.toJSONString((Object)vo));
    }

    protected abstract Object doExecute(JobExecutionContext var1) throws Exception;
}

