/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.common.domain;

import cc.lechun.erp.config.imp.CacheMainDel;
import cc.lechun.erp.dao.common.ErpOperationDataMapper;
import cc.lechun.erp.domain.batch.MatchTheBatchDo;
import cc.lechun.erp.domain.batch.entity.CanUseFiled;
import cc.lechun.erp.domain.batch.entity.CanUseQty;
import cc.lechun.erp.domain.batch.entity.batch.MatchBatch;
import cc.lechun.erp.domain.common.domain.MatDo;
import cc.lechun.erp.domain.common.domain.StoreDo;
import cc.lechun.erp.domain.common.entity.Mat;
import cc.lechun.erp.domain.common.entity.Order;
import cc.lechun.erp.domain.common.entity.Shop;
import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.MyDateUtil;
import cc.lechun.erp.util.method.AtoB;
import cc.lechun.erp.util.method.Error_;
import cc.lechun.erp.util.method.Method;
import cc.lechun.erp.util.method.No_;
import cc.lechun.erp.util.method.Ok_;
import cc.lechun.erp.util.method.Success_;
import cc.lechun.erp.util.method.ToCanUseFiled;
import cc.lechun.erp.util.redisLock.ErpRedisReturnLock;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationDataDo
implements Serializable {
    private static Logger log = LoggerFactory.getLogger((String)"OperationDataDo");

    public static <T> MatchBatch matchingBatchs(T t, AtoB<T, MatchBatch> atob, Ok_<MatchBatch, T> ok_, No_<MatchBatch, T> no_) {
        if (null == t) {
            MatchBatch l = new MatchBatch();
            l.setStatus(500);
            l.setErroMessage("\u53c2\u6570\u9519\u8bef \u672a\u67e5\u8be2\u5230\u8981\u8f6c\u6362\u7684\u6570\u636e");
            return l;
        }
        MatchBatch l = atob.aToB(t);
        GetBean.getBean(ErpRedisReturnLock.class);
        return ErpRedisReturnLock.myLock(l.getStoreId(), () -> {
            long a = System.currentTimeMillis();
            MatchBatch s = GetBean.getBean(MatchTheBatchDo.class).matcBatchByOrder(l);
            if (s.getStatus() != 200) {
                no_.no(s, t);
            } else {
                ok_.ok(s, t);
            }
            log.info("\u5339\u914d\u6279\u6b21\u603b\u5171\u8017\u65f6 \uff1a{}", (Object)(System.currentTimeMillis() - a));
            return s;
        });
    }

    public static <T> BaseJsonVo<MatchBatch> matchingBatchsNoTry(T t, AtoB<T, MatchBatch> atob, Ok_<MatchBatch, T> ok_, No_<MatchBatch, T> no_) {
        if (null == t) {
            MatchBatch l = new MatchBatch();
            l.setStatus(500);
            l.setErroMessage("\u53c2\u6570\u9519\u8bef \u672a\u67e5\u8be2\u5230\u8981\u8f6c\u6362\u7684\u6570\u636e");
            return new BaseJsonVo<MatchBatch>(500, "\u53c2\u6570\u9519\u8bef \u672a\u67e5\u8be2\u5230\u8981\u8f6c\u6362\u7684\u6570\u636e", l);
        }
        MatchBatch l = atob.aToB(t);
        GetBean.getBean(ErpRedisReturnLock.class);
        return ErpRedisReturnLock.lockNoTry(l.getStoreId(), () -> {
            long a = System.currentTimeMillis();
            MatchBatch s = GetBean.getBean(MatchTheBatchDo.class).matcBatchByOrder(l);
            if (s.getStatus() != 200) {
                no_.no(s, t);
            } else {
                ok_.ok(s, t);
            }
            log.info("\u5339\u914d\u6279\u6b21\u603b\u5171\u8017\u65f6 \uff1a{}", (Object)(System.currentTimeMillis() - a));
            return s;
        });
    }

    public static BaseJsonVo<String> qimenConfirm(String orderNO, Map<String, BigDecimal> qimenDatas, int type) {
        Order order = Method.getBean(ErpOperationDataMapper.class).getOrder(orderNO, "" + type);
        if (null == order) {
            return new BaseJsonVo<String>(500, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (type == 1 ? order.getStatus() == 2 : (type == 2 ? order.getStatus() == 2 : type == 3 && order.getStatus() == 2)) {
            return new BaseJsonVo<String>(200, "\u8ba2\u5355\u5df2\u786e\u8ba4\uff0c\u65e0\u9700\u91cd\u590d\u786e\u8ba4");
        }
        GetBean.getBean(ErpRedisReturnLock.class);
        return ErpRedisReturnLock.myLock(order.getStoreId(), () -> OperationDataDo.qimenConfirmDiff(orderNO, order, qimenDatas, type));
    }

    public static <M> BaseJsonVo<String> checkCanUseQtys(String storeId, Object notInOrderType, List<M> oldList, ToCanUseFiled<M> toCanUseFiled, Success_ success_, Error_ error_) {
        GetBean.getBean(ErpRedisReturnLock.class);
        return ErpRedisReturnLock.myLock(storeId, () -> {
            BaseJsonVo<String> baseJsonVo = OperationDataDo.getCanUseQtys(storeId, toCanUseFiled.toCanUseFiled(oldList), notInOrderType);
            if (baseJsonVo.getStatus() == 200) {
                success_.success();
            } else {
                error_.error(baseJsonVo.getMessage());
            }
            return baseJsonVo;
        });
    }

    public static void saveDispatchOrderAccountDetails(String mainId, String storeId) {
        Method.getBean(ErpOperationDataMapper.class).saveDispatchOrderAccountDetails(mainId, storeId, "\u53d1\u8d27\u5355", "0");
    }

    public static void saveStoreOrderOut(String mainId, String storeId, String billType) {
        OperationDataDo.saveStoreOrderAccountDetails(mainId, storeId, billType, "0");
    }

    public static void saveStoreOrderIn(String mainId, String storeId, String billType) {
        OperationDataDo.saveStoreOrderAccountDetails(mainId, storeId, billType, "1");
    }

    public static void savePuStoreOrderAccountDetails(String mainId, String storeId) {
        Method.getBean(ErpOperationDataMapper.class).savePuStoreOrderAccountDetails(mainId, storeId, "\u91c7\u8d2d\u5165\u5e93\u5355", "1");
    }

    public static String getCanUseKey(String storeId, String matId, Date productionDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(matId).append("|");
        sb.append(storeId);
        Mat mat = MatDo.id(matId);
        if (null != productionDate && null != mat.getIexpirydays()) {
            sb.append("|").append(MyDateUtil.formatDate(productionDate, "yyyy-MM-dd"));
            sb.append("|").append(MatDo.id(matId).getIexpirydays().intValue());
        }
        return sb.toString();
    }

    private static BaseJsonVo<String> getCanUseQtys(String storeId, List<CanUseFiled> mats, Object notInOrderType) {
        Set matIds = mats.stream().map(v -> v.getMatId()).collect(Collectors.toSet());
        List<CanUseQty> list = OperationDataDo.getCanUseQty(storeId, matIds, notInOrderType);
        Map canUseMap = list.stream().collect(Collectors.toMap(m -> m.getOneKey(), Function.identity(), (k1, k2) -> k1));
        Map<String, List<CanUseFiled>> mapGroup = mats.stream().collect(Collectors.groupingBy(s -> OperationDataDo.getCanUseKey(storeId, s.getMatId(), s.getProductionDate())));
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, List<CanUseFiled>> group : mapGroup.entrySet()) {
            BigDecimal matNumSum = group.getValue().stream().map(v -> v.getMatNum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (canUseMap.containsKey(group.getKey())) {
                BigDecimal diff = matNumSum.subtract(((CanUseQty)canUseMap.get(group.getKey())).getCanUseQty());
                if (!(diff.doubleValue() > 0.0)) continue;
                sb.append("\u7269\u54c1(" + MatDo.id(group.getValue().get(0).getMatId()).getName());
                if (null != group.getValue().get(0).getProductionDate()) {
                    sb.append("- \u751f\u4ea7\u65e5\u671f :").append(MyDateUtil.formatDate(group.getValue().get(0).getProductionDate(), "yyyy-MM-dd"));
                }
                sb.append(")\u53f0\u8d26\u5dee(" + diff.doubleValue() + ")\u4e2a").append("\u3002");
                continue;
            }
            sb.append("\u7269\u54c1(" + MatDo.id(group.getValue().get(0).getMatId()).getName());
            if (null != group.getValue().get(0).getProductionDate()) {
                sb.append("- \u751f\u4ea7\u65e5\u671f :").append(MyDateUtil.formatDate(group.getValue().get(0).getProductionDate(), "yyyy-MM-dd"));
            }
            sb.append(") \u53f0\u8d26\u5dee(" + matNumSum.doubleValue() + ")\u4e2a").append("\u3002");
        }
        if (!sb.toString().equals("")) {
            return new BaseJsonVo<String>(500, "\u4ed3\u5e93(" + StoreDo.id(storeId).getName() + ")" + sb.toString());
        }
        return new BaseJsonVo<String>();
    }

    private static List<CanUseQty> getCanUseQty(Object storeIds, Object matIds, Object notInOrderType) {
        return Method.getBean(ErpOperationDataMapper.class).getCanUseQty(storeIds, matIds, notInOrderType);
    }

    private static BaseJsonVo<String> qimenConfirmDiff(String orderNO, Order order, Map<String, BigDecimal> qimenDatas, int type) {
        Map<Object, Object> oldDatas = new HashMap();
        if (type == 1) {
            oldDatas = OperationDataDo.getDispatchProduct(orderNO);
        } else if (type == 2) {
            oldDatas = OperationDataDo.getStockRecordDetail(orderNO);
        } else if (type == 3) {
            oldDatas = OperationDataDo.getStockPuDetail(orderNO);
        }
        BaseJsonVo<String> baseJsonVo = OperationDataDo.qimenConfirmDiff(oldDatas, qimenDatas);
        if (baseJsonVo.getStatus() != 200) {
            Method.getBean(ErpOperationDataMapper.class).updateErrMsg(orderNO, baseJsonVo.getMessage(), "" + type);
        } else {
            if (type == 1) {
                OperationDataDo.saveDispatchOrderAccountDetails(order.getMainId(), order.getStoreId());
            } else if (type == 2) {
                if (order.getType() == 0) {
                    OperationDataDo.saveStoreOrderOut(order.getMainId(), order.getStoreId(), order.getBillType());
                } else if (order.getType() == 1) {
                    OperationDataDo.saveStoreOrderIn(order.getMainId(), order.getStoreId(), order.getBillType());
                }
            } else if (type == 3) {
                OperationDataDo.savePuStoreOrderAccountDetails(order.getMainId(), order.getStoreId());
            }
            Method.getBean(ErpOperationDataMapper.class).updateStatus(orderNO, "" + type);
        }
        return baseJsonVo;
    }

    private static BaseJsonVo<String> qimenConfirmDiff(Map<String, BigDecimal> oldDatas, Map<String, BigDecimal> qimenDatas) {
        String[] objs_;
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, BigDecimal> map : oldDatas.entrySet()) {
            if (qimenDatas.containsKey(map.getKey())) continue;
            objs_ = map.getKey().split("\\|");
            if (objs_.length == 1) {
                sb.append("\u8ba2\u5355\u4e2d \u5546\u54c1(" + MatDo.id(objs_[0]).getName() + ")\u6570\u91cf (" + String.valueOf(map.getValue()) + ") \u5947\u95e8\u672a\u8fd4\u56de\u3002\n");
                continue;
            }
            sb.append("\u8ba2\u5355\u4e2d \u6279\u6b21\u7ba1\u7406\u5546\u54c1(" + MatDo.id(objs_[0]).getName() + ") \u751f\u4ea7\u65e5\u671f(" + objs_[2] + ") \u6570\u91cf (" + String.valueOf(map.getValue()) + ") \u5947\u95e8\u672a\u8fd4\u56de\u3002\n");
        }
        for (Map.Entry<String, BigDecimal> map : qimenDatas.entrySet()) {
            if (oldDatas.containsKey(map.getKey())) continue;
            objs_ = map.getKey().split("\\|");
            if (objs_.length == 1) {
                sb.append("\u5947\u95e8\u786e\u8ba4\u4e2d \u5546\u54c1(" + MatDo.id(objs_[0]).getName() + ") \u6570\u91cf (" + String.valueOf(map.getValue()) + ") \u8fd4\u56de\u6570\u636e\u5728\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728\u3002\n");
                continue;
            }
            sb.append("\u5947\u95e8\u786e\u8ba4\u4e2d \u6279\u6b21\u7ba1\u7406\u5546\u54c1(" + MatDo.id(objs_[0]).getName() + ") \u751f\u4ea7\u65e5\u671f(" + objs_[2] + ") \u6570\u91cf (" + String.valueOf(map.getValue()) + ") \u8fd4\u56de\u6570\u636e\u5728\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728\u3002\n");
        }
        for (Map.Entry<String, BigDecimal> map : oldDatas.entrySet()) {
            if (!qimenDatas.containsKey(map.getKey()) || map.getValue().subtract(qimenDatas.get(map.getKey())).doubleValue() == 0.0) continue;
            objs_ = map.getKey().split("\\|");
            if (objs_.length == 1) {
                sb.append("\u8ba2\u5355\u4e2d \u5546\u54c1(" + MatDo.id(objs_[0]).getName() + ") \u6570\u91cf (" + map.getKey() + ") \u8ddf\u5947\u95e8\u786e\u8ba4\u8fd4\u56de \u6570\u91cf(" + String.valueOf(qimenDatas.get(map.getKey())) + ")\u4e0d\u4e00\u81f4\u3002\n");
                continue;
            }
            sb.append("\u8ba2\u5355\u4e2d \u6279\u6b21\u7ba1\u7406\u5546\u54c1(" + MatDo.id(objs_[0]).getName() + ") \u751f\u4ea7\u65e5\u671f(" + objs_[2] + ") \u6570\u91cf (" + map.getKey() + ") \u5947\u95e8\u672a\u8fd4\u56de \u6570\u91cf(" + String.valueOf(qimenDatas.get(map.getKey())) + ")\u4e0d\u4e00\u81f4\u3002\\n");
        }
        if (!sb.toString().equals("")) {
            return new BaseJsonVo<String>(500, sb.toString());
        }
        return new BaseJsonVo<String>();
    }

    private static Map<String, BigDecimal> getDispatchProduct(String dispatchNo) {
        List<CanUseQty> list = Method.getBean(ErpOperationDataMapper.class).getDispatchProduct(dispatchNo);
        return list.stream().collect(Collectors.toMap(CanUseQty::getOneKey, CanUseQty::getCanUseQty));
    }

    private static Map<String, BigDecimal> getStockRecordDetail(String billCode) {
        List<CanUseQty> list = Method.getBean(ErpOperationDataMapper.class).getStockRecordDetail(billCode);
        return list.stream().collect(Collectors.toMap(CanUseQty::getOneKey, CanUseQty::getCanUseQty));
    }

    private static Map<String, BigDecimal> getStockPuDetail(String billCode) {
        List<CanUseQty> list = Method.getBean(ErpOperationDataMapper.class).getStockPuDetail(billCode);
        return list.stream().collect(Collectors.toMap(CanUseQty::getOneKey, CanUseQty::getCanUseQty));
    }

    public static void updateShopToken(String id, String shopToken) {
        Method.getBean(ErpOperationDataMapper.class).updateShopToken(id, shopToken);
        CacheMainDel.delete(Shop.delteCache("all"));
    }

    public static void saveStoreOrderAccountDetails(String mainId, String storeId, String billType, String inOuttype) {
        Method.getBean(ErpOperationDataMapper.class).saveStoreOrderAccountDetails(mainId, storeId, billType, inOuttype);
    }
}

