/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.job;

import cc.lechun.erp.dao.common.ErpScheduleJobMapper;
import cc.lechun.erp.domain.job.entity.ScheduleJob;
import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.MyCopy;
import cc.lechun.erp.util.MyDateUtil;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ManagedScheduledTasks {
    private static Logger logger = LoggerFactory.getLogger(ManagedScheduledTasks.class);
    private final TaskScheduler taskScheduler;
    private final Map<String, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap();

    @Autowired
    public ManagedScheduledTasks(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Scheduled(fixedDelay=30000L)
    public void delayedTask() {
        logger.info("\u4efb\u52a1\u5ef6\u8fdf5\u5206\u949f\u6267\u884c");
        List<ScheduleJob> list = GetBean.getBean(ErpScheduleJobMapper.class).getJobs();
        for (ScheduleJob a : list) {
            GetBean.getBean(ManagedScheduledTasks.class).startJob(a);
        }
        ScheduledTaskRegistrar taskRegistrar = GetBean.getBean(ScheduledTaskRegistrar.class);
        taskRegistrar.destroy();
    }

    @Transactional
    public boolean lock(ScheduleJob old) {
        logger.info("lock");
        ScheduleJob new_ = MyCopy.copy(old, ScheduleJob.class);
        new_.setBeforeTime(old.getNextTime());
        try {
            CronExpression cronExpression = new CronExpression(old.getExpression());
            new_.setNextTime(cronExpression.getNextValidTimeAfter(new Date()));
            if (GetBean.getBean(ErpScheduleJobMapper.class).updateLockJob(new_) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void startJob(final ScheduleJob old) {
        Runnable task = () -> {
            logger.info("Executing task " + old.getCguid());
            if (this.lock(GetBean.getBean(ErpScheduleJobMapper.class).getJobById(old.getCguid()))) {
                ((Runnable)GetBean.getBean("scheduleJobTest")).run();
            }
        };
        ScheduledFuture future = this.taskScheduler.schedule(task, new Trigger(){
            final /* synthetic */ ManagedScheduledTasks this$0;
            {
                this.this$0 = this$0;
            }

            public Date nextExecutionTime(TriggerContext triggerContext) {
                return new CronTrigger(old.getExpression()).nextExecutionTime(triggerContext);
            }

            public Instant nextExecution(TriggerContext triggerContext) {
                return new CronTrigger(old.getExpression()).nextExecution(triggerContext);
            }
        });
        this.scheduledTasks.put(old.getCguid(), future);
    }

    public void startOrStopJob(String cguid) {
        ScheduleJob one = GetBean.getBean(ErpScheduleJobMapper.class).getJobById(cguid);
        if (one.getStatus() == 0) {
            GetBean.getBean(ManagedScheduledTasks.class).stopJob(one.getCguid());
        } else if (one.getStatus() == 1) {
            if (this.scheduledTasks.get(one.getCguid()) == null) {
                GetBean.getBean(ManagedScheduledTasks.class).startJob(one);
            } else {
                GetBean.getBean(ManagedScheduledTasks.class).stopJob(one.getCguid());
                GetBean.getBean(ManagedScheduledTasks.class).startJob(one);
            }
        }
    }

    public void stopJob(String taskId) {
        ScheduledFuture<?> future = this.scheduledTasks.remove(taskId);
        if (future != null) {
            future.cancel(false);
        } else {
            logger.info("Task with ID " + taskId + " not found.");
        }
    }

    public static void main(String[] args) throws ParseException {
        CronExpression cronExpression = new CronExpression("0/40 * * * * ?");
        System.out.println(MyDateUtil.formatDate(cronExpression.getFinalFireTime(), ""));
    }
}

