/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.util;

import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.method.GetPage;
import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static <T> void export(String filename, Class<T> pojoClass, GetPage<T> server) {
        ExcelUtil.export(filename, filename, filename, pojoClass, server, null, GetBean.getBean(HttpServletResponse.class));
    }

    public static <T> void export(String filename, Class<T> pojoClass, GetPage<T> server, Object queryParams) {
        ExcelUtil.export(filename, filename, filename, pojoClass, server, queryParams, GetBean.getBean(HttpServletResponse.class));
    }

    public static <T> void export(String filename, Class<T> pojoClass, GetPage<T> server, Object queryParams, HttpServletResponse response) {
        ExcelUtil.export(filename, filename, filename, pojoClass, server, queryParams, response);
    }

    public static <T> void export(String title, String sheetName, String filename, Class<T> pojoClass, GetPage<T> server, Object queryParams, HttpServletResponse response) {
        try {
            filename = StringUtils.isBlank((CharSequence)filename) ? "export.csv" : (String)filename + ".csv";
            String encodedFilename = URLEncoder.encode((String)filename, "UTF-8").replace("+", "%20");
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename + "; filename*=UTF-8''" + encodedFilename);
            ExportParams params = new ExportParams();
            params.setType(ExcelType.XSSF);
            params.setTitle(title);
            params.setSheetName(sheetName);
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, pojoClass, (findParams, page) -> {
                int startRow = (page - 1) * 2000;
                int endRow = page * 2000;
                List list = server.getList((Map)findParams, startRow, endRow);
                int sum = list.size() < 2000 ? startRow + list.size() : endRow;
                log.info("\u7b2c" + startRow + "\u9875\u6570\u636e \u6bcf\u9875\u6240" + endRow + "\u6761,\u5b9e\u9645\u6bcf\u9875\u591a" + (list != null ? list.size() : 0) + "\u6761 ,\u603b\u5171 " + sum + "\u6761");
                return list;
            }, (Object)queryParams);
            workbook.write((OutputStream)response.getOutputStream());
            workbook.close();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        ExcelUtil.exportflush(response);
    }

    public static <T> void export(String filename, Class<T> pojoClass, List<T> server) {
        ExcelUtil.export(filename, filename, filename, pojoClass, server, GetBean.getBean(HttpServletResponse.class));
    }

    public static <T> void export(String filename, Class<T> pojoClass, List<T> server, HttpServletResponse response) {
        ExcelUtil.export(filename, filename, filename, pojoClass, server, response);
    }

    public static <T> void export(String title, String sheetName, String filename, Class<T> pojoClass, List<T> server, HttpServletResponse response) {
        try {
            filename = StringUtils.isBlank((CharSequence)filename) ? "export.csv" : (String)filename + ".csv";
            String encodedFilename = URLEncoder.encode((String)filename, "UTF-8").replace("+", "%20");
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename + "; filename*=UTF-8''" + encodedFilename);
            ExportParams params = new ExportParams();
            params.setType(ExcelType.XSSF);
            params.setTitle(title);
            params.setSheetName(sheetName);
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            workbook = ExcelExportUtil.exportExcel((ExportParams)params, pojoClass, server);
            workbook.write((OutputStream)response.getOutputStream());
            workbook.close();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        ExcelUtil.exportflush(response);
    }

    static void exportflush(HttpServletResponse response) {
        if (response != null) {
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (Exception e) {
                log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
    }

    public static <T> List<T> import_(MultipartFile file, int TitleRows, int HeadRows, Class<?> pojoClass) throws Exception {
        ImportParams params = new ImportParams();
        params.setTitleRows(TitleRows);
        params.setHeadRows(HeadRows);
        return ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
    }

    public static <T> List<T> import_(MultipartFile file, Class<?> pojoClass) throws Exception {
        return ExcelUtil.import_(file, 0, 1, pojoClass);
    }
}

