/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.core.baseclass;

import cc.lechun.framework.core.baseclass.DbContextHolder;
import cc.lechun.framework.core.baseclass.DbType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataSourceAspect {
    static Logger logger = LoggerFactory.getLogger(DataSourceAspect.class);

    @Before(value="@annotation(org.springframework.transaction.annotation.Transactional)")
    public void setWriteDataSource(JoinPoint joinPoint) {
        DbContextHolder.setDbType(DbType.WRITE);
    }

    @Before(value="execution(* cc.lechun.*.dao.common.*.*(..)) || execution(* cc.lechun.*.dao.*.*(..)) || execution(* cc.lechun.*.*.mapper.*.*.*(..))")
    public void setReadDataSource(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String name = signature.getMethod().getName();
        if (name.startsWith("save") || name.startsWith("update") || name.startsWith("insert") || name.startsWith("add") || name.startsWith("delete")) {
            DbContextHolder.setDbType(DbType.WRITE);
        } else {
            DbContextHolder.setDbType(DbType.READ);
        }
    }

    @After(value="execution(* cc.lechun.*.dao.common.*.*(..)) || execution(* cc.lechun.*.dao.*.*(..)) || execution(* cc.lechun.*.*.mapper.*.*.*(..))")
    public void clearDataSource(JoinPoint joinPoint) {
        DbContextHolder.clearDbType();
    }
}

