/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.erp.domain.job;

import cc.lechun.erp.dao.common.ErpScheduleJobMapper;
import cc.lechun.erp.domain.job.entity.JobEntity;
import cc.lechun.erp.domain.job.entity.ScheduleJob;
import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.MyCopy;
import cc.lechun.erp.util.MyDateUtil;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.transaction.annotation.Transactional;

public abstract class ManagedScheduledTasks {
    private static Logger logger = LoggerFactory.getLogger(ManagedScheduledTasks.class);
    private final TaskScheduler taskScheduler;
    private final Map<String, JobEntity> scheduledTasks = new ConcurrentHashMap<String, JobEntity>();
    private static boolean mainFlag = true;

    @Autowired
    public ManagedScheduledTasks(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Scheduled(initialDelay=120000L)
    public void delayedTask() {
        List<ScheduleJob> list = GetBean.getBean(ErpScheduleJobMapper.class).getJobs();
        if (list != null && list.size() > 0) {
            for (ScheduleJob a : list) {
                this.startOrStopJob(a);
            }
        }
    }

    @Transactional
    public boolean lock(ScheduleJob old) {
        ScheduleJob new_ = MyCopy.copy(old, ScheduleJob.class);
        new_.setBeforeTime(old.getNextTime());
        try {
            if (old.getStatus() == 0) {
                return false;
            }
            CronExpression cronExpression = new CronExpression(old.getExpression());
            new_.setNextTime(cronExpression.getNextValidTimeAfter(new Date()));
            if (GetBean.getBean(ErpScheduleJobMapper.class).updateLockJob(new_) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void startJob(final ScheduleJob old) {
        Runnable task = () -> {
            if (((ManagedScheduledTasks)this.getBean()).lock(GetBean.getBean(ErpScheduleJobMapper.class).getJobById(old.getCguid()))) {
                ((Runnable)GetBean.getBean("scheduleJobTest")).run();
            }
        };
        ScheduledFuture future = this.taskScheduler.schedule(task, new Trigger(){
            final /* synthetic */ ManagedScheduledTasks this$0;
            {
                this.this$0 = this$0;
            }

            public Date nextExecutionTime(TriggerContext triggerContext) {
                return new CronTrigger(old.getExpression()).nextExecutionTime(triggerContext);
            }

            public Instant nextExecution(TriggerContext triggerContext) {
                return new CronTrigger(old.getExpression()).nextExecution(triggerContext);
            }
        });
        JobEntity v = new JobEntity(old.getExpression(), future, old);
        this.scheduledTasks.put(old.getCguid(), v);
    }

    public void stopJob(String taskId) {
        JobEntity job = this.scheduledTasks.remove(taskId);
        if (job != null) {
            job.getFuture().cancel(false);
        }
    }

    public void startOrStopJob(ScheduleJob one) {
        if (one.getStatus() == 0) {
            this.stopJob(one.getCguid());
        } else if (one.getStatus() == 1) {
            if (this.scheduledTasks.get(one.getCguid()) == null) {
                this.startJob(one);
            } else if (!this.scheduledTasks.get(one.getCguid()).getExpression().equals(one.getExpression())) {
                this.stopJob(one.getCguid());
                this.startJob(one);
                this.scheduledTasks.get(one.getCguid()).setExpression(one.getExpression());
            }
        }
    }

    public void startOrStopJob(String cguid) {
        ScheduleJob one = GetBean.getBean(ErpScheduleJobMapper.class).getJobById(cguid);
        this.startOrStopJob(one);
    }

    public abstract <T extends ManagedScheduledTasks> T getBean();

    public static void main(String[] args) throws ParseException {
        CronExpression cronExpression = new CronExpression("0/40 * * * * ?");
        System.out.println(MyDateUtil.formatDate(cronExpression.getFinalFireTime(), ""));
    }
}

