/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.jqgridData;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import io.micrometer.common.util.StringUtils;
import java.util.List;

public class JqGridData<T> {
    private String page;
    private String total;
    private String records;
    private List<T> rows;

    public JqGridData() {
    }

    public JqGridData(List<T> rows) {
        if (rows instanceof Page) {
            PageInfo pageInfo = new PageInfo(rows);
            this.page = String.valueOf(pageInfo.getPageNum());
            this.total = String.valueOf(pageInfo.getPages());
            this.rows = pageInfo.getList();
            this.records = String.valueOf(pageInfo.getTotal());
        } else {
            this.page = "1";
            this.total = "";
            this.records = "";
            this.rows = rows;
        }
    }

    public JqGridData(String page, List<T> rows) {
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        if (rows instanceof Page) {
            PageInfo pageInfo = new PageInfo(rows);
            this.page = String.valueOf(pageInfo.getPageNum());
            this.total = String.valueOf(pageInfo.getPages());
            this.rows = pageInfo.getList();
            this.records = String.valueOf(pageInfo.getTotal());
        } else {
            this.page = page;
            this.total = "";
            this.records = "";
            this.rows = rows;
        }
    }

    public JqGridData(String page, String total, String records, List<T> rows) {
        this.page = page;
        this.total = total;
        this.records = records;
        this.rows = rows;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getRecords() {
        return this.records;
    }

    public void setRecords(String records) {
        this.records = records;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        if (rows instanceof Page) {
            PageInfo pageInfo = new PageInfo(rows);
            this.page = String.valueOf(pageInfo.getPageNum());
            this.total = String.valueOf(pageInfo.getPages());
            this.rows = pageInfo.getList();
            this.records = String.valueOf(pageInfo.getTotal());
        } else {
            this.rows = rows;
        }
    }

    public String toString() {
        return "JqGridData{page='" + this.page + "', total='" + this.total + "', records='" + this.records + "', rows=" + String.valueOf(this.rows) + "}";
    }
}

