/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.vo;

import cc.lechun.erp.util.GetBean;
import cc.lechun.erp.util.Redis;
import cc.lechun.framework.common.client.UserClient;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import io.micrometer.common.util.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JedisUtils {
    private static Logger log = LoggerFactory.getLogger((String)"JedisUtils");
    @Autowired
    private HttpServletRequest request;
    private static String redisKey = "JedisUtils-userId-";

    public static BaseUser getBaseUser(HttpServletRequest request) {
        String id = StringUtils.isBlank((String)request.getHeader("id")) ? request.getParameter("userId_") : request.getHeader("id");
        return JedisUtils.getBaseUser(id);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public static BaseUser getBaseUser() {
        try {
            return JedisUtils.getBaseUser(GetBean.getBean(JedisUtils.class).getRequest());
        }
        catch (Exception e) {
            return JedisUtils.getBaseUser("");
        }
    }

    public static BaseUser getBaseUser(String id) {
        BaseUser b = new BaseUser();
        b.setUserName("SYS-\u7cfb\u7edf");
        b.setEmployeeName("SYS-\u7cfb\u7edf");
        if (StringUtils.isNotBlank((String)id)) {
            Object u = Redis.redis().opsForValue().get((Object)(redisKey + id));
            if (u != null) {
                b.setUserName(u.toString());
                b.setEmployeeName(u.toString());
                return b;
            }
            BaseJsonVo<String> o = GetBean.getBean(UserClient.class).getUserNickName(id);
            if (o != null && StringUtils.isNotBlank((String)o.getValue())) {
                b.setUserName(o.getValue());
                b.setEmployeeName(o.getValue());
                Redis.redis().opsForValue().set((Object)(redisKey + id), (Object)o.getValue(), 86400L, TimeUnit.SECONDS);
                return b;
            }
        }
        return b;
    }
}

