/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.core.baseclass;

import cc.lechun.framework.core.baseclass.DataSourceAspect;
import cc.lechun.framework.core.baseclass.DbSql;
import com.github.pagehelper.PageInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"cc.lechun.*.dao", "cc.lechun.erp.*.mapper.*"}, sqlSessionTemplateRef="sqlSessionTemplate")
public class MyBatisConfig {
    static Logger logger = LoggerFactory.getLogger(DataSourceAspect.class);
    @Value(value="${mybatis.mapper-locations}")
    private String mapperLocations;

    @Bean
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="dynamicDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        sqlSessionFactoryBean.setVfs(SpringBootVFS.class);
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.addInterceptor((Interceptor)new DbSql());
        configuration.setMapUnderscoreToCamelCase(true);
        sqlSessionFactoryBean.setConfiguration(configuration);
        Interceptor[] plugins = new Interceptor[]{this.pageHelper()};
        sqlSessionFactoryBean.setPlugins(plugins);
        logger.debug("mybatis.mapper-locations:{}", (Object)this.mapperLocations);
        if (this.mapperLocations == null) {
            throw new RuntimeException("mybatis.mapper-locations \u8def\u5f84\u672a\u914d\u7f6e\uff01");
        }
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String path : this.mapperLocations.split(",")) {
            try {
                Resource[] resources = resolver.getResources(path);
                if (resources == null || resources.length <= 0) continue;
                resourceList.addAll(List.of(resources));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load mapper resources from path: " + path, e);
            }
        }
        if (!resourceList.isEmpty()) {
            sqlSessionFactoryBean.setMapperLocations(resourceList.toArray(new Resource[0]));
        }
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public Interceptor pageHelper() {
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        properties.setProperty("offsetAsPageNum", "true");
        properties.setProperty("rowBoundsWithCount", "true");
        properties.setProperty("reasonable", "true");
        PageInterceptor interceptor = new PageInterceptor();
        interceptor.setProperties(properties);
        return interceptor;
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

