/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.cache;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.cache.RedisLock;
import cc.lechun.framework.common.utils.cache.RedisLockParameter;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockAOP {
    @Autowired
    RedisCacheUtil redis;

    @Pointcut(value="@annotation(redisLock)")
    public void redisLockPoint(RedisLock redisLock) {
    }

    @Around(value="redisLockPoint(redisLock)")
    public void doAround(ProceedingJoinPoint joinPoint, RedisLock redisLock) throws Throwable {
        Boolean getLockSuccess = false;
        String clientId = InetAddress.getLocalHost().getHostAddress() + " | " + Thread.currentThread().getId();
        StringBuffer key = new StringBuffer(redisLock.key());
        if (key.length() == 0) {
            String className = joinPoint.getSignature().getDeclaringTypeName();
            String methodName = joinPoint.getSignature().getName();
            key.append(className).append(".").append(methodName);
        }
        Annotation[][] parameterAnnotations = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterAnnotations();
        HashMap<Integer, Object> params = new HashMap<Integer, Object>(parameterAnnotations.length);
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] an;
            for (Annotation innerAn : an = parameterAnnotations[i]) {
                if (!(innerAn instanceof RedisLockParameter)) continue;
                params.put(((RedisLockParameter)innerAn).order(), joinPoint.getArgs()[i]);
            }
        }
        ArrayList index = new ArrayList(params.keySet());
        Collections.sort(index);
        index.forEach(idx -> {
            if (idx != null && params.get(idx) != null) {
                key.append(":").append(params.get(idx).toString());
            }
        });
        Long expireTime = redisLock.expire();
        Long waitTime = redisLock.waitTime();
        getLockSuccess = waitTime <= 0L ? this.redis.lock(key.toString(), clientId, expireTime) : this.redis.waitLock(key.toString(), clientId, expireTime, waitTime);
        if (getLockSuccess.booleanValue()) {
            joinPoint.proceed();
        }
        this.redis.releaseLock(key.toString(), clientId);
    }
}

