/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.sign;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5 {
    private static final Logger logger = LoggerFactory.getLogger(MD5.class);

    public static String sign(String text) {
        return DigestUtils.md5Hex((String)text);
    }

    public static String sign(String text, String key) {
        text = text + key;
        return DigestUtils.md5Hex((String)text);
    }

    public static String sign(String text, String key, String input_charset) {
        text = text + key;
        return DigestUtils.md5Hex((byte[])MD5.getContentBytes(text, input_charset));
    }

    public static boolean verify(String text, String sign, String key, String input_charset) {
        String mysign = DigestUtils.md5Hex((byte[])MD5.getContentBytes(text = text + key, input_charset));
        return mysign.equals(sign);
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static String createSign(SortedMap<String, String> paramsMap, String apiKey) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = paramsMap.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + ":" + v + ",");
        }
        if (!sb.toString().isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("_" + apiKey);
        logger.info("*********\u7b7e\u540d\u4e32**************sb={}", (Object)sb.toString());
        String sign = MD5.sign(sb.toString()).toUpperCase();
        logger.info("*********\u7b7e\u540d\u503c**************sign={}", (Object)sign);
        return sign;
    }

    public static String signatureByAppKey(String paramString) {
        try {
            Map params = JsonUtils.stringToMap(paramString);
            String appKey = params.get("appKey") == null ? "" : params.get("appKey").toString();
            return appKey;
        }
        catch (Exception e) {
            logger.info("****************\u9519\u8bef");
            return "\u9519\u8bef";
        }
    }

    public static String md5(String text, String charset) throws Exception {
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        byte[] bytes = text.getBytes(charset);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(bytes);
        bytes = messageDigest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return sb.toString().toLowerCase();
    }

    public static void main(String[] arg) {
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        paramsMap.put("orderNo", "201808131359513506442241");
        paramsMap.put("createTime", "2018-11-08");
        paramsMap.put("appKey", "key001");
        paramsMap.put("sign", "32CE2EDF5E7A32B7F5AA41CA4642BF77");
        String paramString = JsonUtils.toJson(paramsMap, false);
        Map params = JsonUtils.stringToMap(paramString);
        String appKey = params.get("appKey") == null ? "" : params.get("appKey").toString();
        logger.info("appkey={},params={}", (Object)appKey, params.get("appKey"));
        String signUrl = null;
        signUrl = "http://registertest.lechun.cc:8802/lechun-sys/appToken/signatureByAppKey";
        String signResult = "";
        try {
            signResult = HttpRequest.post(signUrl, "paramString=" + URLEncoder.encode(paramString, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.info("********\u62e6\u622a\u5668ApiInterceptor\u63a5\u53e3\u9a8c\u7b7e\u8fd4\u56de\u7ed3\u679c******signResult={}", (Object)signResult);
        System.out.println("==" + MD5.sign("\u5218\u5fb7\u534e", "", "utf-8"));
        System.out.println("==" + MD5.sign("\u5218\u5fb7\u534e", ""));
    }
}

