package cc.lechun.framework.common.utils.object;

import cc.lechun.framework.common.utils.annotation.AttributeName;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;

import com.google.common.collect.Maps;

import org.springframework.cglib.beans.BeanMap;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.*;

/**
 * Created by liqun on 2018/1/8.
 */
public class ObjectConvert {

    /**
     * 将对象装换为map
     * @param bean
     * @return
     */
    public static <T> Map<String, Object> beanToMap(T bean) {
        Map<String, Object> map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key+"", beanMap.get(key));
            }
        }
        return map;
    }


    public static <T> Map<String,String> objectConvertToMap(T t)
    {
         Class<?> cls =t.getClass();
         Field[] fields = cls.getDeclaredFields();
         Map<String ,String> map=new LinkedHashMap<>();
         for (Field field : fields) {
             AttributeName attrName = field.getAnnotation(AttributeName.class);
             Object value = null;
             String name=attrName==null?field.getName():attrName.value()[0];
             value = getFieldValueByName(field.getName(),t);//t.getClass().get(field.getName());
             if(value==null){
                 value="";
             }
             map.put(name, value.toString());
         }

        return map;
    }
    public static <T> Map<String,Object> objectConvertToObjectMap(T t)
    {
        Class<?> cls =t.getClass();
        Field[] fields = cls.getDeclaredFields();
        Map<String ,Object> map=new LinkedHashMap<>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name=attrName==null?field.getName():attrName.value()[0];
            value = getFieldValueByName(field.getName(),t);//t.getClass().get(field.getName());
            map.put(name, value);
        }

        return map;
    }
    public static <T> Map<String,Object> objectWithSuperConvertToObjectMap(T t)
    {
        Class<?> cls =t.getClass();
        List<Field> fields = new ArrayList<>();
        Class tempClass = t.getClass();
        while (tempClass != null && !tempClass.getName().toLowerCase().equals("java.lang.object")) {//当父类为null的时候说明到达了最上层的父类(Object类).
            fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            tempClass = tempClass.getSuperclass(); //得到父类,然后赋给自己
        }
        Map<String ,Object> map=new LinkedHashMap<>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name=attrName==null?field.getName():attrName.value()[0];
            value = getFieldValueByName(field.getName(),t);//t.getClass().get(field.getName());
            map.put(name, value);
        }

        return map;
    }
    public static <T> SortedMap<String,String> objectConvertToSortedMap(T t)
    {
        Class<?> cls =t.getClass();
        Field[] fields = cls.getDeclaredFields();
        SortedMap<String ,String> map=new TreeMap<>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name=attrName==null?field.getName():attrName.value()[0];
            value = getFieldValueByName(field.getName(),t);//t.getClass().get(field.getName());
            if(value==null){
                value="";
            }
            if(value instanceof String ||value instanceof Integer||value instanceof Long||value instanceof BigDecimal||value instanceof Boolean||value instanceof Short){

            }else{
                value=JsonUtils.toJson(value,false);
            }

            map.put(name, value.toString());
        }
        return map;
    }
    /**
     * 根据属性名获取属性值
     * */
    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[] {});

            return method.invoke(o, new Object[] {});
        } catch (Exception e) {
            return null;
        }
    }
    public static <T> T requestConvertToObject(HttpServletRequest request, Class<T> clazz) {
        T vo = null;
        try {
            vo = clazz.newInstance();
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                AttributeName attrName = field.getAnnotation(AttributeName.class);
                String name=attrName==null?field.getName():attrName.value()[0];
                String value = request.getParameter(name);
                field.setAccessible(true);
                if (value!=null&&!value.isEmpty()) {
                    value = value.trim();
                    if (field.getType().equals(Long.class)) {
                        field.set(vo, Long.valueOf(value));
                    } else if (field.getType().equals(Integer.class)) {
                        field.set(vo, Integer.valueOf(value));
                    } else if (field.getType().equals(String.class)) {
                        field.set(vo, value);
                    } else if (field.getType().equals(Date.class)) {
                        Date d = DateUtils.StrToDate(value,"yyyy-MM-dd HH:mm:ss");
                        if(d==null){
                            d = DateUtils.StrToDate(value,"yyyy-MM-dd");
                        }
                        field.set(vo, d);
                    } else if(field.getType().equals(BigDecimal.class)){
                        field.set(vo, BigDecimal.valueOf(Double.parseDouble(value)));
                    } else if(field.getType().equals(Boolean.class)){
                        field.set(vo, Boolean.valueOf(value.toLowerCase()=="true"?true:false));
                    } else{
                        field.set(vo, value);
                    }
                }
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }

        return vo;
    }
    public static <T> T mapConvertToObject(SortedMap<String,String> map, Class<T> clazz) {
        T vo = null;
        try {
            vo = clazz.newInstance();
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                try {
                    AttributeName attrName = field.getAnnotation(AttributeName.class);
                    String name = attrName == null ? field.getName() : attrName.value()[0];
                    String value = map.get(name);
                    field.setAccessible(true);
                    if (value != null && !value.isEmpty()) {
                        value = value.trim();
                        if (field.getType().equals(Long.class)) {
                            field.set(vo, Long.valueOf(value));
                        } else if (field.getType().equals(Integer.class)) {
                            field.set(vo, Integer.valueOf(value));
                        } else if (field.getType().equals(String.class)) {
                            field.set(vo, value);
                        } else if (field.getType().equals(Date.class)) {
                            Date d = DateUtils.StrToDate(value, "yyyy-MM-dd HH:mm:ss");
                            if (d == null) {
                                d = DateUtils.StrToDate(value, "yyyy-MM-dd");
                            }
                            field.set(vo, d);
                        } else if (field.getType().equals(BigDecimal.class)) {
                            field.set(vo, BigDecimal.valueOf(Double.parseDouble(value)));
                        } else if (field.getType().equals(Boolean.class)) {
                            field.set(vo, Boolean.valueOf(value.toLowerCase() == "true" ? true : false));
                        } else {
                            field.set(vo, value);
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }

        return vo;
    }
    public static <T> T mapConvertToObject(Map<String,String> map, T object){
        T vo = null;
        try {
            vo = object;//clazz.newInstance();
            Field[] fields =object.getClass().getDeclaredFields(); //clazz.getDeclaredFields();
            for (Field field : fields) {
                AttributeName attrName = field.getAnnotation(AttributeName.class);
                String name=attrName==null?field.getName():attrName.value()[0];
                String value = map.get(name);
                field.setAccessible(true);
                if (value!=null&&!value.isEmpty()) {
                    value = value.trim();
                    if (field.getType().equals(Long.class)) {
                        field.set(vo, Long.valueOf(value));
                    } else if (field.getType().equals(Integer.class)) {
                        field.set(vo, Integer.valueOf(value));
                    } else if (field.getType().equals(String.class)) {
                        field.set(vo, value);
                    } else if (field.getType().equals(Date.class)) {
                        Date d = DateUtils.StrToDate(value,"yyyy-MM-dd HH:mm:ss");
                        if(d==null){
                            d = DateUtils.StrToDate(value,"yyyy-MM-dd");
                        }
                        field.set(vo, d);
                    } else if(field.getType().equals(BigDecimal.class)){
                        field.set(vo, BigDecimal.valueOf(Double.parseDouble(value)));
                    } else if(field.getType().equals(Boolean.class)){
                        field.set(vo, Boolean.valueOf(value.toLowerCase()=="true"?true:false));
                    } else{
                        field.set(vo, value);
                    }
                }
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }

        return vo;
    }
    public static <T> T mapConvertToObject(Map<String,String> map, Class<T> clazz){
        try {
            return mapConvertToObject(map, clazz.newInstance());
        }catch (InstantiationException e){
            e.printStackTrace();
        }catch (IllegalAccessException e1){
            e1.printStackTrace();
        }
        return null;
    }

    /**
     * 数组转对象
     * @param bytes
     * @return
     */
    public static Object toObject (byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream (bytes);
            ObjectInputStream ois = new ObjectInputStream (bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }
    public static<F,C> void fatherConvertToChild (F father,C child)throws Exception{
        if(!(child.getClass().getSuperclass()==father.getClass())){
            throw new Exception("child不是father的子类");
        }
        Class fatherClass= father.getClass();
        Field ff[]= fatherClass.getDeclaredFields();
        for(int i=0;i<ff.length;i++) {
            Field f = ff[i];//取出每一个属性，如deleteDate
            f.setAccessible(true);
            try {
                Method m = fatherClass.getMethod("get" + upperHeadChar(f.getName()));//方法getDeleteDate
                if (m != null) {
                    Object obj = m.invoke(father);//取出属性值
                    f.set(child, obj);
                }
            }catch (Exception e){

            }
        }
    }
    private static String upperHeadChar(String in){
        String head=in.substring(0,1);
        String out=head.toUpperCase()+in.substring(1,in.length());
        return out;
    }
    public static<T> String objectConvertToUrpParam(T t)
    {
        Class<?> cls =t.getClass();
        Field[] fields = cls.getDeclaredFields();
        Map<String ,String> map=new LinkedHashMap<>();
        StringBuilder sb=new StringBuilder();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name=attrName==null?field.getName():attrName.value()[0];
            value = getFieldValueByName(field.getName(),t);//t.getClass().get(field.getName());
            if(value==null){
                value="";
            }
            sb.append(name);
            sb.append("=");
            if(value instanceof String) {
                sb.append(value);
            }else{
                try {
                    sb.append(URLEncoder.encode(JsonUtils.toJson(value,false),"utf-8"));
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            sb.append("&");
        }

        return sb.toString().length()>0?sb.toString().substring(0,sb.length()-1):sb.toString();
    }
}
