/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.log;

import cc.lechun.framework.common.utils.http.HttpUtil;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.SqlLogEntity;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AccessLogDBConfig {
    @Value(value="${accessLog.error:1}")
    private String accessLogError;
    @Value(value="${accessLog.Sql:1}")
    private String accessLogSql;
    @Value(value="${accessLog.SqlExecTime:1000}")
    private Integer accessLogSqlExecTime;
    @Value(value="${accessLog.WriteLogUrl:https://scmapi.lechun.cc/lechun-bi/accessLog/saveAccessLog}")
    private String accessLogWriteLogUrl;
    @Value(value="${spring.application.name:unknown}")
    private String sys;

    public void writeErrorDBLog(AccessLogEntity logEntity) {
        if (logEntity == null) {
            return;
        }
        if (StringUtils.isEmpty(this.accessLogWriteLogUrl)) {
            return;
        }
        if ("1".equals(this.accessLogError)) {
            logEntity.setOperator(this.sys);
            HttpUtil.doPost(this.accessLogWriteLogUrl, ObjectConvert.objectConvertToMap(logEntity));
        }
    }

    public void writeSqlDBLog(SqlLogEntity logEntity) {
        if (logEntity == null) {
            return;
        }
        if (StringUtils.isEmpty(this.accessLogWriteLogUrl)) {
            return;
        }
        if ("1".equals(this.accessLogSql)) {
            long s = logEntity.getRunTimes();
            if (this.accessLogSqlExecTime != null && s >= (long)this.accessLogSqlExecTime.intValue()) {
                logEntity.setOperator(this.sys);
                HttpUtil.doPost(this.accessLogWriteLogUrl, ObjectConvert.objectConvertToMap(logEntity));
            }
        }
    }
}

