package cc.lechun.framework.common.utils.ids;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.aspectj.apache.bcel.util.ClassPath;

import java.util.UUID;

/**
 * Created by liqun on 2018/2/8.
 */
public class OrderNoUtils {

    private static final String WORKERID_PATH = ClassPath.getClassPath()+ "/workerId";
    private static String lastNo="";
    private OrderNoUtils() {
    }

    private static class OrderNoUtilsHolder{
        private static OrderNoUtils instance = new OrderNoUtils();
    }

    public static OrderNoUtils getInstance() {
        return OrderNoUtilsHolder.instance;
    }

    /**
     * 节点 ID 默认取1
     */
    private long workerId = 1;
    /**
     * 序列id 默认取1
     */
    private long sequence = 1;

    /**
     * 机器标识位数
     */
    private final long workerIdBits = 10L;
    /**
     * 机器ID最大值
     */
    private final long maxWorkerId = -1L ^ (-1L << workerIdBits); //结果就是2的workerBits次方-1,能表示的最大数.全部1亦或10位0，就是0开头最后10位1
    /**
     * 毫秒内自增位
     */
    private final long sequenceBits = 12L;
    /**
     * 机器ID偏左移12位
     */
    private final long workerIdShift = sequenceBits;
    /**
     * 数据中心ID左移17位
     */
    private final long datacenterIdShift = sequenceBits + workerIdBits;

    private final long sequenceMask = -1L ^ (-1L << sequenceBits);

    /**
     * 时间毫秒左移22位
     */
    private final long timestampLeftShift = sequenceBits + workerIdBits;

    private long lastTimestamp = -1L;


    public String create() {
        return nextNo();
    }

    /**
     * 获取id 线程安全
     *
     * @return
     */
    private String nextNo(){
        return nextNo(workerId);
    }
    private synchronized String nextNo(long workerId) {
        long timestamp = timeGen();
        // 时间错误
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException("Clock moved backwards.");
        }
        // 当前毫秒内，则+1
        if (lastTimestamp == timestamp) {
            // 当前毫秒内计数满了，则等待下一秒
            sequence = (sequence + 1) & sequenceMask;
            if (sequence == 0) {
                timestamp = tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0;
        }
        lastTimestamp = timestamp;
        // ID偏移组合生成最终的ID，并返回ID,最大十位数

        long id = ((timestamp % 1000) << timestampLeftShift) | (workerId << workerIdShift) | sequence;
        //String timestampStr = new SimpleDateFormate("yyyyMMddHHmmss").format(timestamp);
        String timestampStr =DateFormatUtils.format(timestamp,"yyyyMMddHHmmss");
        return timestampStr+String.format("%010d",id);
    }

    /**
     * 等待下一个毫秒的到来
     *
     * @param lastTimestamp
     * @return
     */
    private long tilNextMillis(long lastTimestamp) {
        long timestamp = timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    /**
     * 最大十位，最小7位,补0format
     */
    /*public void test(){
        String t = String.valueOf((1L << 22) | (1 << 12) | 0);
        String t1 = String.valueOf((999L << 22) | (1023 << 12) | 0);
        System.out.println(DateFormatUtils.NUMBER_FORMAT.format(System.currentTimeMillis())+"-"+t);
        System.out.println(DateFormatUtils.NUMBER_FORMAT.format(System.currentTimeMillis())+"-"+t1);
        long l1 = (1L << 22) | (1 << 12) | 0;
        long l2 = (999L << 22) | (1023 << 12) | 0;
        System.out.println(l1);
        System.out.println(l2);
        System.out.println(String.format("%010d",l1));
        System.out.println(String.format("%010d",l2));
    }*/
    public static String genId(String machineId) throws InterruptedException {
        String orderId =
                machineId +System.nanoTime();//
                        //(System.currentTimeMillis() + "").substring(1) +'-'+
                        //(System.nanoTime() + "").substring(7, 10);
        orderId=String.valueOf(orderId.hashCode());
        while (lastNo.equals(orderId)) {
            //Thread.sleep(1);
            orderId =
                    machineId +
                            (System.currentTimeMillis() + "").substring(1) +'-'+
                            (System.nanoTime() + "").substring(7, 10);
        }
        lastNo=orderId;
        return orderId;
    }
    public static String getOrderIdByUUId(String machineId) {

        int hashCodeV = UUID.randomUUID().toString().hashCode();
        if (hashCodeV < 0) {//有可能是负数
            hashCodeV = -hashCodeV;
        }
        // 0 代表前面补充0
        // 4 代表长度为4
        // d 代表参数为正数型
        String orderId=machineId + String.format("%015d", hashCodeV);
        //System.out.println(orderId);
        return orderId;
    }
}
