package cc.lechun.framework.common.vo;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collection;

/**
 * 数据导出model
 */
public class ExportVo<T> {

    /**
     * 默认日期格式
     */
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * 操作导出的用户id
     */
    private String userId;

    /**
     * 操作导出的用户的企业id
     */
    private String ctenantId;

    /**
     * 导出隐藏列0，显示列1
     */
    private Integer isHide = 1;

    /**
     * 要导出的单据 gridId
     */
    private String gridId;

    /**
     * 导出的表格名称
     */
    private String sheetName;

    /**
     * 若是导出到文件中，则需设置文件名称，主要用来判断文件后缀，是导出成什么文件
     */
    private String fileName;

    /**
     * 导出结果中日期格式，默认格式为 yyyy-MM-dd HH:mm:ss @see {@link #DATE_FORMAT}
     */
    private String datePattern;

    /**
     * 要导出的数据
     */
    private Collection<T> dataset;

    /**
     * 表头中文名
     */
    private String[] headers;

    /**
     * 表头英文名
     */
    private String[] fieldNames;

    /**
     * 获取 操作导出的用户id
     *
     * @return userId
     */
    public String getUserId() {
        return userId;
    }

    /**
     * 设置 操作导出的用户id
     *
     * @param userId
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取 操作导出的用户的企业id
     *
     * @return ctenantId
     */
    public String getCtenantId() {
        return ctenantId;
    }

    /**
     * 设置 操作导出的用户的企业id
     *
     * @param ctenantId
     */
    public void setCtenantId(String ctenantId) {
        this.ctenantId = ctenantId;
    }

    /**
     * 获取 导出隐藏列0，显示列1
     *
     * @return isHide
     */
    public Integer getIsHide() {
        return isHide;
    }

    /**
     * 设置 导出隐藏列0，显示列1
     *
     * @param isHide
     */
    public void setIsHide(Integer isHide) {
        this.isHide = isHide;
    }

    /**
     * 获取 要导出的单据 gridId
     *
     * @return gridId
     */
    public String getGridId() {
        return gridId;
    }

    /**
     * 设置 要导出的单据 gridId
     *
     * @param gridId
     */
    public void setGridId(String gridId) {
        this.gridId = gridId;
    }

    /**
     * 获取 导出的表格名称
     *
     * @return sheetName
     */
    public String getSheetName() {
        return StringUtils.isBlank(sheetName) ? "sheet" : sheetName;
    }

    /**
     * 设置 导出的表格名称
     *
     * @param sheetName
     */
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    /**
     * 若是导出到文件中，则获取设置的文件名称， 主要用来判断文件后缀，是导出成什么文件
     *
     * @return fileName
     */
    public String getFileName() {
        return StringUtils.isBlank(fileName) ? "" : fileName;
    }

    /**
     * 若是导出到文件中，则需设置文件名称，主要用来判断文件后缀，是导出成什么文件
     *
     * @param fileName
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * 获取 导出结果中日期格式, 默认格式为 yyyy-MM-dd HH:mm:ss @see {@link #DATE_FORMAT}
     *
     * @return datePattern
     */
    public String getDatePattern() {
        if (this.datePattern == null || "".equals(this.datePattern.trim())) {
            return DATE_FORMAT;
        }
        return datePattern;
    }

    /**
     * 设置 导出结果中日期格式, 默认格式为 yyyy-MM-dd HH:mm:ss @see {@link #DATE_FORMAT}
     *
     * @param datePattern
     */
    public void setDatePattern(String datePattern) {
        if (datePattern == null || "".equals(datePattern.trim())) {
            this.datePattern = DATE_FORMAT;
        } else {
            this.datePattern = datePattern;
        }
    }

    /**
     * 获取 要导出的数据
     *
     * @return dataset
     */
    public Collection<T> getDataset() {
        return dataset;
    }

    /**
     * 设置 要导出的数据
     *
     * @param dataset
     */
    public void setDataset(Collection<T> dataset) {
        this.dataset = dataset;
    }

    /**
     * 获取  表头中文名
     *
     * @return headers
     */
    public String[] getHeaders() {
        return headers;
    }

    /**
     * 设置 表头中文名
     *
     * @param headers
     */
    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    /**
     * 获取  表头英文名
     *
     * @return fieldNames
     */
    public String[] getFieldNames() {
        return fieldNames;
    }

    /**
     * 设置 表头英文名
     *
     * @param fieldNames
     */
    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    @Override
    public String toString() {
        return "ExportVO [userId=" + userId + ", ctenantId=" + ctenantId
                + ", isHide=" + isHide + ", gridId=" + gridId + ", sheetName="
                + sheetName + ", fileName=" + fileName + ", datePattern="
                + datePattern + ", dataset=" + dataset + ", headers="
                + Arrays.toString(headers) + ", fieldNames="
                + Arrays.toString(fieldNames) + "]";
    }
}
