package cc.lechun.framework.common.utils.open.map;

import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.open.map.vo.AMapGeoResultVo;
import cc.lechun.framework.common.utils.open.map.vo.AMapRegeocodeVo;
import cc.lechun.framework.common.utils.sign.EncodeUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by wangxs on 2017/12/22
 * Description: 高德地图工具包
 * http://lbs.amap.com/api/webservice/guide/api/georegeo/  文档地址
 */
public class AMapUtil {

    private final static Logger log = LoggerFactory.getLogger(AMapUtil.class);

    public static final String key = "b68a501a13f802f2a46d194d14c9f1c2";

    private static final String GEO_URL = "http://restapi.amap.com/v3/geocode/geo?key=" + key + "";
    private static final String REGEO_URL = "http://restapi.amap.com/v3/geocode/regeo?key=" + key + "";

    /**
     * 地理编码：将详细的结构化地址转换为高德经纬度坐标。且支持对地标性名胜景区、建筑物名称解析为高德经纬度坐标。
     */
    public static AMapGeoResultVo geo(String city, String address) {
        String url = GEO_URL + "&address=" + EncodeUtils.urlEncode(address);
        if (!StringUtils.isEmpty(city)) {
            url = url + "&city=" + city;
        }
        HttpRequest httpRequest = new HttpRequest(url);
        String rs = HttpComponentUtil.execute(httpRequest);
        AMapGeoResultVo vo = JSON.parseObject(rs, AMapGeoResultVo.class);
        return vo;
    }

    /**
     * 逆地理编码：将经纬度转换为详细结构化的地址，且返回附近周边的POI、AOI信息。
     */
    public static AMapRegeocodeVo regeo(String location) {
        String url = REGEO_URL + "&location=" + location;
        HttpRequest httpRequest = new HttpRequest(url);
        String rs = HttpComponentUtil.execute(httpRequest);
        AMapRegeocodeVo vo = JSON.parseObject(rs, AMapRegeocodeVo.class);
        return vo;
    }



}
