package cc.lechun.framework.common.enums.trade;

import java.util.Arrays;
import java.util.List;

/**
 * Created by liqun on 2018/1/12.
 */
public enum OrderSourceEnum {
    CART(0,"购物车"),
    PLEASE_MILK(1, "请酸奶"),
    LONGPERIOD_BUY(2, "长期订购"),
    PROMOTION_BUY(3, "促销"),
    PLEASE_MILK_CHANGE(4, "请酸奶兑换"),
    GIFTCARD_PROMOTION(5,"礼品卡促销"),
    LIMIT_BUY(6,"限时特惠"),
    FULLCUT(7,"满减"),//新版的满减不再是独立的购买渠道，所有下单渠道都需要判断
    //MINI(8,"小程序");//不再使用
    //9地推现场购买 //不再使用
    //10开城 不再使用
    ORDER_PLAN(11,"订单管家"),
    FLASH_BUY(12,"闪购"),//拆单使用，现在也不需要了，所有下单渠道都需要判断
    STORE_BUY(13,"门店支付"),
    TEAM_BUY(14,"团购"),
    PRODUCT_BUY(15,"单品直接买"),
    GROUP_BUY(16,"套装直接买"),
    MILK_BANK_BUY(17,"酸奶库"),
    ACTIVE(18,"活动"),
    LIMIT_NO_DELIVER(19,"限时特惠不配送"),
    COLLAGE(20,"拼单"),
    NORMAT_FIT(21,"常温五块钱"),
    ALL_FIT(22,"全品类温五块钱"),
    CROWD(23,"众筹"),
    EXCLUSIVE(24,"企业专属活动"),
    CHARGECARD(25,"储值卡订单"),
    CARDPLAN(26,"奶卡实物订单"),
    CARD_PREPAY(27,"奶卡购卡订单"),
    CARD_PREPAY_TMALL(28,"奶卡-天猫实物订单"),
    CARD_PREPAY_JD_POP(29,"奶卡-京东pop实物订单"),
    CARD_PREPAY_CHANNEL(30,"奶卡-渠道实物订单"),
    CARD_PREPAY_JD_SELF_RUN(31,"奶卡-京东自营实物订单"),
    CARD_PREPAY_THIRD_PARTY_CHANNEL(32,"奶卡-第三方渠道实物订单"),
    CARD_PREPAY_THIRD_PARTY_STRATEGY(33,"奶卡-第三方战略实物订单"),
    CARD_PREPAY_SHOP(34,"奶卡-门店实物订单"),
    INVITE_GIFT(35,"邀请送礼"),
    RECHANGE_CARD(36,"兑换点卡"),//私域妈妈承接计划
    REUNION(37,"回收计划"),
    BUY_CARD(38,"购卡优惠"),
    //SPLITE_DELIVERY_ORDER(39,"购卡优惠后拆分实物订单"),
    SPLITE_CARD_ORDER(40,"购卡优惠后拆分购买卡订单"),
    COMMUNITY_GROUP(41,"社区团购");
    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<OrderSourceEnum> getList() {
        return Arrays.asList(OrderSourceEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        OrderSourceEnum[] ls = OrderSourceEnum.values();
        for (OrderSourceEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        OrderSourceEnum[] ls = OrderSourceEnum.values();
        for (OrderSourceEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    OrderSourceEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "OrderSourceEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
