package cc.lechun.framework.common.enums.cashticket;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/1/22
 * Description:优惠方式：0减额券；1折扣券；
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CashDiscountModeEnum {
    manjian(0, "满减劵"),
    zhekou(1, "折扣劵");

    private int value;
    private String name;

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        CashDiscountModeEnum[] ls = CashDiscountModeEnum.values();
        for (CashDiscountModeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    /**
     * 获取列表
     */
    public static List<CashDiscountModeEnum> getList() {
        return Arrays.asList(CashDiscountModeEnum.values());
    }

    CashDiscountModeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
