package cc.lechun.framework.common.vo;


import cc.lechun.framework.common.utils.SpringUtil;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import javax.servlet.http.HttpServletRequest;
/**
 *@ClassNameJedisUtils
 *@Description TODO
 *@Author
 *@Date
 *@Version 1.0
 **/
@RefreshScope
@Component
public class JedisUtils{


    protected static Logger logger = LoggerFactory.getLogger(JedisUtils.class);
    public static BaseUser getBaseUser(HttpServletRequest request) {
        BaseUser user = null;
        try {
            MallUserEntity v= SpringUtil.getBean(LoginUtils.class).getUser();
            user=new BaseUser();
            user.setId(v.getUserId());
            user.setUserName(v.getUserName());
            user.setEmployeeName(v.getUserNick());
        } catch (AuthorizeException e) {
            logger.error("获取用户信息失败:{}",e);
            return null;
        }
        return user;
    }
    public static BaseUser getBaseUser(String  id) {
        BaseUser user = null;

        try {
            MallUserEntity v= SpringUtil.getBean(LoginUtils.class).getUser();
            user=new BaseUser();
            user.setId(v.getUserId());
            user.setUserName(v.getUserName());
            user.setEmployeeName(v.getUserNick());
        } catch (AuthorizeException e) {
            logger.error("获取用户信息失败:{}",e);
            return null;
        }
        return user;
    }
}
