package cc.lechun.framework.common.enums.cashticket;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/1/22
 * Description:生成类型，1优惠码，2优惠券
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CashCreateTypeEnum {
    NoJuanCode(3, "领取时生成劵码"),
    juan(2, "创建时生成券码"),
    ma(1, "优惠码");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<CashCreateTypeEnum> getList() {
        return Arrays.asList(CashCreateTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        CashCreateTypeEnum[] ls = CashCreateTypeEnum.values();
        for (CashCreateTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    CashCreateTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
